/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.euca;

import divinerpg.entities.euca.LightWarriorEntity;
import java.util.EnumSet;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

class LightWarriorAttackGoal
extends Goal {
    private final LightWarriorEntity mob;
    private final double speedModifier;
    private LivingEntity target;
    private int attackCooldown;
    private int attackTimer;
    private LightWarriorEntity.AnimationState currentAttack;
    private int preparingTicks;

    public LightWarriorAttackGoal(LightWarriorEntity mob, double speedModifier, boolean followingTargetEvenIfNotSeen) {
        this.mob = mob;
        this.speedModifier = speedModifier;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        LivingEntity target = this.mob.m_5448_();
        return target != null && target.m_6084_();
    }

    public void m_8056_() {
        this.target = this.mob.m_5448_();
        this.attackCooldown = 0;
        this.attackTimer = 0;
    }

    public void m_8041_() {
        this.target = null;
        this.preparingTicks = 0;
        this.mob.m_21573_().m_26573_();
        this.mob.setAnimationState(LightWarriorEntity.AnimationState.IDLE);
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        double distanceSqr;
        boolean inRange;
        this.target = this.mob.m_5448_();
        if (this.target == null) {
            return;
        }
        if (this.attackTimer <= 0 && this.preparingTicks <= 0) {
            this.mob.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
            this.mob.m_21573_().m_5624_((Entity)this.target, this.speedModifier);
        }
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
        boolean bl = inRange = (distanceSqr = this.mob.m_20280_((Entity)this.target)) <= 36.0;
        if (inRange && this.attackCooldown <= 0 && this.attackTimer <= 0 && this.preparingTicks <= 0) {
            this.mob.m_21573_().m_26573_();
            this.preparingTicks = distanceSqr <= 4.2 ? 3 : 10;
        }
        if (this.preparingTicks > 0) {
            this.faceTarget();
            --this.preparingTicks;
            if (this.preparingTicks == 0) {
                this.startAttack();
            }
        }
        if (this.attackTimer > 0) {
            --this.attackTimer;
            if (this.currentAttack == LightWarriorEntity.AnimationState.ATTACK_1) {
                if (this.attackTimer == 12 - 3) {
                    this.dealDamage();
                }
            }
            if (this.currentAttack == LightWarriorEntity.AnimationState.ATTACK_2) {
                if (this.attackTimer == 13 - 3) {
                    this.dealDamage();
                }
            }
            if (this.currentAttack == LightWarriorEntity.AnimationState.ATTACK_3) {
                if (this.attackTimer == 12 - 3) {
                    this.dealDamage();
                }
            }
            if (this.attackTimer == 0) {
                this.mob.setAnimationState(LightWarriorEntity.AnimationState.IDLE);
                this.currentAttack = null;
            }
        }
    }

    private void faceTarget() {
        if (this.target != null) {
            double dX = this.target.m_20185_() - this.mob.m_20185_();
            double dZ = this.target.m_20189_() - this.mob.m_20189_();
            float targetYRot = (float)(Mth.m_14136_((double)dZ, (double)dX) * 57.29577951308232) - 90.0f;
            float newYRot = this.rotlerp(this.mob.m_146908_(), targetYRot, 90.0f);
            this.mob.m_146922_(newYRot);
            this.mob.m_5616_(newYRot);
        }
    }

    private float rotlerp(float startAngle, float endAngle, float maxChange) {
        float change = Mth.m_14177_((float)(endAngle - startAngle));
        if (change > maxChange) {
            change = maxChange;
        }
        if (change < -maxChange) {
            change = -maxChange;
        }
        return startAngle + change;
    }

    private void startAttack() {
        if (this.mob.m_20280_((Entity)this.target) <= 4.2) {
            this.currentAttack = LightWarriorEntity.AnimationState.ATTACK_1;
            this.attackTimer = 22;
            this.attackCooldown = 22;
        } else {
            int attackType = this.mob.m_217043_().m_188503_(3);
            switch (attackType) {
                case 0: {
                    this.currentAttack = LightWarriorEntity.AnimationState.ATTACK_1;
                    this.attackTimer = 22;
                    this.attackCooldown = 40;
                    break;
                }
                case 1: {
                    this.currentAttack = LightWarriorEntity.AnimationState.ATTACK_2;
                    this.attackTimer = 23;
                    this.attackCooldown = 60;
                    break;
                }
                case 2: {
                    this.currentAttack = LightWarriorEntity.AnimationState.ATTACK_3;
                    this.attackTimer = 23;
                    this.attackCooldown = 50;
                }
            }
        }
        this.mob.setAnimationState(this.currentAttack);
    }

    private void dealDamage() {
        if (this.currentAttack == null || this.target == null) {
            return;
        }
        switch (this.currentAttack) {
            case ATTACK_1: {
                Vec3 lookVec = this.mob.m_20252_(1.0f);
                Vec3 attackPos = this.mob.m_20182_().m_82549_(lookVec.m_82490_(2.5));
                AABB damageArea = new AABB(attackPos, attackPos).m_82377_(1.0, 1.0, 1.0).m_82369_(lookVec.m_82490_(4.0));
                this.mob.m_9236_().m_6443_(LivingEntity.class, damageArea, e -> e.equals((Object)this.target)).forEach(victim -> victim.m_6469_(this.mob.m_269291_().m_269333_((LivingEntity)this.mob), (float)this.mob.m_21133_(Attributes.f_22281_)));
                break;
            }
            case ATTACK_2: {
                Vec3 lookVec = this.mob.m_20252_(1.0f);
                Vec3 attackPos = this.mob.m_20182_().m_82549_(lookVec.m_82490_(1.5));
                AABB damageArea = new AABB(attackPos, attackPos).m_82377_(1.5, 1.0, 1.5);
                this.mob.m_9236_().m_6443_(LivingEntity.class, damageArea, e -> e != this.mob && e.m_6084_()).forEach(victim -> victim.m_6469_(this.mob.m_269291_().m_269333_((LivingEntity)this.mob), (float)this.mob.m_21133_(Attributes.f_22281_) * 1.5f));
                break;
            }
            case ATTACK_3: {
                AABB boundingBox = this.mob.m_20191_().m_82377_(4.0, 2.0, 4.0);
                this.mob.m_9236_().m_6443_(LivingEntity.class, boundingBox, e -> e != this.mob && e.m_6084_()).forEach(victim -> {
                    if (victim.m_20182_().m_82546_(this.mob.m_20182_()).m_82541_().m_82526_(this.mob.m_20252_(1.0f)) > -0.5) {
                        victim.m_6469_(this.mob.m_269291_().m_269333_((LivingEntity)this.mob), (float)this.mob.m_21133_(Attributes.f_22281_));
                    }
                });
                break;
            }
        }
    }
}

