/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.euca;

import divinerpg.entities.base.EntityDivineMonster;
import divinerpg.entities.euca.LightWarriorAttackGoal;
import divinerpg.entities.euca.LightWarriorShieldGoal;
import divinerpg.enums.EntityStats;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class LightWarriorEntity
extends EntityDivineMonster
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected static final int transitionTime = 3;
    public boolean isShielding = false;
    public boolean wannaUseShield = false;
    public int attackTick = 0;
    public int damageAnimationTick = 0;
    private static final EntityDataAccessor<Integer> ANIMATION_STATE = SynchedEntityData.m_135353_(LightWarriorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public LightWarriorEntity(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANIMATION_STATE, (Object)AnimationState.IDLE.ordinal());
    }

    public AnimationState getAnimationState() {
        return AnimationState.values()[(Integer)this.f_19804_.m_135370_(ANIMATION_STATE)];
    }

    public void setAnimationState(AnimationState state) {
        this.f_19804_.m_135381_(ANIMATION_STATE, (Object)state.ordinal());
    }

    public static AttributeSupplier.Builder createAttributes() {
        EntityStats stats = EntityStats.LIGHT_WARRIOR;
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, stats.getHealth()).m_22268_(Attributes.f_22277_, stats.getFollowRange()).m_22268_(Attributes.f_22279_, stats.getMovementSpeed()).m_22268_(Attributes.f_22281_, stats.getAttackDamage()).m_22268_(Attributes.f_22278_, 0.8);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new LightWarriorShieldGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new LightWarriorAttackGoal(this, 1.2, true));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12499_;
    }

    @NotNull
    protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
        return SoundEvents.f_12502_;
    }

    @NotNull
    protected SoundEvent m_5592_() {
        return SoundEvents.f_215779_;
    }

    public float m_6100_() {
        return 0.8f + this.f_19796_.m_188501_() * 0.4f;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.attackTick > 0) {
            --this.attackTick;
        }
        if (this.damageAnimationTick > 0) {
            --this.damageAnimationTick;
            if (this.damageAnimationTick == 0 && this.getAnimationState() == AnimationState.DAMAGE) {
                this.setAnimationState(AnimationState.IDLE);
            }
        }
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        boolean isAttacking;
        if (this.isShielding) {
            this.m_5496_(SoundEvents.f_12346_, 1.0f, 1.0f);
            return false;
        }
        boolean bl = isAttacking = this.getAnimationState() == AnimationState.ATTACK_1 || this.getAnimationState() == AnimationState.ATTACK_2 || this.getAnimationState() == AnimationState.ATTACK_3;
        if (this.m_21223_() <= this.m_21233_() * 0.75f && !this.wannaUseShield && !isAttacking && this.f_19796_.m_188501_() < 0.4f) {
            this.wannaUseShield = true;
        }
        this.setAnimationState(AnimationState.DAMAGE);
        this.damageAnimationTick = 10;
        return super.m_6469_(source, amount);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 3, this::predicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(software.bernie.geckolib.core.animation.AnimationState<T> event) {
        switch (this.getAnimationState()) {
            case ATTACK_1: {
                return event.setAndContinue(RawAnimation.begin().then("attack", Animation.LoopType.PLAY_ONCE));
            }
            case ATTACK_2: {
                return event.setAndContinue(RawAnimation.begin().then("attack2", Animation.LoopType.PLAY_ONCE));
            }
            case ATTACK_3: {
                return event.setAndContinue(RawAnimation.begin().then("attack3", Animation.LoopType.PLAY_ONCE));
            }
            case SHIELD: {
                return event.setAndContinue(RawAnimation.begin().then("shield", Animation.LoopType.PLAY_ONCE));
            }
            case DAMAGE: {
                return event.setAndContinue(RawAnimation.begin().then("damage", Animation.LoopType.PLAY_ONCE));
            }
        }
        if (event.isMoving()) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("walk"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("idle"));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static enum AnimationState {
        IDLE,
        ATTACK_1,
        ATTACK_2,
        ATTACK_3,
        SHIELD,
        DAMAGE,
        DEATH;

    }
}

