/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.euca;

import com.idark.valoria.registries.SoundsRegistry;
import divinerpg.entities.euca.ThunderbladeGuardianEntity;
import divinerpg.registries.SoundRegistry;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

class ThunderbladeGuardianAttackGoal
extends Goal {
    private final ThunderbladeGuardianEntity mob;
    private final double speedModifier;
    private LivingEntity target;
    private int attackCooldown;
    private int attackTimer;
    private ThunderbladeGuardianEntity.AnimationState currentAttack;
    private int preparingTicks;
    private int stuckTicks;
    private BlockPos lastPos = BlockPos.f_121853_;

    public ThunderbladeGuardianAttackGoal(ThunderbladeGuardianEntity mob, double speedModifier) {
        this.mob = mob;
        this.speedModifier = speedModifier;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        LivingEntity target = this.mob.m_5448_();
        return target != null && target.m_6084_() && this.mob.getAnimationState() != ThunderbladeGuardianEntity.AnimationState.DEATH;
    }

    public void m_8056_() {
        this.target = this.mob.m_5448_();
        this.attackCooldown = 0;
        this.attackTimer = 0;
        this.preparingTicks = 0;
        this.stuckTicks = 0;
    }

    public void m_8041_() {
        this.target = null;
        this.preparingTicks = 0;
        this.mob.m_21573_().m_26573_();
        this.mob.setAnimationState(ThunderbladeGuardianEntity.AnimationState.IDLE);
        this.mob.f_19794_ = false;
    }

    public boolean m_183429_() {
        return true;
    }

    private boolean isMovementAttack(ThunderbladeGuardianEntity.AnimationState state) {
        return state == ThunderbladeGuardianEntity.AnimationState.JUMP_ATTACK || state == ThunderbladeGuardianEntity.AnimationState.DASH_ATTACK || state == ThunderbladeGuardianEntity.AnimationState.BACKSTEP_ATTACK;
    }

    private void faceTarget() {
        if (this.target != null && !this.isMovementAttack(this.currentAttack)) {
            double dX = this.target.m_20185_() - this.mob.m_20185_();
            double dZ = this.target.m_20189_() - this.mob.m_20189_();
            float targetYRot = (float)(Mth.m_14136_((double)dZ, (double)dX) * 57.29577951308232) - 90.0f;
            float newYRot = this.rotlerp(this.mob.m_146908_(), targetYRot, 75.0f);
            this.mob.m_146922_(newYRot);
            this.mob.m_5616_(newYRot);
        }
    }

    private float rotlerp(float startAngle, float endAngle, float maxChange) {
        float change = Mth.m_14177_((float)(endAngle - startAngle));
        if (change > maxChange) {
            change = maxChange;
        }
        if (change < -maxChange) {
            change = -maxChange;
        }
        return startAngle + change;
    }

    private void startInstantAttack() {
        this.target.m_6469_(this.mob.m_269291_().m_269333_((LivingEntity)this.mob), (float)this.mob.m_21133_(Attributes.f_22281_) * 1.97f);
        this.attackCooldown = 8;
    }

    public void m_8037_() {
        this.target = this.mob.m_5448_();
        if (this.target == null || !this.target.m_6084_()) {
            return;
        }
        if (this.mob.wantsToDash && this.attackTimer <= 0 && this.preparingTicks <= 0) {
            this.mob.wantsToDash = false;
            this.setAttack(ThunderbladeGuardianEntity.AnimationState.DASH_ATTACK, 80, 70);
            return;
        }
        boolean isMovingAttack = this.isMovementAttack(this.currentAttack);
        if (!isMovingAttack) {
            this.faceTarget();
        }
        if (this.attackTimer <= 0 && this.preparingTicks <= 0) {
            this.mob.m_21573_().m_5624_((Entity)this.target, this.speedModifier);
            this.stuckTicks = !this.mob.m_21573_().m_26571_() && this.mob.m_20183_().equals((Object)this.lastPos) ? ++this.stuckTicks : 0;
            this.lastPos = this.mob.m_20183_();
        } else if (!isMovingAttack) {
            this.mob.m_21573_().m_26573_();
        }
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
        double distanceSqr = this.mob.m_20280_((Entity)this.target);
        if (this.attackCooldown <= 0 && this.attackTimer <= 0 && this.preparingTicks <= 0) {
            if (distanceSqr <= 6.25) {
                this.startInstantAttack();
            } else if (distanceSqr <= 144.0) {
                this.preparingTicks = 5;
            }
        }
        if (this.preparingTicks > 0) {
            --this.preparingTicks;
            if (this.preparingTicks == 0) {
                this.startAttack();
            }
        }
        if (this.attackTimer > 0) {
            --this.attackTimer;
            this.handleMovement();
            this.handleDamageTimings();
            if (this.attackTimer == 0) {
                this.mob.setAnimationState(ThunderbladeGuardianEntity.AnimationState.IDLE);
                this.currentAttack = null;
                this.mob.f_19794_ = false;
            }
        }
    }

    private void startAttack() {
        if (this.stuckTicks > 40) {
            this.setAttack(ThunderbladeGuardianEntity.AnimationState.JUMP_ATTACK, 50, 60);
            this.stuckTicks = 0;
            return;
        }
        double distanceSqr = this.mob.m_20280_((Entity)this.target);
        if (distanceSqr > 40.0) {
            this.setAttack(ThunderbladeGuardianEntity.AnimationState.DASH_ATTACK, 80, 70);
        } else {
            int attackType = this.mob.m_217043_().m_188503_(7);
            switch (attackType) {
                case 0: {
                    this.setAttack(ThunderbladeGuardianEntity.AnimationState.SWINGING_COMBO_1, 50, 40);
                    break;
                }
                case 1: {
                    this.setAttack(ThunderbladeGuardianEntity.AnimationState.SWINGING_COMBO_2, 50, 40);
                    break;
                }
                case 2: {
                    this.setAttack(ThunderbladeGuardianEntity.AnimationState.HEAVY_COMBO_1, 80, 60);
                    break;
                }
                case 3: {
                    this.setAttack(ThunderbladeGuardianEntity.AnimationState.HEAVY_COMBO_2, 60, 70);
                    break;
                }
                case 4: {
                    this.setAttack(ThunderbladeGuardianEntity.AnimationState.THRUST_COMBO_1, 50, 50);
                    break;
                }
                case 5: {
                    this.setAttack(ThunderbladeGuardianEntity.AnimationState.BACKSTEP_ATTACK, 50, 50);
                    break;
                }
                case 6: {
                    this.setAttack(ThunderbladeGuardianEntity.AnimationState.LIGHTNING_SPEAR, 50, 80);
                }
            }
        }
    }

    private void setAttack(ThunderbladeGuardianEntity.AnimationState state, int timer, int cooldown) {
        this.currentAttack = state;
        this.attackTimer = timer;
        this.attackCooldown = cooldown;
        this.mob.setAnimationState(this.currentAttack);
    }

    private void handleMovement() {
        if (this.currentAttack == null || this.target == null) {
            return;
        }
        float JUMP_DURATION = 22.0f;
        float DASH_DURATION = 40.0f;
        switch (this.currentAttack) {
            case JUMP_ATTACK: {
                boolean bl = this.mob.f_19794_ = (float)this.attackTimer > 22.0f;
                if ((float)this.attackTimer > 22.0f) {
                    double distanceToTarget = this.mob.m_20270_((Entity)this.target);
                    Vec3 vectorToTarget = this.target.m_20182_().m_82546_(this.mob.m_20182_()).m_82541_();
                    Vec3 lookVector = this.mob.m_20154_();
                    if (distanceToTarget < 4.0 || vectorToTarget.m_82526_(lookVector) < 0.0) {
                        this.attackTimer = 22;
                        this.mob.m_9236_().m_5594_(null, this.mob.m_20183_(), (SoundEvent)SoundRegistry.ROCK_IMPACT.get(), SoundSource.HOSTILE, 1.2f, 0.9f);
                        return;
                    }
                    this.mob.m_20256_(this.mob.m_20154_().m_82542_(1.05, 0.4, 1.05).m_82520_(0.0, 0.285, 0.0));
                    break;
                }
                if (this.attackTimer <= 0) break;
                this.mob.m_20256_(new Vec3(0.0, -1.0, 0.0));
                break;
            }
            case DASH_ATTACK: {
                if (!((float)this.attackTimer > 40.0f)) break;
                double distanceToTarget = this.mob.m_20270_((Entity)this.target);
                Vec3 vectorToTarget = this.target.m_20182_().m_82546_(this.mob.m_20182_()).m_82541_();
                Vec3 lookVector = this.mob.m_20154_();
                if (distanceToTarget < 3.0 || vectorToTarget.m_82526_(lookVector) < 0.0) {
                    this.mob.m_20256_(Vec3.f_82478_);
                    this.attackTimer = 40;
                    this.mob.m_9236_().m_5594_(null, this.mob.m_20183_(), (SoundEvent)SoundRegistry.ROCK_IMPACT.get(), SoundSource.HOSTILE, 1.0f, 1.1f);
                    return;
                }
                this.mob.m_20256_(lookVector.m_82542_(2.5, 0.1, 2.5));
                break;
            }
            case BACKSTEP_ATTACK: {
                if (this.attackTimer <= 40) break;
                this.mob.m_20256_(this.mob.m_20154_().m_82490_(-0.25));
            }
        }
    }

    private void handleDamageTimings() {
        int time = this.attackTimer;
        int transition = 2;
        switch (this.currentAttack) {
            case SWINGING_COMBO_1: {
                if (time != 32 - transition && time != 20 - transition) break;
                this.mob.m_9236_().m_5594_(null, this.mob.m_20183_(), (SoundEvent)SoundRegistry.SLASH1.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
                this.dealDamage(1.0f, 6.0f, false);
                break;
            }
            case SWINGING_COMBO_2: {
                if (time != 32 - transition && time != 15 - transition) break;
                this.mob.m_9236_().m_5594_(null, this.mob.m_20183_(), (SoundEvent)SoundsRegistry.SWIFTSLICE.get(), SoundSource.HOSTILE, 1.0f, 0.9f);
                this.dealDamage(1.0f, 6.5f, false);
                break;
            }
            case SWINGING_COMBO_3: {
                if (time != 32 - transition && time != 20 - transition) break;
                this.mob.m_9236_().m_5594_(null, this.mob.m_20183_(), (SoundEvent)SoundRegistry.SLASH1.get(), SoundSource.HOSTILE, 1.0f, 1.1f);
                this.dealDamage(1.2f, 5.5f, false);
                break;
            }
            case HEAVY_COMBO_1: {
                if (time != 36 - transition) break;
                this.mob.m_9236_().m_5594_(null, this.mob.m_20183_(), (SoundEvent)SoundRegistry.SLASH2.get(), SoundSource.HOSTILE, 1.5f, 0.8f);
                this.dealDamage(2.5f, 6.5f, false);
                break;
            }
            case HEAVY_COMBO_2: {
                if (time != 31 - transition) break;
                this.mob.m_9236_().m_5594_(null, this.mob.m_20183_(), (SoundEvent)SoundsRegistry.SWIFTSLICE.get(), SoundSource.HOSTILE, 1.5f, 0.9f);
                this.dealDamage(2.8f, 7.0f, false);
                break;
            }
            case THRUST_COMBO_1: {
                if (time != 27 - transition) break;
                this.mob.m_9236_().m_5594_(null, this.mob.m_20183_(), (SoundEvent)SoundRegistry.SLASH2.get(), SoundSource.HOSTILE, 1.2f, 1.2f);
                this.dealDamage(2.25f, 8.0f, true);
                break;
            }
            case JUMP_ATTACK: {
                if (time != 20 - transition) break;
                this.mob.m_9236_().m_5594_(null, this.mob.m_20183_(), (SoundEvent)SoundRegistry.ROCK_IMPACT.get(), SoundSource.HOSTILE, 1.5f, 1.0f);
                this.dealDamage(1.95f, 6.0f, false);
                break;
            }
            case DASH_ATTACK: {
                if (time != 35 - transition) break;
                this.mob.m_9236_().m_5594_(null, this.mob.m_20183_(), (SoundEvent)SoundRegistry.SLASH1.get(), SoundSource.HOSTILE, 1.2f, 0.8f);
                this.dealDamage(1.55f, 6.0f, false);
                break;
            }
            case BACKSTEP_ATTACK: {
                if (time != 22 - transition) break;
                this.mob.m_9236_().m_5594_(null, this.mob.m_20183_(), (SoundEvent)SoundsRegistry.SWIFTSLICE.get(), SoundSource.HOSTILE, 1.0f, 1.3f);
                this.dealDamage(2.1f, 8.0f, true);
                break;
            }
            case LIGHTNING_SPEAR: {
                ServerLevel serverLevel;
                Level level;
                if (time > 25 && time % 5 == 0) {
                    this.mob.m_9236_().m_5594_(null, this.mob.m_20183_(), (SoundEvent)SoundRegistry.ELECTRIC2.get(), SoundSource.HOSTILE, 1.0f, 0.95f);
                    level = this.mob.m_9236_();
                    if (level instanceof ServerLevel) {
                        serverLevel = (ServerLevel)level;
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175830_, this.mob.m_20208_(3.0), this.mob.m_20187_(), this.mob.m_20262_(3.0), 6, 0.0, 0.0, 0.0, 0.0);
                    }
                }
                if (time != 25 - transition) break;
                this.mob.m_9236_().m_5594_(null, this.mob.m_20183_(), (SoundEvent)SoundRegistry.ELECTRIC1.get(), SoundSource.HOSTILE, 1.5f, 1.0f);
                this.dealDamage(3.75f, 10.55f, false);
                level = this.mob.m_9236_();
                if (!(level instanceof ServerLevel)) break;
                serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123812_, this.mob.m_20185_(), this.mob.m_20186_() + 1.0, this.mob.m_20189_(), 2, 1.0, 1.0, 1.0, 0.0);
            }
        }
    }

    private void dealDamage(float damageMultiplier, float range, boolean isThrust) {
        if (this.target == null) {
            return;
        }
        Vec3 mobPos = this.mob.m_20182_().m_82520_(0.0, (double)(this.mob.m_20206_() / 2.0f), 0.0);
        Vec3 lookVec = this.mob.m_20154_();
        float width = isThrust ? 2.0f : range;
        AABB damageArea = new AABB(mobPos, mobPos).m_82369_(lookVec.m_82490_((double)range)).m_82377_((double)(width / 2.0f), 2.0, (double)(width / 2.0f));
        this.mob.m_9236_().m_6443_(Player.class, damageArea, e -> e.m_6084_() && !e.m_7306_((Entity)this.mob)).forEach(victim -> {
            if (!isThrust || victim.equals((Object)this.target)) {
                victim.m_6469_(this.mob.m_269291_().m_269333_((LivingEntity)this.mob), (float)this.mob.m_21133_(Attributes.f_22281_) * damageMultiplier);
            }
        });
    }
}

