/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.euca;

import divinerpg.entities.base.EntityDivineBoss;
import divinerpg.entities.euca.ThunderbladeGuardianAttackGoal;
import divinerpg.registries.SoundRegistry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ThunderbladeGuardianEntity
extends EntityDivineBoss
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected static final int transitionTime = 2;
    private int customDeathTime = 0;
    public boolean wantsToDash = false;
    private static final EntityDataAccessor<Integer> ANIMATION_STATE = SynchedEntityData.m_135353_(ThunderbladeGuardianEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public ThunderbladeGuardianEntity(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 1000;
        this.m_274367_(2.3333333f);
        if (!level.m_5776_()) {
            this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)SoundRegistry.EVIL_LAUGH.get(), SoundSource.HOSTILE, 1.5f, 1.0f);
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANIMATION_STATE, (Object)AnimationState.IDLE.ordinal());
    }

    public AnimationState getAnimationState() {
        return AnimationState.values()[(Integer)this.f_19804_.m_135370_(ANIMATION_STATE)];
    }

    public void setAnimationState(AnimationState state) {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        this.f_19804_.m_135381_(ANIMATION_STATE, (Object)state.ordinal());
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 9800.0).m_22268_(Attributes.f_22277_, 256.0).m_22268_(Attributes.f_22279_, 0.345).m_22268_(Attributes.f_22281_, 82.5).m_22268_(Attributes.f_22278_, 5.0);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new ThunderbladeGuardianAttackGoal(this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 12.0f));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public void m_6667_(@NotNull DamageSource cause) {
        if (!this.m_9236_().m_5776_() && this.getAnimationState() != AnimationState.DEATH) {
            this.setAnimationState(AnimationState.DEATH);
            this.m_21153_(0.01f);
            this.m_20095_();
            this.m_20331_(true);
            this.f_19864_ = false;
            this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12404_, SoundSource.HOSTILE, 1.0f, 0.7f);
        }
    }

    public boolean m_5825_() {
        return true;
    }

    @Override
    public void m_8119_() {
        if (this.getAnimationState() == AnimationState.DEATH) {
            ++this.customDeathTime;
            if (this.customDeathTime >= 100 && !this.m_9236_().m_5776_()) {
                DamageSource damageSource = this.f_20888_ != null ? this.m_269291_().m_269075_(this.f_20888_) : this.m_269291_().m_269264_();
                super.m_6667_(damageSource);
            }
            if (this.customDeathTime >= 105 && !this.m_9236_().m_5776_()) {
                this.m_142687_(Entity.RemovalReason.KILLED);
            }
            return;
        }
        super.m_8119_();
    }

    public boolean m_6094_() {
        return this.getAnimationState() != AnimationState.DEATH && super.m_6094_();
    }

    protected boolean m_6107_() {
        return this.getAnimationState() == AnimationState.DEATH || super.m_6107_();
    }

    protected void m_6475_(@NotNull DamageSource damageSrc, float damageAmount) {
        if (this.getAnimationState() == AnimationState.DEATH) {
            return;
        }
        Entity entity = damageSrc.m_7640_();
        if (entity instanceof LivingEntity) {
            boolean isAttacking;
            LivingEntity attacker = (LivingEntity)entity;
            double distanceSqr = this.m_20280_((Entity)attacker);
            boolean bl = isAttacking = this.getAnimationState() != AnimationState.IDLE && this.getAnimationState() != AnimationState.WALK;
            if (distanceSqr > 36.0 && !isAttacking && !this.wantsToDash && this.f_19796_.m_188501_() < 0.15f) {
                this.wantsToDash = true;
            }
        }
        super.m_6475_(damageSrc, damageAmount);
    }

    @NotNull
    protected SoundEvent m_7975_(@NotNull DamageSource source) {
        return switch (this.f_19796_.m_188503_(3)) {
            case 0 -> (SoundEvent)SoundRegistry.METAL_IMPACT1.get();
            case 1 -> (SoundEvent)SoundRegistry.METAL_IMPACT2.get();
            default -> (SoundEvent)SoundRegistry.METAL_IMPACT3.get();
        };
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("DeathTime", this.f_20919_);
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("DeathTime")) {
            this.f_20919_ = compound.m_128451_("DeathTime");
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(software.bernie.geckolib.core.animation.AnimationState<T> event) {
        if (this.getAnimationState() == AnimationState.DEATH) {
            event.getController().setAnimation(RawAnimation.begin().then("death", Animation.LoopType.PLAY_ONCE));
            return PlayState.CONTINUE;
        }
        if (event.isMoving() && this.getAnimationState() == AnimationState.IDLE) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("walk"));
            return PlayState.CONTINUE;
        }
        switch (this.getAnimationState()) {
            case IDLE: {
                event.getController().setAnimation(RawAnimation.begin().thenLoop("idle"));
                break;
            }
            case WALK: {
                event.getController().setAnimation(RawAnimation.begin().thenLoop("walk"));
                break;
            }
            case SWINGING_COMBO_1: {
                event.getController().setAnimation(RawAnimation.begin().then("swinging_combo_1", Animation.LoopType.PLAY_ONCE));
                break;
            }
            case SWINGING_COMBO_2: {
                event.getController().setAnimation(RawAnimation.begin().then("swinging_combo_2", Animation.LoopType.PLAY_ONCE));
                break;
            }
            case SWINGING_COMBO_3: {
                event.getController().setAnimation(RawAnimation.begin().then("swinging_combo_3", Animation.LoopType.PLAY_ONCE));
                break;
            }
            case SWINGING_COMBO_4: {
                event.getController().setAnimation(RawAnimation.begin().then("swinging_combo_4", Animation.LoopType.PLAY_ONCE));
                break;
            }
            case THRUST_COMBO_1: {
                event.getController().setAnimation(RawAnimation.begin().then("thrust_combo_1", Animation.LoopType.PLAY_ONCE));
                break;
            }
            case THRUST_COMBO_2: {
                event.getController().setAnimation(RawAnimation.begin().then("thrust_combo_2", Animation.LoopType.PLAY_ONCE));
                break;
            }
            case HEAVY_COMBO_1: {
                event.getController().setAnimation(RawAnimation.begin().then("heavy_combo_1", Animation.LoopType.PLAY_ONCE));
                break;
            }
            case HEAVY_COMBO_2: {
                event.getController().setAnimation(RawAnimation.begin().then("heavy_combo_2", Animation.LoopType.PLAY_ONCE));
                break;
            }
            case HEAVY_COMBO_3: {
                event.getController().setAnimation(RawAnimation.begin().then("heavy_combo_3", Animation.LoopType.PLAY_ONCE));
                break;
            }
            case JUMP_ATTACK: {
                event.getController().setAnimation(RawAnimation.begin().then("jump_attack", Animation.LoopType.PLAY_ONCE));
                break;
            }
            case DASH_ATTACK: {
                event.getController().setAnimation(RawAnimation.begin().then("dash_attack", Animation.LoopType.PLAY_ONCE));
                break;
            }
            case BACKSTEP_ATTACK: {
                event.getController().setAnimation(RawAnimation.begin().then("backstep_attack", Animation.LoopType.PLAY_ONCE));
                break;
            }
            case LIGHTNING_SPEAR: {
                event.getController().setAnimation(RawAnimation.begin().then("lightning_spear", Animation.LoopType.PLAY_ONCE));
            }
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static enum AnimationState {
        IDLE,
        WALK,
        SWINGING_COMBO_1,
        SWINGING_COMBO_2,
        SWINGING_COMBO_3,
        SWINGING_COMBO_4,
        THRUST_COMBO_1,
        THRUST_COMBO_2,
        HEAVY_COMBO_1,
        HEAVY_COMBO_2,
        HEAVY_COMBO_3,
        JUMP_ATTACK,
        DASH_ATTACK,
        BACKSTEP_ATTACK,
        LIGHTNING_SPEAR,
        DEATH;

    }
}

