/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.iceika;

import divinerpg.entities.ai.FactionTargetGoal;
import divinerpg.entities.base.EntityDivineMonster;
import divinerpg.entities.base.FactionEntity;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class EntityIceikaNPC
extends EntityDivineMonster
implements FactionEntity {
    protected static final EntityDataAccessor<Integer> ITEM = SynchedEntityData.m_135353_(EntityIceikaNPC.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected boolean important = false;

    public static String getItemName(int i) {
        return switch (i) {
            case 1 -> "oxdrite_pickaxe";
            case 2 -> "icicle_bane";
            case 3 -> "icicle_bow";
            case 4 -> "frozen_maul";
            case 5 -> "frost_sword";
            case 6 -> "frostking_sword";
            case 7 -> "frost_cannon";
            case 8 -> "fractite_cannon";
            case 9 -> "glacier_sword";
            case 10 -> "serenade_of_ice";
            case 11 -> "sabear_sabre";
            case 12 -> "blue_armor_pouch";
            default -> null;
        };
    }

    public EntityIceikaNPC(EntityType<? extends Monster> type, Level worldIn) {
        super(type, worldIn);
        this.m_21441_(BlockPathTypes.POWDER_SNOW, -1.0f);
    }

    protected abstract TagKey<Item> getAcceptedItems();

    protected abstract String getTradesLocation();

    protected abstract TagKey<Structure> getRaidTargets();

    protected abstract MobEffect getTargetEffect();

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        if (!(this instanceof RangedAttackMob)) {
            this.f_21345_.m_25352_(0, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        }
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, new FactionTargetGoal((Mob)this, this.getFaction(), true, !(this instanceof RangedAttackMob)));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    protected PathNavigation m_6037_(Level level) {
        GroundPathNavigation nav = new GroundPathNavigation((Mob)this, level);
        nav.m_26477_(true);
        nav.m_148214_(true);
        return nav;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ITEM, (Object)0);
    }

    public int heldItem() {
        return (Integer)this.f_19804_.m_135370_(ITEM);
    }

    public void setUnimportant() {
        this.important = false;
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack trade;
        ItemStack stack;
        if (this.getFaction().getReputation(player) > 5 && (stack = player.m_21120_(hand)).m_204117_(this.getAcceptedItems()) && (trade = this.getTradedItem(player)) != null) {
            if (!player.m_7500_()) {
                stack.m_41774_(1);
                player.m_21008_(hand, stack);
            }
            this.m_9236_().m_7967_((Entity)new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), trade));
            this.getFaction().modifyReputation(player, 1);
            return InteractionResult.CONSUME;
        }
        this.m_216990_(SoundEvents.f_12507_);
        return InteractionResult.FAIL;
    }

    private ItemStack getTradedItem(Player player) {
        ObjectArrayList tradedItems;
        if (player.m_9236_().m_5776_()) {
            return null;
        }
        ResourceLocation lootTableLocation = new ResourceLocation("divinerpg", this.getTradesLocation());
        LootParams lootparams = new LootParams.Builder((ServerLevel)player.m_9236_()).m_287286_(LootContextParams.f_81455_, (Object)player).m_287286_(LootContextParams.f_81460_, (Object)player.m_20182_()).m_287235_(LootContextParamSets.f_81413_);
        if (new LootContext.Builder(lootparams).m_287259_(lootTableLocation) != null && !(tradedItems = player.m_20194_().m_278653_().m_278676_(lootTableLocation).m_287195_(lootparams)).isEmpty()) {
            return (ItemStack)tradedItems.get(0);
        }
        return null;
    }

    public void m_6667_(DamageSource source) {
        int item;
        String drop;
        if (this.f_19796_.m_188503_(10) == 0 && (drop = EntityIceikaNPC.getItemName(item = ((Integer)this.f_19804_.m_135370_(ITEM)).intValue())) != null) {
            ItemStack i = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation("divinerpg", drop)));
            if (i.m_41763_()) {
                i.m_41721_(this.m_217043_().m_188503_(i.m_41776_()));
            }
            this.m_9236_().m_7967_((Entity)new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), i));
        }
        this.modifyReputationOnDeath(source);
        super.m_6667_(source);
    }

    @Override
    public void modifyReputationOnDeath(DamageSource source) {
        Level level;
        if (this.important && (level = this.m_9236_()) instanceof ServerLevel) {
            LivingEntity entity;
            Entity entity2;
            ServerLevel level2 = (ServerLevel)level;
            if (source.m_7640_() != null && (entity2 = source.m_7640_()) instanceof LivingEntity) {
                entity = (LivingEntity)entity2;
                entity.m_7292_(new MobEffectInstance(this.getTargetEffect(), -1, 0, false, false, true));
            }
            if (source.m_7639_() != null && (entity2 = source.m_7639_()) instanceof LivingEntity) {
                entity = (LivingEntity)entity2;
                entity.m_7292_(new MobEffectInstance(this.getTargetEffect(), -1, 0, false, false, true));
            }
        }
        FactionEntity.super.modifyReputationOnDeath(source);
    }

    public boolean m_6469_(DamageSource source, float f) {
        this.modifyReputationOnHurt(source, f);
        return super.m_6469_(source, f);
    }

    protected boolean m_8028_() {
        return false;
    }

    public boolean m_6785_(double d) {
        return false;
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("Important")) {
            this.important = tag.m_128471_("Important");
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("Important", this.important);
    }
}

