/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.iceika;

import divinerpg.entities.ai.AlertingHurtByTargetGoal;
import divinerpg.entities.ai.ProtectBabyFromPlayerGoal;
import divinerpg.entities.iceika.EntitySabear;
import divinerpg.entities.iceika.EntitySeng;
import divinerpg.registries.EntityRegistry;
import divinerpg.util.Utils;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.PolarBear;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraftforge.registries.ForgeRegistries;

public class EntityMamoth
extends Animal
implements NeutralMob {
    private static final EntityDataAccessor<Boolean> WANTS_TO_FLY = SynchedEntityData.m_135353_(EntityMamoth.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final Ingredient FOOD = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "brittle_grass"))});
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    @Nullable
    protected Vec3 pathfindPos;
    private UUID persistentAngerTarget;
    private int remainingPersistentAngerTime;

    public EntityMamoth(EntityType<? extends EntityMamoth> type, Level level) {
        super(type, level);
        this.m_21441_(BlockPathTypes.POWDER_SNOW, -1.0f);
        this.m_21441_(BlockPathTypes.DANGER_POWDER_SNOW, -1.0f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.25, true));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 2.0){

            protected boolean m_202729_() {
                return this.f_25684_.m_21188_() != null && this.f_25684_.m_6162_() || this.f_25684_.m_6060_();
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, FOOD, false));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new AlertingHurtByTargetGoal((PathfinderMob)this));
        this.f_21346_.m_25352_(2, (Goal)new ProtectBabyFromPlayerGoal((Mob)this));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((EntityMamoth)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Fox.class, 10, true, true, null));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, PolarBear.class, 10, true, true, null));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, EntitySeng.class, 10, true, true, null));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, EntitySabear.class, 10, true, true, null));
        this.f_21346_.m_25352_(5, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    public void m_8119_() {
        super.m_8119_();
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            this.m_21666_(level2, true);
            if (this.m_6162_()) {
                if (this.m_21188_() != null || ((Boolean)this.f_19804_.m_135370_(WANTS_TO_FLY)).booleanValue()) {
                    if (this.m_20096_()) {
                        this.m_20256_(this.m_20184_().m_82542_(1.1, 1.0, 1.1));
                        if (Math.pow(this.m_20184_().f_82479_, 2.0) + Math.pow(this.m_20184_().f_82481_, 2.0) > 8.0) {
                            this.m_20256_(this.m_20184_().m_82520_(0.0, 0.5, 0.0));
                        }
                    } else if (!this.m_20069_()) {
                        boolean blockedPath;
                        if (!this.m_20068_()) {
                            this.m_20242_(true);
                        }
                        if (this.m_21573_().m_26572_()) {
                            this.m_21573_().m_26573_();
                        }
                        boolean bl = blockedPath = this.f_19862_ || this.f_19863_;
                        if (!blockedPath) {
                            Vec3 futurePos = this.m_20182_().m_82520_(this.m_20184_().f_82479_, this.m_20184_().f_82480_, this.m_20184_().f_82481_);
                            BlockPos pos = new BlockPos((int)futurePos.f_82479_, (int)futurePos.f_82480_, (int)futurePos.f_82481_);
                            BlockState state = this.m_9236_().m_8055_(pos);
                            boolean bl2 = blockedPath = state.m_60713_(Blocks.f_49991_) || !state.m_60812_((BlockGetter)this.m_9236_(), pos).equals(Shapes.m_83040_());
                        }
                        if (this.pathfindPos == null || blockedPath) {
                            this.pathfindPos = new Vec3(this.m_20185_() + (double)((this.f_19796_.m_188501_() - 0.5f) * 14.0f), this.m_20186_() + (double)((this.f_19796_.m_188501_() - 0.6f) * 14.0f), this.m_20189_() + (double)((this.f_19796_.m_188501_() - 0.5f) * 14.0f));
                        }
                        double speed = this.m_21133_(Attributes.f_22280_);
                        this.m_20334_(this.m_20184_().f_82479_ + (this.pathfindPos.f_82479_ - this.m_20185_()) / 64.0 * speed, this.m_20184_().f_82480_ + (this.pathfindPos.f_82480_ - this.m_20186_()) / 64.0 * speed, this.m_20184_().f_82481_ + (this.pathfindPos.f_82481_ - this.m_20189_()) / 64.0 * speed);
                        double distanceX = this.pathfindPos.f_82479_ - this.m_20185_();
                        double distanceY = this.pathfindPos.f_82480_ - this.m_20186_();
                        double distanceZ = this.pathfindPos.f_82481_ - this.m_20189_();
                        this.f_19857_ = Utils.rotlerp(this.f_19857_, (float)(Mth.m_14136_((double)distanceZ, (double)distanceX) * 180.0 / Math.PI) - 90.0f, 90.0f);
                        this.f_19858_ = Utils.rotlerp(this.f_19858_, (float)(-(Mth.m_14136_((double)distanceY, (double)Math.sqrt(distanceX * distanceX + distanceZ * distanceZ)) * 180.0 / Math.PI)), 20.0f);
                        if (Math.sqrt(this.m_20238_(this.pathfindPos)) < 2.0) {
                            this.pathfindPos = null;
                        }
                        this.f_19789_ = 0.0f;
                    }
                } else {
                    if (this.m_20068_()) {
                        this.m_20242_(false);
                    }
                    if (this.m_20184_().f_82480_ < 0.0) {
                        this.m_20256_(this.m_20184_().m_82542_(1.0, 0.6, 1.0));
                        this.f_19789_ = 0.0f;
                    }
                }
                if (this.f_19796_.m_188503_(100) == 0) {
                    this.f_19804_.m_135381_(WANTS_TO_FLY, (Object)((Boolean)this.f_19804_.m_135370_(WANTS_TO_FLY) == false ? 1 : 0));
                    this.m_6703_(null);
                }
            } else if (this.m_20068_()) {
                this.m_20242_(false);
            }
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(WANTS_TO_FLY, (Object)false);
    }

    public boolean m_7327_(Entity entity) {
        boolean hurt = entity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)((int)this.m_21133_(Attributes.f_22281_)));
        if (hurt) {
            this.m_19970_((LivingEntity)this, entity);
        }
        return hurt;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance instance, MobSpawnType type, SpawnGroupData data, CompoundTag tag) {
        if (data == null) {
            data = new AgeableMob.AgeableMobGroupData(1.0f);
        }
        return super.m_6518_(level, instance, type, data, tag);
    }

    public AgeableMob m_142606_(ServerLevel level, AgeableMob mob) {
        return (AgeableMob)((EntityType)EntityRegistry.MAMOTH.get()).m_20615_((Level)level);
    }

    public float m_6134_() {
        return this.m_6162_() ? 0.3f : 1.0f;
    }

    public boolean m_6898_(ItemStack stack) {
        return FOOD.test(stack);
    }

    public int m_6784_() {
        return this.remainingPersistentAngerTime;
    }

    public void m_7870_(int i) {
        this.remainingPersistentAngerTime = i;
    }

    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(UUID target) {
        this.persistentAngerTarget = target;
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.m_147285_(this.m_9236_(), tag);
        if (tag.m_128441_("wants_to_fly")) {
            this.f_19804_.m_135381_(WANTS_TO_FLY, (Object)tag.m_128471_("wants_to_fly"));
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        this.m_21678_(tag);
        if (this.m_6162_()) {
            tag.m_128379_("wants_to_fly", ((Boolean)this.f_19804_.m_135370_(WANTS_TO_FLY)).booleanValue());
        }
    }
}

