/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.iceika;

import divinerpg.entities.base.EntityDivineFlyingMob;
import divinerpg.entities.base.EntityDivineMonster;
import divinerpg.entities.boss.EntityKitra;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.Level;

public class EntityRobbin
extends EntityDivineFlyingMob {
    private int wingFlapTicks;
    private static final int TICKS_PER_MINUTE = 1200;
    private int tiredTicks = 0;
    private int tiredThreshold = 0;

    public EntityRobbin(EntityType<? extends EntityDivineFlyingMob> entityType, Level world) {
        super((EntityType<? extends EntityDivineMonster>)entityType, world);
        this.f_21342_ = new MoveControl((Mob)this);
        this.m_20242_(true);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new FollowWhaleGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new GoalRideWhaleWhenTired(this));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, EntityKitra.class, 6.0f));
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 0.4375f;
    }

    public boolean m_7296_(int i) {
        return i > 6;
    }

    public void m_8119_() {
        EntityKitra nearbyWhale;
        super.m_8119_();
        if (this.m_9236_().m_5776_() && this.wingFlapTicks > 0) {
            --this.wingFlapTicks;
        }
        ++this.tiredTicks;
        if (this.tiredTicks >= this.tiredThreshold && (nearbyWhale = (EntityKitra)this.m_9236_().m_45963_(EntityKitra.class, TargetingConditions.f_26872_, (LivingEntity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_20191_().m_82400_(32.0))) == null) {
            this.tiredThreshold = this.m_9236_().m_213780_().m_188503_(2400);
            this.tiredTicks = 0;
        }
    }

    public boolean isTired() {
        return this.tiredThreshold > 900;
    }

    class FollowWhaleGoal
    extends Goal {
        private static final double FOLLOW_DISTANCE = 32.0;
        private static final double CIRCLE_RADIUS = 5.0;
        private EntityRobbin entityRobbin;
        private EntityKitra targetWhale;

        public FollowWhaleGoal(EntityRobbin entityRobbin) {
            this.entityRobbin = entityRobbin;
        }

        public boolean m_8036_() {
            if (this.targetWhale == null || !this.targetWhale.m_6084_()) {
                this.targetWhale = (EntityKitra)this.entityRobbin.m_9236_().m_45963_(EntityKitra.class, TargetingConditions.f_26872_, (LivingEntity)this.entityRobbin, this.entityRobbin.m_20185_(), this.entityRobbin.m_20186_(), this.entityRobbin.m_20189_(), this.entityRobbin.m_20191_().m_82400_(32.0));
            }
            return this.targetWhale != null;
        }

        public void m_8056_() {
            this.entityRobbin.m_21573_().m_26573_();
        }

        public void m_8037_() {
            double distanceToWhale = this.entityRobbin.m_20270_((Entity)this.targetWhale);
            if (distanceToWhale <= 32.0) {
                double angleToWhale = Math.atan2(this.targetWhale.m_20189_() - this.entityRobbin.m_20189_(), this.targetWhale.m_20185_() - this.entityRobbin.m_20185_());
                double circleX = this.targetWhale.m_20185_() + 5.0 * Math.cos(angleToWhale);
                double circleY = this.targetWhale.m_20186_() + 5.0;
                double circleZ = this.targetWhale.m_20189_() + 5.0 * Math.sin(angleToWhale);
                this.entityRobbin.m_21573_().m_26519_(circleX, circleY, circleZ, 1.0);
            } else {
                this.entityRobbin.m_21573_().m_5624_((Entity)this.targetWhale, 1.0);
            }
        }

        public void m_8041_() {
            this.entityRobbin.m_21573_().m_26573_();
        }
    }

    public class GoalRideWhaleWhenTired
    extends Goal {
        private final EntityRobbin robbin;
        private EntityKitra whale;
        private int rideTime;
        private int rideTimeThreshold = 200;

        public GoalRideWhaleWhenTired(EntityRobbin robbin) {
            this.robbin = robbin;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return this.robbin.isTired() && this.robbin.m_6688_() == null;
        }

        public void m_8056_() {
            this.whale = (EntityKitra)this.robbin.m_9236_().m_45963_(EntityKitra.class, TargetingConditions.f_26872_, (LivingEntity)this.robbin, this.robbin.m_20185_(), this.robbin.m_20186_(), this.robbin.m_20189_(), this.robbin.m_20191_().m_82400_(16.0));
            this.rideTime = 0;
        }

        public void m_8041_() {
            this.robbin.m_8127_();
            this.whale = null;
            this.rideTime = 0;
        }

        public boolean m_8045_() {
            return this.robbin.isTired() && this.whale != null && !this.whale.m_20069_() && this.rideTime < this.rideTimeThreshold;
        }

        public void m_8037_() {
            if (this.whale != null) {
                this.robbin.m_21573_().m_5624_((Entity)this.whale, 1.0);
                this.robbin.m_21563_().m_24960_((Entity)this.whale, 30.0f, 30.0f);
            }
            ++this.rideTime;
            if (this.robbin.m_20069_()) {
                this.m_8041_();
            }
        }
    }
}

