/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.iceika;

import divinerpg.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;

public class EntitySnowSkipper
extends PathfinderMob {
    BlockPos pathfindPos;
    BlockPos afraidPos;
    boolean wantsToRest = false;

    public EntitySnowSkipper(EntityType<? extends EntitySnowSkipper> type, Level worldIn) {
        super(type, worldIn);
        this.m_21441_(BlockPathTypes.POWDER_SNOW, 1.0f);
        this.m_21441_(BlockPathTypes.DANGER_POWDER_SNOW, 1.0f);
    }

    public boolean m_6914_(LevelReader worldIn) {
        return true;
    }

    public boolean m_5545_(LevelAccessor level, MobSpawnType type) {
        BlockState state = level.m_8055_(this.m_20183_());
        return state.m_60713_(Blocks.f_152499_) || state.m_60795_() && level.m_8055_(this.m_20183_().m_7495_()).m_60713_(Blocks.f_152499_);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new SkipperStrollGoal(this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new SkipperAvoidGoal(this));
    }

    protected void m_8024_() {
        Player player;
        BlockPos p = null;
        if (this.m_21188_() != null && this.m_20182_().m_82554_(this.m_21188_().m_20182_()) < 5.0) {
            p = this.m_21188_().m_20183_();
        }
        if ((player = this.m_9236_().m_45930_((Entity)this, 5.0)) != null) {
            p = player.m_20183_();
        }
        this.afraidPos = p;
        if (p != null) {
            this.wantsToRest = false;
        } else if (this.f_19796_.m_188503_(100) == 0) {
            boolean bl = this.wantsToRest = !this.wantsToRest;
        }
        if (this.m_9236_().m_8055_(this.m_20183_()).m_60713_(Blocks.f_152499_)) {
            if (!this.m_20068_()) {
                this.m_20242_(true);
            }
            this.travel();
        } else {
            if (this.m_20068_()) {
                this.m_20242_(false);
            }
            if (this.m_9236_().m_8055_(this.m_20183_().m_7495_()).m_60713_(Blocks.f_152499_) && !this.wantsToRest) {
                this.travel();
            }
        }
    }

    void travel() {
        boolean blockedPath;
        Vec3 futurePos = this.m_20182_().m_82520_(this.m_20184_().f_82479_ * 2.0, this.m_20184_().f_82480_ * 2.0, this.m_20184_().f_82481_ * 2.0);
        BlockPos pos = new BlockPos((int)futurePos.f_82479_, (int)futurePos.f_82480_, (int)futurePos.f_82481_);
        BlockState state = this.m_9236_().m_8055_(pos);
        boolean bl = blockedPath = !state.m_60713_(Blocks.f_152499_) && (state.m_60713_(Blocks.f_49991_) || !state.m_60812_((BlockGetter)this.m_9236_(), pos).equals(Shapes.m_83040_()));
        if (this.pathfindPos == null || blockedPath) {
            int dz;
            int dx;
            if (this.afraidPos == null) {
                dx = 0;
                dz = 0;
            } else {
                dx = this.afraidPos.m_123341_() - (int)(this.m_20185_() * this.f_19796_.m_188500_() * 1.5);
                dz = this.afraidPos.m_123343_() - (int)(this.m_20189_() * this.f_19796_.m_188500_() * 1.5);
            }
            this.pathfindPos = new BlockPos((int)(this.m_20185_() + (double)((this.f_19796_.m_188501_() - 0.5f) * 8.0f)) - dx, (int)(this.m_20186_() + (double)((this.f_19796_.m_188501_() - 0.6f) * 8.0f)), (int)(this.m_20189_() + (double)((this.f_19796_.m_188501_() - 0.5f) * 8.0f)) - dz);
        }
        if (this.pathfindPos != null) {
            double speed = this.m_21133_(Attributes.f_22280_);
            double distanceX = (double)this.pathfindPos.m_123341_() - this.m_20185_();
            double distanceY = (double)this.pathfindPos.m_123342_() - this.m_20186_() + (this.wantsToRest ? 0.3 : 0.0);
            double distanceZ = (double)this.pathfindPos.m_123343_() - this.m_20189_();
            double distance = Math.sqrt(distanceX * distanceX + distanceY * distanceY + distanceZ * distanceZ);
            this.m_20334_(this.m_20184_().f_82479_ + distanceX / distance * speed, this.m_20184_().f_82480_ + distanceY / distance * speed, this.m_20184_().f_82481_ + distanceZ / distance * speed);
            this.f_19857_ = Utils.rotlerp(this.f_19857_, (float)(Mth.m_14136_((double)distanceZ, (double)distanceX) * 180.0 / Math.PI) - 90.0f, 90.0f);
            this.f_19858_ = Utils.rotlerp(this.f_19858_, (float)(-(Mth.m_14136_((double)distanceY, (double)Math.sqrt(distanceX * distanceX + distanceZ * distanceZ)) * 180.0 / Math.PI)), 20.0f);
            if (distance < 1.0) {
                this.pathfindPos = null;
            }
        }
    }

    protected void m_6475_(DamageSource source, float f) {
        this.wantsToRest = false;
        super.m_6475_(source, f);
    }

    public boolean m_6673_(DamageSource source) {
        return source.m_276093_(DamageTypes.f_268722_) || source.m_276093_(DamageTypes.f_268612_) && this.m_9236_().m_8055_(this.m_20183_()).m_60713_(Blocks.f_152499_) || super.m_6673_(source);
    }

    public boolean m_142079_() {
        return false;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("wants_to_rest", this.wantsToRest);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("wants_to_rest")) {
            this.wantsToRest = tag.m_128471_("wants_to_rest");
        }
    }

    static class SkipperStrollGoal
    extends WaterAvoidingRandomStrollGoal {
        public SkipperStrollGoal(PathfinderMob mob, double speedModifier) {
            super(mob, speedModifier);
        }

        public boolean m_8036_() {
            return !this.f_25725_.m_9236_().m_8055_(this.f_25725_.m_20183_()).m_60713_(Blocks.f_152499_) && !this.f_25725_.m_9236_().m_8055_(this.f_25725_.m_20183_().m_7495_()).m_60713_(Blocks.f_152499_) && super.m_8036_();
        }

        public boolean m_8045_() {
            return !this.f_25725_.m_9236_().m_8055_(this.f_25725_.m_20183_()).m_60713_(Blocks.f_152499_) && !this.f_25725_.m_9236_().m_8055_(this.f_25725_.m_20183_().m_7495_()).m_60713_(Blocks.f_152499_) && super.m_8045_();
        }
    }

    static class SkipperAvoidGoal
    extends AvoidEntityGoal<Player> {
        public SkipperAvoidGoal(PathfinderMob mob) {
            super(mob, Player.class, 6.0f, 1.0, 1.2);
        }

        public boolean m_8036_() {
            return !this.f_25015_.m_9236_().m_8055_(this.f_25015_.m_20183_()).m_60713_(Blocks.f_152499_) && !this.f_25015_.m_9236_().m_8055_(this.f_25015_.m_20183_().m_7495_()).m_60713_(Blocks.f_152499_) && super.m_8036_();
        }

        public boolean m_8045_() {
            return !this.f_25015_.m_9236_().m_8055_(this.f_25015_.m_20183_()).m_60713_(Blocks.f_152499_) && !this.f_25015_.m_9236_().m_8055_(this.f_25015_.m_20183_().m_7495_()).m_60713_(Blocks.f_152499_) && super.m_8045_();
        }
    }
}

