/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.projectile;

import divinerpg.entities.projectile.DivineThrowable;
import divinerpg.enums.BulletType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;

public class EntityShooterBullet
extends DivineThrowable {
    private static final EntityDataAccessor<Byte> BULLET_ID = SynchedEntityData.m_135353_(EntityShooterBullet.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private BulletType bulletType;

    public EntityShooterBullet(EntityType<? extends ThrowableProjectile> type, Level world) {
        super(type, world);
    }

    public EntityShooterBullet(EntityType<? extends ThrowableProjectile> type, LivingEntity entity, Level world, BulletType bulletType) {
        super(type, entity, world);
        this.bulletType = bulletType;
        this.setBulletId((byte)bulletType.ordinal());
    }

    @Override
    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BULLET_ID, (Object)0);
    }

    @Override
    public void m_5790_(EntityHitResult result) {
        if (this.f_19797_ != 1 || this.f_19797_ != 0) {
            if (result.m_82443_() != null) {
                Entity entity = result.m_82443_();
                entity.m_6469_(entity.m_9236_().m_269111_().m_269390_((Entity)this, this.m_19749_()), this.getBulletType().getDamage());
            }
            if (!this.m_9236_().m_5776_()) {
                this.m_6074_();
            }
        }
    }

    public boolean m_20223_(CompoundTag compound) {
        super.m_20223_(compound);
        compound.m_128344_("projectileId", this.getBulletId());
        return false;
    }

    public void m_20258_(CompoundTag compound) {
        super.m_20258_(compound);
        this.setBulletId(compound.m_128445_("projectileId"));
        this.bulletType = BulletType.getBulletFromOrdinal(this.getBulletId());
    }

    private byte getBulletId() {
        return (Byte)this.f_19804_.m_135370_(BULLET_ID);
    }

    private void setBulletId(byte projectileId) {
        this.f_19804_.m_135381_(BULLET_ID, (Object)projectileId);
    }

    public BulletType getBulletType() {
        if (this.bulletType == null) {
            this.bulletType = BulletType.getBulletFromOrdinal(this.getBulletId());
        }
        return this.bulletType;
    }

    public ResourceLocation getTexture() {
        return this.getBulletType().getTexture();
    }
}

