/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.projectile.arrow;

import com.idark.valoria.client.particle.ParticleEffects;
import divinerpg.registries.MobEffectRegistry;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import pro.komaru.tridot.api.interfaces.TexturedArrow;
import pro.komaru.tridot.client.gfx.particle.GenericParticle;
import pro.komaru.tridot.client.gfx.particle.data.ColorParticleData;
import pro.komaru.tridot.common.registry.entity.projectiles.AbstractTridotArrow;
import pro.komaru.tridot.util.Col;

public class EnderArrow
extends AbstractTridotArrow
implements TexturedArrow {
    public EnderArrow(EntityType<? extends AbstractArrow> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.addEffect(new MobEffectInstance((MobEffect)MobEffectRegistry.CHAINED.get(), 200));
    }

    public void spawnParticlesTrail() {
        if (!this.f_36703_) {
            Vec3 vector3d = this.m_20184_();
            double a3 = vector3d.f_82479_;
            double a4 = vector3d.f_82480_;
            double a0 = vector3d.f_82481_;
            Vec3 pos = new Vec3(this.m_20185_() + a3 * 0.5, this.m_20186_() + a4 * 0.5, this.m_20189_() + a0 * 0.5);
            ParticleEffects.trailMotionSparks((Level)this.m_9236_(), (Vec3)pos, (ColorParticleData)ColorParticleData.create((Col)Col.fromHex((String)"7319e1"), (Col)Col.fromHex((String)"591aeb")).build());
        }
    }

    @NotNull
    private Consumer<GenericParticle> getGenericParticleConsumer(Vec3 pos) {
        Vec3[] cachePos = new Vec3[]{new Vec3(pos.f_82479_, pos.f_82480_, pos.f_82481_)};
        return p -> {
            Vec3 arrowPos = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
            float lenBetweenArrowAndParticle = (float)arrowPos.m_82546_(cachePos[0]).m_82553_();
            Vec3 vector = arrowPos.m_82546_(cachePos[0]);
            if (lenBetweenArrowAndParticle > 0.0f) {
                cachePos[0] = cachePos[0].m_82549_(vector);
                p.setPosition(cachePos[0]);
            }
        };
    }

    public ResourceLocation getTexture() {
        return new ResourceLocation("divinerpg", "textures/projectiles/hunter_arrow.png");
    }
}

