/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.projectile.arrow;

import divinerpg.enums.ArrowType;
import divinerpg.registries.ParticleRegistry;
import java.util.Objects;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class EntityDivineArrow
extends AbstractArrow {
    private static final EntityDataAccessor<Byte> CRITICAL = SynchedEntityData.m_135353_(EntityDivineArrow.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Byte> ARROW_ID = SynchedEntityData.m_135353_(EntityDivineArrow.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private int xTile = -1;
    private int yTile = -1;
    private Block inTile;
    private int zTile = -1;
    protected boolean inGround;
    protected int timeInGround;
    public AbstractArrow.Pickup pickupStatus = AbstractArrow.Pickup.DISALLOWED;
    public int arrowShake;
    public Entity shootingEntity;
    private int ticksInGround;
    public double damageMin;
    public double damageMax;
    private int knockbackStrength;
    private ArrowType arrowType;
    public Item ammoItem;

    public EntityDivineArrow(EntityType<? extends AbstractArrow> type, Level world) {
        super(type, world);
    }

    public EntityDivineArrow(EntityType<? extends AbstractArrow> type, Level world, ArrowType arrowType, double x, double y, double z) {
        this(type, world);
        this.arrowType = arrowType;
        this.setArrowId((byte)arrowType.ordinal());
        this.damageMin = arrowType.getMinDamage();
        this.damageMax = arrowType.getMaxDamage();
        this.m_6034_(x, y, z);
    }

    public EntityDivineArrow(EntityType<? extends AbstractArrow> type, Level world, ArrowType arrowType, LivingEntity shooter) {
        this(type, world, arrowType, shooter.f_19854_, shooter.f_19855_ + (double)shooter.m_20192_() - (double)0.1f, shooter.f_19856_);
        this.shootingEntity = shooter;
        this.m_5602_((Entity)shooter);
    }

    public EntityDivineArrow(EntityType<? extends AbstractArrow> type, Level worldIn, ArrowType arrowType, LivingEntity shooter, LivingEntity target, float velocity, float inaccuracy) {
        this(type, worldIn, arrowType, shooter);
        Vec3 vector3d = this.m_20252_(1.0f);
        double d0 = target.m_20185_() - (this.m_20185_() + vector3d.f_82479_ * 4.0);
        double d1 = target.m_20227_(0.5) - (0.5 + this.m_20227_(0.5));
        double d2 = target.m_20189_() - (this.m_20189_() + vector3d.f_82481_ * 4.0);
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        this.m_6686_(d0, d1 + d3 * (double)0.2f, d2, velocity, inaccuracy);
        this.m_5496_(SoundEvents.f_12382_, 1.0f, 1.0f / (this.f_19796_.m_188501_() * 0.4f + 0.8f));
        this.shootingEntity = shooter;
        this.m_5602_((Entity)shooter);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CRITICAL, (Object)0);
        this.f_19804_.m_135372_(ARROW_ID, (Object)0);
    }

    public void m_6686_(double x, double y, double z, float velocity, float inaccuracy) {
        super.m_6686_(x, y, z, velocity, inaccuracy);
        this.ticksInGround = 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_20334_(double x, double y, double z) {
        super.m_20334_(x, y, z);
        if (this.f_19860_ == 0.0f && this.f_19859_ == 0.0f) {
            float f = Mth.m_14116_((float)((float)(x * x + z * z)));
            this.f_19858_ = (float)(Mth.m_14136_((double)y, (double)f) * 57.29577951308232);
            this.f_19857_ = (float)(Mth.m_14136_((double)x, (double)z) * 57.29577951308232);
            this.f_19860_ = this.f_19858_;
            this.f_19859_ = this.f_19857_;
            this.m_7678_(this.f_19854_, this.f_19855_, this.f_19856_, this.f_19857_, this.f_19858_);
            this.ticksInGround = 0;
        }
    }

    public void m_8119_() {
        BlockState state;
        super.m_8119_();
        if (this.getArrowType() == ArrowType.ETERNAL_ARCHER_FLAME_ARROW) {
            this.spawnParticle((ParticleOptions)ParticleTypes.f_123744_);
        } else if (this.getArrowType() == ArrowType.ETERNAL_ARCHER_WITHER_ARROW) {
            this.spawnParticle((ParticleOptions)ParticleRegistry.BLACK_FLAME.get());
        }
        if (this.f_19860_ == 0.0f && this.f_19859_ == 0.0f) {
            Vec3 motion = this.m_20184_();
            this.f_19857_ = (float)(Mth.m_14136_((double)motion.f_82479_, (double)motion.f_82481_) * 57.29577951308232);
            this.f_19858_ = (float)(Mth.m_14136_((double)motion.f_82480_, (double)motion.m_165924_()) * 57.29577951308232);
            this.f_19859_ = this.f_19857_;
            this.f_19860_ = this.f_19858_;
        }
        if (this.inGround) {
            ++this.ticksInGround;
            if (this.ticksInGround >= 200 && this.getArrowType() == ArrowType.PALE_ARCHER_ARROW || this.ticksInGround >= 1200) {
                this.m_146870_();
            }
            return;
        }
        if (this.m_20184_().m_82556_() < 0.01 && (state = this.m_9236_().m_8055_(this.m_20183_())).m_280296_()) {
            this.inGround = true;
            this.m_6034_(this.m_20185_(), this.m_20186_() + 0.05, this.m_20189_());
        }
        if (!this.m_20068_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.05, 0.0));
        }
        if (this.m_20096_()) {
            this.m_6034_(this.m_20185_(), this.m_20186_() + 0.05, this.m_20189_());
        }
    }

    private void spawnParticle(ParticleOptions particleType) {
        double x = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 0.5;
        double y = this.m_20186_() + (this.f_19796_.m_188500_() - 0.5) * 0.5;
        double z = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 0.5;
        this.m_9236_().m_7106_(particleType, x, y, z, 0.0, 0.0, 0.0);
    }

    protected void m_5790_(@NotNull EntityHitResult result) {
        super.m_5790_(result);
        Entity hitEntity = result.m_82443_();
        if (hitEntity instanceof LivingEntity) {
            DamageSource damageSource;
            LivingEntity entity = (LivingEntity)hitEntity;
            float velocity = (float)this.m_20184_().m_82553_();
            int damage = Mth.m_14165_((double)Mth.m_14008_((double)((double)velocity * this.damageMin), (double)0.0, (double)2.147483647E9));
            if ((double)damage > this.damageMax) {
                damage = Mth.m_14165_((double)this.damageMax);
            }
            if (this.getIsCritical()) {
                damage += this.f_19796_.m_188503_(damage / 2 + 2);
            }
            ArrowType.ArrowSpecial specialType = this.getArrowType().getArrowSpecial();
            switch (specialType) {
                case WITHER: {
                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 100, 2));
                    break;
                }
                case SLOW: {
                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 100, 2));
                    break;
                }
                case BLIND: {
                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 100, 0));
                    break;
                }
                case NAUSEA: {
                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 200, 0));
                }
            }
            if (!(entity instanceof EnderMan)) {
                if (specialType == ArrowType.ArrowSpecial.FLAME) {
                    entity.m_20254_(12);
                } else if (this.m_6060_()) {
                    entity.m_20254_(5);
                }
            }
            if (specialType == ArrowType.ArrowSpecial.POSION && !(entity instanceof EnderMan)) {
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 40, 2));
            }
            if (specialType == ArrowType.ArrowSpecial.EXPLODE) {
                this.m_9236_().m_255391_((Entity)this, this.f_19854_, this.f_19855_, this.f_19856_, 3.0f, false, Level.ExplosionInteraction.NONE);
            }
            if (entity.m_6469_(damageSource = this.m_9236_().m_269111_().m_269418_((AbstractArrow)this, (Entity)Objects.requireNonNullElse(this.shootingEntity, this)), (float)damage)) {
                Entity entity2;
                float f1;
                if (!this.m_9236_().m_5776_()) {
                    entity.m_21317_(entity.m_21234_() + 1);
                }
                if (this.knockbackStrength > 0 && (f1 = Mth.m_14116_((float)((float)(this.m_20184_().f_82479_ * this.m_20184_().f_82479_ + this.m_20184_().f_82481_ * this.m_20184_().f_82481_)))) > 0.0f) {
                    entity.m_20334_(this.m_20184_().f_82479_ * (double)this.knockbackStrength * 0.6 / (double)f1, 0.1, this.m_20184_().f_82481_ * (double)this.knockbackStrength * 0.6 / (double)f1);
                }
                if (this.shootingEntity instanceof LivingEntity) {
                    EnchantmentHelper.m_44823_((LivingEntity)entity, (Entity)this.shootingEntity);
                }
                if ((entity2 = this.shootingEntity) instanceof ServerPlayer) {
                    ServerPlayer shooter = (ServerPlayer)entity2;
                    if (entity instanceof Player) {
                        shooter.f_8906_.m_9829_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132159_, 0.0f));
                    }
                }
                this.m_5496_(SoundEvents.f_11685_, 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
                if (!(entity instanceof EnderMan)) {
                    this.m_6074_();
                }
            } else {
                this.m_20256_(this.m_20184_().m_82490_(-0.1));
                this.f_19857_ += 180.0f;
                this.f_19859_ += 180.0f;
                if (!this.m_9236_().m_5776_() && this.m_20184_().m_82556_() < 0.001) {
                    if (this.pickupStatus == AbstractArrow.Pickup.ALLOWED) {
                        this.m_9236_().m_7967_((Entity)new ItemEntity(this.m_9236_(), this.f_19854_, this.f_19855_, this.f_19856_, this.getArrowStack()));
                    }
                    this.m_6074_();
                }
            }
        } else if (hitEntity instanceof EnderDragonPart) {
            EnderDragonPart entity = (EnderDragonPart)hitEntity;
            float velocity = (float)this.m_20184_().m_82553_();
            int damage = Mth.m_14165_((double)((double)velocity * this.damageMin));
            if ((double)damage > this.damageMax) {
                damage = Mth.m_14165_((double)this.damageMax);
            }
            if (this.getIsCritical()) {
                damage += this.f_19796_.m_188503_(damage / 2 + 2);
            }
            DamageSource damageSource = this.m_9236_().m_269111_().m_269418_((AbstractArrow)this, (Entity)Objects.requireNonNullElse(this.shootingEntity, this));
            if (this.getArrowType().getArrowSpecial() == ArrowType.ArrowSpecial.FLAME) {
                entity.m_20254_(12);
            } else if (this.m_6060_()) {
                entity.m_20254_(5);
            }
            if (entity.m_6469_(damageSource, (float)damage)) {
                float f1;
                if (this.getArrowType().getArrowSpecial() == ArrowType.ArrowSpecial.EXPLODE) {
                    this.m_9236_().m_255391_((Entity)this, this.f_19854_, this.f_19855_, this.f_19856_, 3.0f, false, Level.ExplosionInteraction.NONE);
                }
                if (this.knockbackStrength > 0 && (f1 = Mth.m_14116_((float)((float)(this.m_20184_().f_82479_ * this.m_20184_().f_82479_ + this.m_20184_().f_82481_ * this.m_20184_().f_82481_)))) > 0.0f) {
                    entity.m_20334_(this.m_20184_().f_82479_ * (double)this.knockbackStrength * 0.6 / (double)f1, 0.1, this.m_20184_().f_82481_ * (double)this.knockbackStrength * 0.6 / (double)f1);
                }
                this.m_5496_(SoundEvents.f_11685_, 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
                this.m_6074_();
            }
        }
    }

    public void m_6478_(@NotNull MoverType type, @NotNull Vec3 vec) {
        super.m_6478_(type, vec);
        if (this.inGround) {
            this.xTile = Mth.m_14107_((double)this.f_19854_);
            this.yTile = Mth.m_14107_((double)this.f_19855_);
            this.zTile = Mth.m_14107_((double)this.f_19856_);
        }
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128376_("life", (short)this.f_19797_);
        compound.m_128405_("xTile", this.xTile);
        compound.m_128405_("yTile", this.yTile);
        compound.m_128405_("zTile", this.zTile);
        compound.m_128344_("shake", (byte)this.f_36706_);
        compound.m_128379_("inGround", this.inGround);
        compound.m_128344_("pickup", (byte)this.f_36705_.ordinal());
        compound.m_128347_("damage", this.damageMin);
        compound.m_128379_("crit", this.m_36792_());
        compound.m_128344_("PierceLevel", this.m_36796_());
        compound.m_128344_("arrowId", this.getArrowId());
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19797_ = compound.m_128448_("life");
        this.xTile = compound.m_128451_("xTile");
        this.yTile = compound.m_128451_("yTile");
        this.zTile = compound.m_128451_("zTile");
        this.f_36706_ = compound.m_128445_("shake") & 0xFF;
        this.inGround = compound.m_128471_("inGround");
        if (compound.m_128425_("damage", 99)) {
            this.damageMin = compound.m_128459_("damage");
        }
        this.f_36705_ = AbstractArrow.Pickup.m_36808_((int)compound.m_128445_("pickup"));
        this.m_36762_(compound.m_128471_("crit"));
        this.m_36767_(compound.m_128445_("PierceLevel"));
        this.arrowType = ArrowType.getArrowFromId(this.getArrowId());
        this.damageMax = this.arrowType.getMaxDamage();
    }

    public void m_6123_(@NotNull Player entityIn) {
        if (!this.m_9236_().m_5776_() && this.inGround && this.arrowShake <= 0) {
            boolean flag;
            boolean bl = flag = this.pickupStatus == AbstractArrow.Pickup.ALLOWED || this.pickupStatus == AbstractArrow.Pickup.CREATIVE_ONLY && entityIn.m_7500_();
            if (this.pickupStatus == AbstractArrow.Pickup.ALLOWED && !entityIn.f_36093_.m_36054_(this.getArrowStack())) {
                flag = false;
            }
            if (flag) {
                this.m_6074_();
            }
        }
    }

    @NotNull
    protected ItemStack m_7941_() {
        return this.getArrowStack();
    }

    public void m_36735_(int knockbackStrengthIn) {
        this.knockbackStrength = knockbackStrengthIn;
    }

    public boolean getIsCritical() {
        byte b0 = (Byte)this.f_19804_.m_135370_(CRITICAL);
        return (b0 & 1) != 0;
    }

    public void setDamage(double damageIn) {
        this.damageMin = damageIn;
    }

    public double getDamage() {
        return this.damageMin;
    }

    private byte getArrowId() {
        return (Byte)this.f_19804_.m_135370_(ARROW_ID);
    }

    private void setArrowId(byte projectileId) {
        this.f_19804_.m_135381_(ARROW_ID, (Object)projectileId);
    }

    public ArrowType getArrowType() {
        if (this.arrowType == null) {
            this.arrowType = ArrowType.getArrowFromId(this.getArrowId());
        }
        return this.arrowType;
    }

    public ResourceLocation getTexture() {
        return this.getArrowType().getTexture();
    }

    protected ItemStack getArrowStack() {
        return new ItemStack((ItemLike)this.ammoItem);
    }
}

