/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.vanilla.end;

import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;

public class EntityEnderWatcher
extends EnderMan {
    public EntityEnderWatcher(EntityType<? extends EnderMan> type, Level worldIn) {
        super(type, worldIn);
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 0.5f;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new EndermanFreezeWhenLookedAt(this));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new EndermanLookForPlayerGoal(this, arg_0 -> ((EntityEnderWatcher)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Endermite.class, true, false));
        this.f_21346_.m_25352_(4, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    boolean m_32534_(Player pPlayer) {
        ItemStack itemstack = (ItemStack)pPlayer.m_150109_().f_35975_.get(3);
        if (ForgeHooks.shouldSuppressEnderManAnger((EnderMan)this, (Player)pPlayer, (ItemStack)itemstack)) {
            return false;
        }
        Vec3 vec3 = pPlayer.m_20252_(1.0f).m_82541_();
        Vec3 vec31 = new Vec3(this.m_20185_() - pPlayer.m_20185_(), this.m_20188_() - pPlayer.m_20188_(), this.m_20189_() - pPlayer.m_20189_());
        double d0 = vec31.m_82553_();
        double d1 = vec3.m_82526_(vec31 = vec31.m_82541_());
        return d1 > 1.0 - 0.025 / d0 ? pPlayer.m_142582_((Entity)this) : false;
    }

    boolean m_32500_(Entity pTarget) {
        Vec3 vec3 = new Vec3(this.m_20185_() - pTarget.m_20185_(), this.m_20227_(0.5) - pTarget.m_20188_(), this.m_20189_() - pTarget.m_20189_());
        vec3 = vec3.m_82541_();
        double d1 = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 8.0 - vec3.f_82479_ * 16.0;
        double d2 = this.m_20186_() + (double)(this.f_19796_.m_188503_(16) - 8) - vec3.f_82480_ * 16.0;
        double d3 = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 8.0 - vec3.f_82481_ * 16.0;
        return this.m_264318_((ServerLevel)pTarget.m_9236_(), d1, d2, d3, RelativeMovement.f_263752_, pTarget.f_19857_, pTarget.f_19858_);
    }

    static class EndermanFreezeWhenLookedAt
    extends Goal {
        private final EntityEnderWatcher enderman;
        @Nullable
        private LivingEntity target;

        public EndermanFreezeWhenLookedAt(EntityEnderWatcher pEnderman) {
            this.enderman = pEnderman;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            this.target = this.enderman.m_5448_();
            if (!(this.target instanceof Player)) {
                return false;
            }
            double d0 = this.target.m_20280_((Entity)this.enderman);
            return d0 > 256.0 ? false : this.enderman.m_32534_((Player)this.target);
        }

        public void m_8056_() {
            this.enderman.m_21573_().m_26573_();
        }

        public void m_8037_() {
            this.enderman.m_21563_().m_24946_(this.target.m_20185_(), this.target.m_20188_(), this.target.m_20189_());
        }
    }

    static class EndermanLookForPlayerGoal
    extends NearestAttackableTargetGoal<Player> {
        private final EntityEnderWatcher enderman;
        @Nullable
        private Player pendingTarget;
        private int aggroTime;
        private int teleportTime;
        private final TargetingConditions startAggroTargetConditions;
        private final TargetingConditions continueAggroTargetConditions = TargetingConditions.m_148352_().m_148355_();
        private final Predicate<LivingEntity> isAngerInducing;

        public EndermanLookForPlayerGoal(EntityEnderWatcher pEnderman, @Nullable Predicate<LivingEntity> pSelectionPredicate) {
            super((Mob)pEnderman, Player.class, 10, false, false, pSelectionPredicate);
            this.enderman = pEnderman;
            this.isAngerInducing = p -> (pEnderman.m_32534_((Player)p) || pEnderman.m_21674_((LivingEntity)p)) && !pEnderman.m_20367_((Entity)p);
            this.startAggroTargetConditions = TargetingConditions.m_148352_().m_26883_(this.m_7623_()).m_26888_(this.isAngerInducing);
        }

        public boolean m_8036_() {
            this.pendingTarget = this.enderman.m_9236_().m_45946_(this.startAggroTargetConditions, (LivingEntity)this.enderman);
            return this.pendingTarget != null;
        }

        public void m_8056_() {
            this.aggroTime = this.m_183277_(5);
            this.teleportTime = 0;
            this.enderman.m_32533_();
        }

        public void m_8041_() {
            this.pendingTarget = null;
            super.m_8041_();
        }

        public boolean m_8045_() {
            if (this.pendingTarget != null) {
                if (!this.isAngerInducing.test((LivingEntity)this.pendingTarget)) {
                    return false;
                }
                this.enderman.m_21391_((Entity)this.pendingTarget, 10.0f, 10.0f);
                return true;
            }
            if (this.f_26050_ != null) {
                if (this.enderman.m_20367_((Entity)this.f_26050_)) {
                    return false;
                }
                if (this.continueAggroTargetConditions.m_26885_((LivingEntity)this.enderman, this.f_26050_)) {
                    return true;
                }
            }
            return super.m_8045_();
        }

        public void m_8037_() {
            if (this.enderman.m_5448_() == null) {
                super.m_26070_(null);
            }
            if (this.pendingTarget != null) {
                if (--this.aggroTime <= 0) {
                    this.f_26050_ = this.pendingTarget;
                    this.pendingTarget = null;
                    super.m_8056_();
                }
            } else {
                if (this.f_26050_ != null && !this.enderman.m_20159_()) {
                    if (this.enderman.m_32534_((Player)this.f_26050_)) {
                        if (this.f_26050_.m_20280_((Entity)this.enderman) < 16.0) {
                            this.enderman.m_32529_();
                        }
                        this.teleportTime = 0;
                    } else if (this.f_26050_.m_20280_((Entity)this.enderman) > 256.0 && this.teleportTime++ >= this.m_183277_(30) && this.enderman.m_32500_((Entity)this.f_26050_)) {
                        this.teleportTime = 0;
                    }
                }
                super.m_8037_();
            }
        }
    }
}

