/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.vanilla.nether;

import divinerpg.entities.base.EntityDivineMonster;
import divinerpg.registries.SoundRegistry;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class EntityHellSpider
extends EntityDivineMonster {
    private static final EntityDataAccessor<Byte> CLIMBING = SynchedEntityData.m_135353_(EntityHellSpider.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);

    public EntityHellSpider(EntityType<? extends EntityHellSpider> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(4, (Goal)new AttackGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, new TargetGoal<Player>(this, Player.class));
        this.f_21346_.m_25352_(3, new TargetGoal<IronGolem>(this, IronGolem.class));
    }

    public double m_6049_() {
        return this.m_20206_() * 0.5f;
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new WallClimberNavigation((Mob)this, worldIn);
    }

    public boolean m_5825_() {
        return true;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CLIMBING, (Object)0);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_()) {
            this.setBesideClimbableBlock(this.f_19862_);
        }
    }

    public boolean m_7327_(Entity entityIn) {
        if (super.m_7327_(entityIn)) {
            if (entityIn instanceof LivingEntity) {
                entityIn.m_7311_(3);
            }
            return true;
        }
        return false;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundRegistry.JUNGLE_SPIDER.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_12434_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12433_;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_12435_, 0.15f, 1.0f);
    }

    public boolean m_5791_() {
        return this.isBesideClimbableBlock();
    }

    public void m_7601_(BlockState state, Vec3 motionMultiplierIn) {
        if (!state.m_60713_(Blocks.f_50033_)) {
            super.m_7601_(state, motionMultiplierIn);
        }
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public boolean m_7301_(MobEffectInstance potioneffectIn) {
        if (potioneffectIn.m_19544_() == MobEffects.f_19614_) {
            return false;
        }
        return super.m_7301_(potioneffectIn);
    }

    public boolean isBesideClimbableBlock() {
        return ((Byte)this.f_19804_.m_135370_(CLIMBING) & 1) != 0;
    }

    public void setBesideClimbableBlock(boolean climbing) {
        byte b0 = (Byte)this.f_19804_.m_135370_(CLIMBING);
        b0 = climbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.f_19804_.m_135381_(CLIMBING, (Object)b0);
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 0.65f;
    }

    static class AttackGoal
    extends MeleeAttackGoal {
        public AttackGoal(EntityHellSpider p_i46676_1_) {
            super((PathfinderMob)p_i46676_1_, 1.0, true);
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.f_25540_.m_20160_();
        }

        public boolean m_8045_() {
            float f = this.f_25540_.m_9236_().m_7146_(this.f_25540_.m_20183_());
            if (f >= 0.5f && this.f_25540_.m_217043_().m_188503_(100) == 0) {
                this.f_25540_.m_6710_((LivingEntity)null);
                return false;
            }
            return super.m_8045_();
        }

        protected double m_6639_(LivingEntity p_179512_1_) {
            return 4.0f + p_179512_1_.m_20205_();
        }
    }

    static class TargetGoal<T extends LivingEntity>
    extends NearestAttackableTargetGoal<T> {
        public TargetGoal(EntityHellSpider p_i45818_1_, Class<T> p_i45818_2_) {
            super((Mob)p_i45818_1_, p_i45818_2_, true);
        }

        public boolean m_8036_() {
            float f = this.f_26135_.m_9236_().m_7146_(this.f_26135_.m_20183_());
            return f >= 0.5f ? false : super.m_8036_();
        }
    }

    public static class GroupData
    implements SpawnGroupData {
        public MobEffect effect;

        public void setRandomEffect(Random p_111104_1_) {
            int i = p_111104_1_.nextInt(5);
            if (i <= 1) {
                this.effect = MobEffects.f_19596_;
            } else if (i <= 2) {
                this.effect = MobEffects.f_19600_;
            } else if (i <= 3) {
                this.effect = MobEffects.f_19605_;
            } else if (i <= 4) {
                this.effect = MobEffects.f_19609_;
            }
        }
    }
}

