/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.vanilla.overworld;

import divinerpg.entities.base.EntityDivineMonster;
import divinerpg.entities.projectile.EntitySaguaroWormShot;
import divinerpg.registries.EntityRegistry;
import divinerpg.registries.SoundRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraftforge.common.Tags;

public class EntitySaguaroWorm
extends EntityDivineMonster
implements RangedAttackMob {
    private static final EntityDataAccessor<Boolean> PROVOKED = SynchedEntityData.m_135353_(EntitySaguaroWorm.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public EntitySaguaroWorm(EntityType<? extends EntitySaguaroWorm> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(4, (Goal)new RangedAttackGoal((RangedAttackMob)this, this.m_21051_(Attributes.f_22279_).m_22115_(), 3, (float)this.m_21051_(Attributes.f_22277_).m_22115_()));
    }

    public double m_6049_() {
        return 2.5;
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new WallClimberNavigation((Mob)this, worldIn);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PROVOKED, (Object)false);
    }

    public boolean getProvoked() {
        return (Boolean)this.f_19804_.m_135370_(PROVOKED);
    }

    public void setProvoked(boolean provoked) {
        this.f_19804_.m_135381_(PROVOKED, (Object)provoked);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_() && this.m_21223_() > 0.0f) {
            Player player = this.m_9236_().m_45930_((Entity)this, 10.0);
            if (player != null && !player.m_7500_() && !player.m_5833_() && this.m_142582_((Entity)player)) {
                this.m_6710_((LivingEntity)player);
                this.m_21557_(false);
                this.setProvoked(true);
            } else {
                this.m_6710_(null);
                this.setProvoked(false);
                this.m_21557_(true);
            }
        }
        if (!this.getProvoked()) {
            this.f_19860_ = 0.0f;
        }
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setProvoked(tag.m_128471_("Provoked"));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("Provoked", this.getProvoked());
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)SoundRegistry.SAGUARO_WORM.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundRegistry.SAGUARO_WORM.get();
    }

    public static boolean saguaroWormSpawnRule(EntityType<? extends Mob> typeIn, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, RandomSource randomIn) {
        return reason == MobSpawnType.SPAWNER || worldIn.m_8055_(pos.m_7495_()).m_204336_(Tags.Blocks.SAND);
    }

    public float m_5610_(BlockPos pos, LevelReader reader) {
        return 0.0f;
    }

    public void m_6504_(LivingEntity e, float p_33318_) {
        if (this.m_6084_() && this.m_5448_() != null && !this.m_9236_().f_46443_ && this.f_19797_ % 30 == 0 && this.getProvoked()) {
            double y = this.m_20191_().f_82289_ + 2.7;
            double tx = e.m_20185_() - this.m_20185_();
            double ty = e.m_20191_().f_82289_ - y;
            double tz = e.m_20189_() - this.m_20189_();
            for (double h = -1.5; h < 1.5; h += 0.5) {
                for (double r = 0.0; r < 1.5 - Math.abs(h); r += 0.5) {
                    for (double theta = 0.0; theta < Math.PI * 2; theta += 1.5707963267948966) {
                        EntitySaguaroWormShot shot = new EntitySaguaroWormShot((EntityType<? extends ThrowableProjectile>)((EntityType)EntityRegistry.SAGUARO_WORM_SHOT.get()), (LivingEntity)this, this.m_9236_());
                        shot.f_19854_ = this.f_19854_ + r * Math.cos(theta);
                        shot.f_19855_ = this.f_19855_ + 5.0 + h;
                        shot.f_19856_ = this.f_19856_ + r * Math.sin(theta);
                        shot.m_6686_(tx, ty, tz, 0.9f, 5.0f);
                        this.m_9236_().m_7967_((Entity)shot);
                    }
                }
            }
        }
    }
}

