/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.enums;

import divinerpg.registries.ParticleRegistry;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;

public enum BulletType {
    NONE(0.0f, null),
    FROST_CANNON_SHOT(6.0f, BulletType.ProjectileLoc("frost_cannon")),
    CYCLOPSIAN_STAFF_SHOT(6.0f, BulletType.ItemLoc("cyclops_eye_shards")),
    MAELSTROM_SHOT(18.0f, BulletType.ProjectileLoc("maelstrom")),
    CRAB_ANCHOR_SHOT(6.0f, BulletType.ProjectileLoc("crab_anchor")),
    SHARK_ANCHOR_SHOT(8.0f, BulletType.ProjectileLoc("shark_anchor")),
    BOWHEAD_ANCHOR_SHOT(10.0f, BulletType.ProjectileLoc("bowhead_anchor")),
    LIOPLEURODON_ANCHOR_SHOT(12.0f, BulletType.ProjectileLoc("liopleurodon_anchor")),
    GOLDEN_FURY_SHOT(30.0f, BulletType.VanillaItemLoc("gold_nugget")),
    GHAST_CANNON_SHOT(16.0f, BulletType.ProjectileLoc("ghast_cannon")),
    CRABCLAW_CANNON_SHOT(12.0f, BulletType.ProjectileLoc("crab_anchor")),
    BOWHEAD_CANNON_SHOT(12.0f, BulletType.ProjectileLoc("bowhead_anchor")),
    FROSTCLAW_CANNON_SHOT(16.0f, BulletType.ProjectileLoc("frostclaw_cannon")),
    FRACTITE_CANNON_SHOT(14.0f, BulletType.ProjectileLoc("fractite_cannon")),
    EDEN_BLITZ_SHOT(10.0f, BulletType.ProjectileLoc("eden_blitz"), (SimpleParticleType)ParticleRegistry.EDEN_PORTAL.get()),
    WILDWOOD_BLITZ_SHOT(12.0f, BulletType.ProjectileLoc("wildwood_blitz"), (SimpleParticleType)ParticleRegistry.WILDWOOD_PORTAL.get()),
    APALACHIA_BLITZ_SHOT(14.0f, BulletType.ProjectileLoc("apalachia_blitz"), (SimpleParticleType)ParticleRegistry.APALACHIA_PORTAL.get()),
    SKYTHERN_BLITZ_SHOT(16.0f, BulletType.ProjectileLoc("skythern_blitz"), (SimpleParticleType)ParticleRegistry.SKYTHERN_PORTAL.get()),
    MORTUM_BLITZ_SHOT(18.0f, BulletType.ProjectileLoc("mortum_blitz"), (SimpleParticleType)ParticleRegistry.MORTUM_PORTAL.get()),
    HALITE_BLITZ_SHOT(20.0f, BulletType.ProjectileLoc("halite_blitz"), (SimpleParticleType)ParticleRegistry.GREEN_PORTAL.get()),
    EDEN_PHASER_SHOT(14.0f, BulletType.ProjectileLoc("eden_phaser"), (SimpleParticleType)ParticleRegistry.EDEN_PORTAL.get()),
    WILDWOOD_PHASER_SHOT(17.0f, BulletType.ProjectileLoc("wildwood_phaser"), (SimpleParticleType)ParticleRegistry.WILDWOOD_PORTAL.get()),
    APALACHIA_PHASER_SHOT(20.0f, BulletType.ProjectileLoc("apalachia_phaser"), (SimpleParticleType)ParticleRegistry.APALACHIA_PORTAL.get()),
    SKYTHERN_PHASER_SHOT(23.0f, BulletType.ProjectileLoc("skythern_phaser"), (SimpleParticleType)ParticleRegistry.SKYTHERN_PORTAL.get()),
    MORTUM_PHASER_SHOT(26.0f, BulletType.ProjectileLoc("mortum_phaser"), (SimpleParticleType)ParticleRegistry.MORTUM_PORTAL.get()),
    HALITE_PHASER_SHOT(29.0f, BulletType.ProjectileLoc("halite_phaser"), (SimpleParticleType)ParticleRegistry.GREEN_PORTAL.get()),
    SCYTHE_SHOT(6.0f, BulletType.ProjectileLoc("scythe")),
    MEGA_SCYTHE_SHOT(18.0f, BulletType.ProjectileLoc("scythe")),
    SHURIKEN_SHOT(4.0f, BulletType.ItemLoc("shuriken")),
    SNOWFLAKE_SHURIKEN_SHOT(7.0f, BulletType.ItemLoc("snowflake_shuriken")),
    EDEN_SLICER_SHOT(8.0f, BulletType.ItemLoc("eden_slicer")),
    WILDWOOD_SLICER_SHOT(10.0f, BulletType.ItemLoc("wildwood_slicer")),
    APALACHIA_SLICER_SHOT(12.0f, BulletType.ItemLoc("apalachia_slicer")),
    SKYTHERN_SLICER_SHOT(14.0f, BulletType.ItemLoc("skythern_slicer")),
    MORTUM_SLICER_SHOT(16.0f, BulletType.ItemLoc("mortum_slicer")),
    HALITE_SLICER_SHOT(22.0f, BulletType.ItemLoc("halite_slicer")),
    ARCANITE_BLASTER(35.0f, BulletType.ProjectileLoc("blaster_shot")),
    GENERALS_STAFF_SHOT(18.0f, BulletType.ProjectileLoc("generals_staff"), 31, 93, 210),
    GENERALS_STAFF_SPRAY(18.0f, BulletType.ProjectileLoc("generals_staff"), 56, 152, 186),
    MAGE_SHOT(10.0f, BulletType.blank(), 62, 212, 254),
    SPELLBINDER_SHOT(12.0f, BulletType.blank(), 234, 158, 253),
    MYSTIC_SHOT(13.0f, BulletType.blank(), 234, 223, 228),
    SORCERER_SHOT(14.0f, BulletType.blank(), 97, 31, 54),
    TWILIGHT_DEMON_BLACK_SHOT(16.0f, BulletType.ProjectileLoc("twilight_demon_shot"), 0, 0, 0),
    TWILIGHT_DEMON_RED_SHOT(16.0f, BulletType.ProjectileLoc("twilight_demon_shot"), 255, 0, 0),
    SOUL_FIEND_SHOT(0.0f, BulletType.blank()),
    SUNSTORM(12.0f, BulletType.blank(), 255, 235, 0),
    TOMATO(0.5f, BulletType.ItemLoc("tomato"), 255, 99, 71),
    BONE_FRAGMENT(6.0f, BulletType.ProjectileLoc("bone_fragment")),
    BONE_BOMB(16.0f, BulletType.ProjectileLoc("bone_bomb")),
    TEAKER_CANNON_SHOT(2.0f, BulletType.ProjectileLoc("cannon")),
    AMTHIRMIS_CANNON_SHOT(4.0f, BulletType.ProjectileLoc("cannon")),
    DARVEN_CANNON_SHOT(6.0f, BulletType.ProjectileLoc("cannon")),
    CERMILE_CANNON_SHOT(10.0f, BulletType.ProjectileLoc("cannon")),
    PARDIMAL_CANNON_SHOT(13.0f, BulletType.ProjectileLoc("cannon")),
    QUADROTIC_CANNON_SHOT(14.0f, BulletType.ProjectileLoc("cannon")),
    KAROS_CANNON_SHOT(17.0f, BulletType.ProjectileLoc("cannon")),
    HELIOSIS_CANNON_SHOT(22.0f, BulletType.ProjectileLoc("cannon")),
    ARKSIANE_CANNON_SHOT(28.0f, BulletType.ProjectileLoc("cannon")),
    EVERSIGHT_SHOT(27.0f, BulletType.ProjectileLoc("cannon")),
    LUNA_SPARKLER(12.0f, BulletType.blank(), 139, 103, 255, (SimpleParticleType)ParticleRegistry.WILDWOOD_PORTAL.get());

    private final float damage;
    private final ResourceLocation texture;
    private final SimpleParticleType particle;
    private final int r;
    private final int g;
    private final int b;

    private BulletType(float damage, ResourceLocation texture, SimpleParticleType particle) {
        this.damage = damage;
        this.texture = texture;
        this.particle = particle;
        this.r = 0;
        this.g = 0;
        this.b = 0;
    }

    private BulletType(float damage, ResourceLocation texture, int r, int g, int b) {
        this.damage = damage;
        this.texture = texture;
        this.particle = null;
        this.r = r;
        this.g = g;
        this.b = b;
    }

    private BulletType(float damage, ResourceLocation texture, int r, int g, int b, SimpleParticleType particle) {
        this.damage = damage;
        this.texture = texture;
        this.particle = particle;
        this.r = r;
        this.g = g;
        this.b = b;
    }

    private BulletType(float damage, ResourceLocation texture) {
        this.damage = damage;
        this.texture = texture;
        this.particle = null;
        this.r = 0;
        this.g = 0;
        this.b = 0;
    }

    public static BulletType getBulletFromOrdinal(int ordinal) {
        if (ordinal < 0 || ordinal > BulletType.values().length) {
            ordinal = 0;
        }
        return BulletType.values()[ordinal];
    }

    private static ResourceLocation ProjectileLoc(String name) {
        return new ResourceLocation("divinerpg", "textures/projectiles/" + name + ".png");
    }

    private static ResourceLocation blank() {
        return new ResourceLocation("minecraft:textures/particle/generic_0.png");
    }

    private static ResourceLocation ItemLoc(String name) {
        return new ResourceLocation("divinerpg", "textures/item/" + name + ".png");
    }

    private static ResourceLocation VanillaItemLoc(String name) {
        return new ResourceLocation("minecraft:textures/item/" + name + ".png");
    }

    public float getDamage() {
        return this.damage;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public SimpleParticleType getParticle() {
        return this.particle;
    }

    public int getRed() {
        return this.r;
    }

    public int getGreen() {
        return this.g;
    }

    public int getBlue() {
        return this.b;
    }
}

