/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.events;

import com.mojang.blaze3d.systems.RenderSystem;
import divinerpg.capability.Arcana;
import divinerpg.capability.ArcanaProvider;
import divinerpg.config.ClientConfig;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class ArcanaRenderer
extends Gui {
    private static final ResourceLocation TEXTURE = new ResourceLocation("divinerpg", "textures/gui/arcana_bar.png");
    private static final ResourceLocation ICONS = new ResourceLocation("minecraft", "textures/gui/icons.png");
    private static final ResourceLocation ARCANA_ICON = new ResourceLocation("divinerpg", "textures/gui/arcana_bar.png");
    private final Minecraft mc = Minecraft.m_91087_();
    private static final long DISPLAY_DURATION = 40L;
    private static long counter = 40L;
    private static long counter2 = 40L;
    private static long counter3 = 40L;
    private static float previousAmount = 0.0f;
    private static float previousAmount2 = 0.0f;
    private static float previousHealth = 0.0f;
    public static boolean shouldRender = false;
    private LivingEntity lastEntity = null;
    private int lastEntityTime = 0;
    private String cachedHealthText = "";
    private String cachedName = "";
    private float cachedHealth = -1.0f;
    private float cachedHealthPercentage = -1.0f;
    private int cachedHealthColor = 0;

    public ArcanaRenderer() {
        super(Minecraft.m_91087_(), Minecraft.m_91087_().m_91291_());
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void renderGameOverlayEvent(RenderGuiOverlayEvent.Post event) {
        GuiGraphics gui = event.getGuiGraphics();
        int windowWidth = this.mc.m_91268_().m_85445_();
        int windowHeight = this.mc.m_91268_().m_85446_();
        int yLocation = windowHeight - (Integer)ClientConfig.arcanaY.get();
        int xLocation = windowWidth - (Integer)ClientConfig.arcanaX.get();
        boolean hideArcanaBar = (Boolean)ClientConfig.hideArcanaBar.get();
        if (hideArcanaBar && Arcana.clientAmount != previousAmount) {
            previousAmount = Arcana.clientAmount;
            if (this.mc.f_91073_ != null) {
                counter = this.mc.f_91073_.m_46467_() + 40L;
            }
        }
        if (!(this.mc.f_91073_ == null || hideArcanaBar && counter - this.mc.f_91073_.m_46467_() <= 0L)) {
            this.renderArcanaBar(gui, xLocation, yLocation);
        }
    }

    private void renderArcanaBar(GuiGraphics gui, int x, int y) {
        gui.m_280218_(TEXTURE, x, y, 0, 0, 100, 9);
        int arcanaWidth = (int)(Arcana.clientAmount / Arcana.clientMax * 100.0f);
        gui.m_280218_(TEXTURE, x, y, 0, 9, arcanaWidth, 18);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void renderOverlay(RenderGuiOverlayEvent.Post event) {
        LocalPlayer player = this.mc.f_91074_;
        if (player != null && !player.m_7500_()) {
            DecimalFormat df = new DecimalFormat("#");
            df.setRoundingMode(RoundingMode.CEILING);
            player.getCapability(ArcanaProvider.ARCANA).ifPresent(arg_0 -> this.lambda$renderOverlay$0((Player)player, event, df, arg_0));
        }
    }

    private boolean shouldRenderOverlay(Player player, @NotNull Arcana arcana) {
        return player.m_21223_() != player.m_21233_() || arcana.getAmount(true) != arcana.getMaxArcana((LivingEntity)player, true);
    }

    private void updateCounters(Player player) {
        if (Arcana.clientAmount != previousAmount2) {
            previousAmount2 = Arcana.clientAmount;
            if (this.mc.f_91073_ != null) {
                counter2 = this.mc.f_91073_.m_46467_() + 40L;
            }
        }
        if (player.m_21223_() != previousHealth) {
            previousHealth = player.m_21223_();
            if (this.mc.f_91073_ != null) {
                counter3 = this.mc.f_91073_.m_46467_() + 40L;
            }
        }
    }

    private void renderPlayerStats(GuiGraphics guiGraphics, Player player, DecimalFormat df) {
        int windowWidth = this.mc.m_91268_().m_85445_();
        int windowHeight = this.mc.m_91268_().m_85446_();
        int xLocation = windowWidth / 2 + 12;
        this.renderStat(guiGraphics, ICONS, xLocation, windowHeight / 2 - 2, df.format(player.m_21223_()), 16, 0);
        this.renderStat(guiGraphics, ICONS, xLocation, windowHeight / 2 + 8, df.format(player.m_36324_().m_38702_()), 16, 27);
        this.renderStat(guiGraphics, ARCANA_ICON, xLocation, windowHeight / 2 + 18, df.format(Arcana.clientAmount), 0, 50);
    }

    private void renderStat(GuiGraphics guiGraphics, ResourceLocation texture, int x, int y, String statValue, int u, int v) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        guiGraphics.m_280218_(texture, x, y, u, v, 9, 9);
        guiGraphics.m_280218_(texture, x, y, u + 36, v, 9, 9);
        guiGraphics.m_280488_(this.mc.f_91062_, statValue, x + 12, y, 0xFFFFFF);
    }

    @SubscribeEvent
    public void onRenderGuiOverlay(RenderGuiOverlayEvent.Post event) {
        LivingEntity entity;
        Entity entity2 = this.mc.f_91076_;
        if (entity2 instanceof LivingEntity && (entity = (LivingEntity)entity2).m_6084_()) {
            if (this.lastEntity != entity) {
                this.resetCache();
            }
            this.lastEntity = entity;
            this.lastEntityTime = this.mc.f_91065_.m_93079_();
        }
        if (this.lastEntity != null) {
            if (!this.lastEntity.m_6084_()) {
                this.reset();
                return;
            }
            int ticksSinceSeen = this.mc.f_91065_.m_93079_() - this.lastEntityTime;
            if (ticksSinceSeen < 65) {
                this.renderHud(event, this.lastEntity);
            } else {
                this.reset();
            }
        }
    }

    private void reset() {
        this.lastEntity = null;
        this.resetCache();
    }

    private void resetCache() {
        this.cachedHealth = -1.0f;
        this.cachedHealthPercentage = -1.0f;
        this.cachedName = "";
        this.cachedHealthText = "";
        this.cachedHealthColor = 0;
    }

    private void renderHud(RenderGuiOverlayEvent.Post event, LivingEntity entity) {
        boolean shouldUpdateCache;
        if (!entity.m_20145_() || entity.m_20270_((Entity)Objects.requireNonNull(this.mc.f_91074_)) > 20.0f) {
            return;
        }
        GuiGraphics gui = event.getGuiGraphics();
        int healthBarWidth = 100;
        int healthBarHeight = 10;
        int x = (this.mc.m_91268_().m_85445_() - healthBarWidth) / 2;
        int y = 15;
        float health = entity.m_21223_();
        float maxHealth = Math.max(1.0f, entity.m_21233_());
        float rawHealthPercentage = health / maxHealth;
        float roundedPercentage = (float)Math.round(rawHealthPercentage * 20.0f) / 20.0f;
        roundedPercentage = Math.min(1.0f, Math.max(0.01f, roundedPercentage));
        String nameStr = entity.m_5446_().getString();
        boolean bl = shouldUpdateCache = entity != this.lastEntity || Math.abs(health - this.cachedHealth) > 0.05f || !nameStr.equals(this.cachedName) || roundedPercentage != this.cachedHealthPercentage || this.mc.f_91065_.m_93079_() % 12 == 0;
        if (shouldUpdateCache) {
            this.cachedHealth = health;
            this.cachedHealthPercentage = roundedPercentage;
            this.cachedHealthText = String.format("%.1f", Float.valueOf(health));
            this.cachedName = nameStr;
            this.cachedHealthColor = this.computeHealthColor(roundedPercentage);
        }
        int healthTextWidth = this.mc.f_91062_.m_92895_(this.cachedHealthText);
        int nameWidth = this.mc.f_91062_.m_92895_(this.cachedName);
        this.renderHealthBar(gui, this.cachedHealthPercentage, this.cachedHealthText, this.cachedName, healthTextWidth, nameWidth, this.cachedHealthColor, x, y, healthBarWidth, healthBarHeight);
    }

    private void renderHealthBar(GuiGraphics gui, float healthPercentage, String healthText, String name, int healthTextWidth, int nameWidth, int healthColor, int x, int y, int width, int height) {
        gui.m_280509_(x + 1, y + 1, x + (int)((float)width * healthPercentage) - 1, y + height - 1, healthColor);
        gui.m_280637_(x, y, width, height, -1694498817);
        gui.m_280056_(this.mc.f_91062_, healthText, x + width / 2 - healthTextWidth / 2, y + 1, 0xFFFFFF, false);
        gui.m_280056_(this.mc.f_91062_, name, x + width / 2 - nameWidth / 2, y - height - 1, -83886081, false);
    }

    private int computeHealthColor(float percent) {
        int red = (int)(255.0f * (1.0f - percent) + 80.0f * percent);
        int green = (int)(64.0f * (1.0f - percent) + 255.0f * percent);
        int blue = 80;
        int alpha = 154;
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    private /* synthetic */ void lambda$renderOverlay$0(Player player, RenderGuiOverlayEvent.Post event, DecimalFormat df, Arcana arcana) {
        if (this.shouldRenderOverlay(player, arcana)) {
            this.updateCounters(player);
            if (this.mc.f_91073_ != null && (counter2 - this.mc.f_91073_.m_46467_() > 0L || counter3 - this.mc.f_91073_.m_46467_() > 0L)) {
                this.renderPlayerStats(event.getGuiGraphics(), player, df);
            }
        }
    }
}

