/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.events;

import divinerpg.capability.ArcanaProvider;
import divinerpg.effect.mob.armor.ArmorEffectInstance;
import divinerpg.effect.mob.armor.UpdatableArmorEffect;
import divinerpg.items.base.ItemDivineArmor;
import divinerpg.registries.ItemRegistry;
import divinerpg.registries.MobEffectRegistry;
import divinerpg.util.DamageSources;
import java.util.ArrayList;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ArmorAbilitiesEvent {
    @SubscribeEvent
    public void onEquipmentChanged(LivingEquipmentChangeEvent event) {
        LivingEntity entity = event.getEntity();
        EquipmentSlot slot = event.getSlot();
        if (slot.m_254934_()) {
            ItemStack s = event.getFrom();
            MobEffect[] mobEffectArray = s.m_41720_();
            if (mobEffectArray instanceof ItemDivineArmor) {
                ItemDivineArmor armor = (ItemDivineArmor)mobEffectArray;
                if (!s.m_150930_(event.getTo().m_41720_()) && armor.supportedEffects != null) {
                    for (MobEffect effect : armor.supportedEffects) {
                        entity.m_21195_(effect);
                    }
                }
            }
            ArmorAbilitiesEvent.updateAbilities(entity);
        } else {
            for (MobEffectInstance instance : entity.m_21220_()) {
                MobEffect mobEffect = instance.m_19544_();
                if (!(mobEffect instanceof UpdatableArmorEffect)) continue;
                UpdatableArmorEffect update = (UpdatableArmorEffect)mobEffect;
                update.update(entity);
            }
        }
    }

    public static void updateAbilities(LivingEntity entity) {
        boolean fullArmor;
        int i;
        ArrayList<MobEffect> supportedEffects = new ArrayList<MobEffect>();
        ArrayList<Integer> amplifiers = new ArrayList<Integer>();
        ItemStack[] stack = new ItemStack[]{entity.m_6844_(EquipmentSlot.HEAD), entity.m_6844_(EquipmentSlot.CHEST), entity.m_6844_(EquipmentSlot.LEGS), entity.m_6844_(EquipmentSlot.FEET)};
        ArrayList<ItemDivineArmor> equipment = new ArrayList<ItemDivineArmor>();
        for (ItemStack s : stack) {
            Item item = s.m_41720_();
            if (!(item instanceof ItemDivineArmor)) continue;
            ItemDivineArmor armor = (ItemDivineArmor)item;
            equipment.add(armor);
        }
        for (ItemDivineArmor armor : equipment) {
            if (armor.supportedEffects == null) continue;
            for (i = 0; i < armor.supportedEffects.length; ++i) {
                MobEffect supportedEffect = armor.supportedEffects[i];
                if (supportedEffects.contains(supportedEffect)) continue;
                supportedEffects.add(supportedEffect);
                amplifiers.add(armor.amplifier == null ? 0 : armor.amplifier[i]);
            }
        }
        boolean bl = fullArmor = equipment.size() == 4;
        if (fullArmor) {
            ArmorMaterial mat = ((ItemDivineArmor)equipment.get((int)0)).mat;
            for (i = 1; fullArmor && i < 4; ++i) {
                if (((ItemDivineArmor)equipment.get((int)i)).mat == mat) continue;
                fullArmor = false;
                break;
            }
            if (fullArmor) {
                for (i = 0; i < supportedEffects.size(); ++i) {
                    MobEffectInstance instance;
                    MobEffect supportedEffect = (MobEffect)supportedEffects.get(i);
                    boolean shouldRemove = false;
                    if (!entity.m_21023_(supportedEffect) || (shouldRemove = !(instance = entity.m_21124_(supportedEffect)).m_267577_() || !(instance instanceof ArmorEffectInstance))) {
                        if (shouldRemove) {
                            entity.m_21195_(supportedEffect);
                        }
                        entity.m_7292_((MobEffectInstance)new ArmorEffectInstance(supportedEffect, (Integer)amplifiers.get(i)));
                        continue;
                    }
                    if (!(supportedEffect instanceof UpdatableArmorEffect)) continue;
                    UpdatableArmorEffect update = (UpdatableArmorEffect)supportedEffect;
                    update.update(entity);
                }
            }
        }
        if (!fullArmor) {
            for (MobEffect supportedEffect : supportedEffects) {
                if (!entity.m_21023_(supportedEffect) || !entity.m_21124_(supportedEffect).m_267577_()) continue;
                entity.m_21195_(supportedEffect);
            }
        }
    }

    @SubscribeEvent
    public void antiExplosion(LivingAttackEvent event) {
        LivingEntity target = event.getEntity();
        DamageSource source = event.getSource();
        if (target.m_21023_((MobEffect)MobEffectRegistry.EXPLOSION_PROTECTION.get()) && (source.m_276093_(DamageTypes.f_268565_) || source.m_276093_(DamageTypes.f_268448_))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingHurtEvent(LivingDamageEvent event) {
        LivingEntity target = event.getEntity();
        float amount = event.getAmount();
        Entity entity = event.getSource().m_7639_();
        DamageSource source = event.getSource();
        if (target.m_21206_().m_150930_((Item)ItemRegistry.arcana_core.get())) {
            target.getCapability(ArcanaProvider.ARCANA).ifPresent(arcana -> {
                if (arcana.getAmount(false) >= event.getAmount() * 12.875f) {
                    arcana.consume((Player)target, event.getAmount() * 12.875f);
                    event.setAmount(0.0f);
                }
            });
        }
        if (target instanceof Player && entity instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            if (attacker.m_21023_((MobEffect)MobEffectRegistry.AWAKENED_HALITE_STRENGTH.get()) && (source.m_276093_(DamageTypes.f_268534_) || source.m_276093_(DamageTypes.f_268739_))) {
                event.setAmount(amount * 1.5f);
            } else if (attacker.m_21023_((MobEffect)MobEffectRegistry.CORRUPTED_STRENGTH.get()) && (source.m_276093_(DamageTypes.f_268534_) || source.m_276093_(DamageTypes.f_268739_) || source.m_276093_(DamageTypes.f_268425_) || source.m_276093_(DamageTypes.f_268714_))) {
                event.setAmount(amount * 1.5f);
            }
            if (target.m_21023_((MobEffect)MobEffectRegistry.PROJECTILE_PROTECTION.get()) && (source.m_276093_(DamageTypes.f_268534_) || source.m_276093_(DamageTypes.f_268739_) || source.m_276093_(DamageTypes.f_268425_) || source.m_276093_(DamageTypes.f_268714_))) {
                event.setAmount(event.getAmount() * 0.34f);
            } else if (target.m_21023_((MobEffect)MobEffectRegistry.MELEE_PROTECTION.get()) && (source.m_276093_(DamageTypes.f_268566_) || source.m_276093_(DamageTypes.f_268464_) || source.m_276093_(DamageTypes.f_268433_)) && !source.m_276093_(DamageTypes.f_268534_)) {
                event.setAmount(event.getAmount() * 0.8f);
            } else if (!target.m_21023_((MobEffect)MobEffectRegistry.SENG_FUR.get())) {
                if (target.m_21023_((MobEffect)MobEffectRegistry.BLOCK_PROTECTION.get()) && (source.m_276093_(DamageTypes.f_268534_) || source.m_276093_(DamageTypes.f_268585_) || source.equals(target.m_269291_().m_269564_((Entity)target)) || source.equals(target.m_269291_().m_269230_((Entity)target)) || source.equals(target.m_269291_().m_269318_()) || source.equals(DamageSources.source(target.m_9236_(), DamageSources.TRAP)))) {
                    event.setCanceled(true);
                } else if (target.m_21023_((MobEffect)MobEffectRegistry.EXPLOSION_PROTECTION.get()) && (source.m_276093_(DamageTypes.f_268565_) || source.m_276093_(DamageTypes.f_268448_))) {
                    event.setCanceled(true);
                }
            }
        }
    }
}

