/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.events;

import com.idark.valoria.registries.ItemsRegistry;
import com.idark.valoria.registries.SoundsRegistry;
import com.idark.valoria.registries.level.LevelGen;
import com.mojang.blaze3d.vertex.PoseStack;
import divinerpg.DivineRPG;
import divinerpg.block_entities.block.SoulTrapBlockEntity;
import divinerpg.block_entities.chests.BoneChestBlockEntity;
import divinerpg.blocks.base.BlockModPortalBase;
import divinerpg.capability.Arcana;
import divinerpg.capability.ArcanaProvider;
import divinerpg.entities.boss.EntityRaglok;
import divinerpg.entities.projectile.EntityStar;
import divinerpg.enums.ArmorStats;
import divinerpg.events.ArmorAbilitiesEvent;
import divinerpg.events.Ticker;
import divinerpg.items.arcana.ItemArcanaPoweredSword;
import divinerpg.items.arcana.ItemStarSword;
import divinerpg.items.base.HealingSwordItem;
import divinerpg.items.base.IHitEffectArmor;
import divinerpg.items.base.KillEffectSwordItem;
import divinerpg.items.base.trap.TrapItem;
import divinerpg.packet.DivineRPGPacketHandler;
import divinerpg.packet.PacketArcanaBar;
import divinerpg.registries.BlockRegistry;
import divinerpg.registries.EntityRegistry;
import divinerpg.registries.ItemRegistry;
import divinerpg.registries.LevelRegistry;
import divinerpg.registries.MobEffectRegistry;
import divinerpg.registries.SoundRegistry;
import divinerpg.scheduling.AoAScheduler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.BoatItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import pro.komaru.tridot.api.Utils;
import pro.komaru.tridot.client.render.RenderBuilder;
import pro.komaru.tridot.client.render.TridotRenderTypes;
import pro.komaru.tridot.common.registry.item.armor.SuitArmorItem;
import pro.komaru.tridot.common.registry.item.builders.AbstractArmorBuilder;
import pro.komaru.tridot.util.Col;
import pro.komaru.tridot.util.Tmp;

@Mod.EventBusSubscriber(modid="divinerpg", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeEvents {
    public static final List<Item> VALORIA_DISABLED_LIST = new ArrayList<Item>();
    public static final List<Item> NUMBNESS_LIST = new ArrayList<Item>();
    public static final List<Item> ARCANA_DISABLED_LIST = new ArrayList<Item>();
    public static final List<Item> GAPPLES = new ArrayList<Item>();
    public static final List<EntityType<?>> BOSSES_LIST = new ArrayList();
    private static final int RADIUS = 20;

    public static void populateLists(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            DivineRPG.LOGGER.info("Populating mod lists...");
            VALORIA_DISABLED_LIST.add(Items.f_42584_);
            VALORIA_DISABLED_LIST.add((Item)ItemRegistry.ender_scepter.get());
            VALORIA_DISABLED_LIST.add(Items.f_42730_);
            VALORIA_DISABLED_LIST.add((Item)ItemRegistry.divine_scepter.get());
            VALORIA_DISABLED_LIST.add((Item)ItemRegistry.icicle_scepter.get());
            VALORIA_DISABLED_LIST.add((Item)ItemRegistry.valentine_scepter.get());
            NUMBNESS_LIST.add(Items.f_42584_);
            NUMBNESS_LIST.add(Items.f_42730_);
            NUMBNESS_LIST.add((Item)ItemRegistry.ender_scepter.get());
            NUMBNESS_LIST.add((Item)ItemRegistry.divine_scepter.get());
            NUMBNESS_LIST.add((Item)ItemRegistry.icicle_scepter.get());
            NUMBNESS_LIST.add((Item)ItemRegistry.valentine_scepter.get());
            NUMBNESS_LIST.add((Item)ItemRegistry.divine_accumulator.get());
            NUMBNESS_LIST.add((Item)ItemRegistry.ender_divine_accumulator.get());
            NUMBNESS_LIST.add((Item)ItemRegistry.unstable_divine_accumulator.get());
            NUMBNESS_LIST.add((Item)ItemRegistry.earth_divine_accumulator.get());
            NUMBNESS_LIST.add(Items.f_42741_);
            ARCANA_DISABLED_LIST.add(Items.f_42584_);
            ARCANA_DISABLED_LIST.add((Item)ItemRegistry.ender_scepter.get());
            ARCANA_DISABLED_LIST.add(Items.f_42730_);
            ARCANA_DISABLED_LIST.add(Items.f_41869_);
            ARCANA_DISABLED_LIST.add(Items.f_41862_);
            ARCANA_DISABLED_LIST.add((Item)ItemRegistry.divine_scepter.get());
            ARCANA_DISABLED_LIST.add((Item)ItemRegistry.icicle_scepter.get());
            ARCANA_DISABLED_LIST.add((Item)ItemRegistry.valentine_scepter.get());
            ARCANA_DISABLED_LIST.add((Item)ItemRegistry.ender_divine_accumulator.get());
            ForgeRegistries.ITEMS.getValues().forEach(item -> {
                if (item instanceof BoatItem) {
                    VALORIA_DISABLED_LIST.add((Item)item);
                    ARCANA_DISABLED_LIST.add((Item)item);
                    NUMBNESS_LIST.add((Item)item);
                }
            });
            GAPPLES.add(Items.f_42436_);
            GAPPLES.add(Items.f_42437_);
            BOSSES_LIST.add((EntityType)EntityRegistry.RAGLOK.get());
            BOSSES_LIST.add((EntityType)EntityRegistry.LADY_LUNA.get());
            BOSSES_LIST.add((EntityType)EntityRegistry.THE_WATCHER.get());
            BOSSES_LIST.add((EntityType)EntityRegistry.SUNSTORM.get());
            BOSSES_LIST.add((EntityType)EntityRegistry.TERMASECT.get());
            BOSSES_LIST.add((EntityType)EntityRegistry.ETERNAL_ARCHER.get());
            BOSSES_LIST.add((EntityType)EntityRegistry.EXPERIENCED_CORI.get());
            BOSSES_LIST.add((EntityType)EntityRegistry.KING_OF_SCORCHERS.get());
            BOSSES_LIST.add((EntityType)EntityRegistry.KITRA.get());
            BOSSES_LIST.add((EntityType)EntityRegistry.AYERACO.get());
            DivineRPG.LOGGER.info("Mod lists populated successfully. Found {} bosses and {}/{} disabled items.", (Object)BOSSES_LIST.size(), (Object)VALORIA_DISABLED_LIST.size(), (Object)ARCANA_DISABLED_LIST.size());
        });
    }

    @SubscribeEvent
    public static void onHit(AttackEntityEvent event) {
        Player attacker = event.getEntity();
        if (attacker == null) {
            return;
        }
        Entity entity = event.getTarget();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity target = (LivingEntity)entity;
        if (event.getEntity().m_6168_().iterator().next() == null || event.getEntity().m_6168_().iterator().next() == ItemStack.f_41583_) {
            return;
        }
        for (ItemStack stack : attacker.m_6168_()) {
            IHitEffectArmor armor;
            Item item;
            if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof IHitEffectArmor) || !Tmp.rnd.chance((armor = (IHitEffectArmor)item).getHitChance())) continue;
            for (MobEffectInstance eff : armor.getHitEffects()) {
                target.m_7292_(new MobEffectInstance(eff));
            }
        }
    }

    public static void processAttack(IHitEffectArmor armor, LivingEntity target) {
        armor.applyHitEffects(target);
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        Entity source = event.getSource().m_7639_();
        if (!(source instanceof Player)) {
            return;
        }
        Player player = (Player)source;
        ItemStack heldItem = player.m_21205_();
        Item item = heldItem.m_41720_();
        if (item instanceof KillEffectSwordItem) {
            KillEffectSwordItem sword = (KillEffectSwordItem)item;
            if (sword.isPlayerOnly() && !(event.getEntity() instanceof Player)) {
                return;
            }
            for (MobEffectInstance effect : sword.effects) {
                player.m_7292_(new MobEffectInstance(effect));
            }
        }
    }

    @SubscribeEvent
    public void onAttack(AttackEntityEvent event) {
        LivingEntity living;
        Entity target = event.getTarget();
        Player attacker = event.getEntity();
        if (!(target instanceof LivingEntity) || !attacker.m_6779_(living = (LivingEntity)target)) {
            return;
        }
        for (Map.Entry entry : ArmorStats.HIT_EFFECTS.entrySet()) {
            ArmorMaterial material = (ArmorMaterial)entry.getKey();
            if (!SuitArmorItem.hasCorrectArmorOn((ArmorMaterial)material, (Player)attacker)) continue;
            for (AbstractArmorBuilder.HitEffectData effectData : (List)entry.getValue()) {
                float chance = effectData.chance();
                if (!Tmp.rnd.chance(chance) || !effectData.condition().test(attacker)) continue;
                living.m_7292_((MobEffectInstance)effectData.instance().get());
            }
        }
    }

    @SubscribeEvent
    public void starSword(PlayerInteractEvent.RightClickItem event) {
        Player player = event.getEntity();
        ItemStack stack = event.getItemStack();
        Level world = event.getLevel();
        if (stack.m_41720_() instanceof ItemStarSword) {
            player.getCapability(ArcanaProvider.ARCANA).ifPresent(arcana -> {
                if (arcana.getAmount(false) >= 35.0f) {
                    int blockReachDistance = 12;
                    int count = world.m_213780_().m_216339_(3, 18);
                    arcana.consume(player, 35.0f);
                    Vec3 vec3d = player.m_20299_(1.0f);
                    Vec3 vec3d1 = player.m_20252_(1.0f);
                    Vec3 vec3d2 = vec3d.m_82520_(vec3d1.f_82479_ * (double)blockReachDistance, vec3d1.f_82480_ * (double)blockReachDistance, vec3d1.f_82481_ * (double)blockReachDistance);
                    BlockHitResult pos = player.m_9236_().m_45547_(new ClipContext(vec3d, vec3d2, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
                    player.m_36335_().m_41524_(stack.m_41720_(), 21);
                    world.m_247517_(null, player.m_20183_(), (SoundEvent)SoundRegistry.STARLIGHT.get(), SoundSource.PLAYERS);
                    for (int i = 0; i < count; ++i) {
                        EntityStar star = new EntityStar((EntityType<? extends ThrowableProjectile>)((EntityType)EntityRegistry.STARLIGHT.get()), (double)pos.m_82425_().m_123341_() + 0.5, (double)pos.m_82425_().m_123342_() + 25.0, (double)pos.m_82425_().m_123343_() + 0.5, world);
                        star.m_6027_(pos.m_82425_().m_123341_(), pos.m_82425_().m_123342_() + 12, pos.m_82425_().m_123343_());
                        star.m_5602_((Entity)player);
                        star.m_19749_();
                        world.m_7967_((Entity)star);
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public void itemAttributeModifier(ItemAttributeModifierEvent event) {
        ItemStack stack = event.getItemStack();
        Item item = stack.m_41720_();
        EquipmentSlot slot = event.getSlotType();
        if (item == Items.f_42393_ && slot == EquipmentSlot.MAINHAND) {
            event.clearModifiers();
            event.addModifier(Attributes.f_22281_, new AttributeModifier(Item.f_41374_, "Weapon modifier", 17.0, AttributeModifier.Operation.ADDITION));
            event.addModifier(Attributes.f_22283_, new AttributeModifier(Item.f_41375_, "Weapon modifier", -2.6, AttributeModifier.Operation.ADDITION));
        } else if (item == Items.f_42396_ && slot == EquipmentSlot.MAINHAND) {
            event.clearModifiers();
            event.addModifier(Attributes.f_22281_, new AttributeModifier(Item.f_41374_, "Weapon modifier", 20.0, AttributeModifier.Operation.ADDITION));
            event.addModifier(Attributes.f_22283_, new AttributeModifier(Item.f_41375_, "Weapon modifier", -3.0, AttributeModifier.Operation.ADDITION));
        }
    }

    @SubscribeEvent
    public static void onExplosionDetonate(ExplosionEvent.Detonate event) {
        Level level = event.getLevel();
        List affectedBlocks = event.getAffectedBlocks();
        Iterator iterator = affectedBlocks.iterator();
        while (iterator.hasNext()) {
            BlockPos blockPos = (BlockPos)iterator.next();
            BlockPos aboveBlockPos = blockPos.m_6630_(2);
            if (!level.m_8055_(aboveBlockPos).m_60795_() || level.m_45976_(EntityRaglok.class, new AABB(aboveBlockPos)).isEmpty()) continue;
            iterator.remove();
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        BlockPos blockPos = event.getPos();
        AABB areaToCheck = new AABB(blockPos.m_7918_(-1, 0, -1), blockPos.m_7918_(1, 2, 1));
        if (!event.getLevel().m_45976_(EntityRaglok.class, areaToCheck).isEmpty()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onExplosion(ExplosionEvent.Detonate event) {
        if (event.getLevel().m_46472_() == LevelGen.VALORIA_KEY) {
            event.getAffectedBlocks().clear();
            event.getAffectedEntities().clear();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onLivingDeath(ClientPlayerNetworkEvent.LoggingIn event) {
    }

    @SubscribeEvent
    public void emptinessFalling(LivingDamageEvent event) {
        DamageSource source = event.getSource();
        Level level = event.getEntity().m_9236_();
        if (source.m_276093_(DamageTypes.f_268671_) && level.m_46472_().equals(LevelRegistry.EMPTINESS)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (!event.isCanceled()) {
            Player player = event.getEntity();
            player.getCapability(ArcanaProvider.ARCANA).ifPresent(arcana -> {
                arcana.regen((LivingEntity)player);
                arcana.consume(player, 1.0f);
            });
            DivineRPGPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new PacketArcanaBar(new Arcana(), (LivingEntity)event.getEntity()));
            ArmorAbilitiesEvent.updateAbilities((LivingEntity)player);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onJoinServer(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (!event.isCanceled() && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            player.getCapability(ArcanaProvider.ARCANA).ifPresent(arcana -> {
                arcana.regen((LivingEntity)player);
                arcana.consume((Player)player, 1.0f);
            });
            DivineRPGPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketArcanaBar(new Arcana(), (LivingEntity)player));
            ArmorAbilitiesEvent.updateAbilities((LivingEntity)player);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (!event.isCanceled()) {
            Player player = event.getEntity();
            player.getCapability(ArcanaProvider.ARCANA).ifPresent(arcana -> {
                arcana.regen((LivingEntity)player);
                arcana.consume(player, 1.0f);
            });
            DivineRPGPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new PacketArcanaBar(new Arcana(), (LivingEntity)event.getEntity()));
            ArmorAbilitiesEvent.updateAbilities((LivingEntity)player);
        }
    }

    @SubscribeEvent
    public static void onPlayerInteractS(PlayerInteractEvent.RightClickItem event) {
        if (event.getLevel().m_46472_().equals((Object)LevelGen.VALORIA_KEY)) {
            BlockPos playerPos;
            Player player = event.getEntity();
            if (VALORIA_DISABLED_LIST.contains(event.getItemStack().m_41720_()) && ForgeEvents.isNearBlockEntity(player, playerPos = player.m_20183_())) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onBlockBreakS(BlockEvent.BreakEvent event) {
        BlockPos pos;
        Player player;
        Level level;
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof Level && (level = (Level)levelAccessor).m_46472_().equals((Object)LevelGen.VALORIA_KEY) && ForgeEvents.isNearBlockEntity(player = event.getPlayer(), pos = event.getPos())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        BlockPos pos;
        Player player;
        Entity entity;
        Level level;
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof Level && (level = (Level)levelAccessor).m_46472_().equals((Object)LevelGen.VALORIA_KEY) && (entity = event.getEntity()) instanceof Player && ForgeEvents.isNearBlockEntity(player = (Player)entity, pos = event.getPos())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getLevel().m_46472_().equals((Object)LevelGen.VALORIA_KEY)) {
            BlockPos pos = event.getPos();
            Player player = event.getEntity();
            BlockState clickedBlock = event.getLevel().m_8055_(pos);
            if (!(!(event instanceof PlayerInteractEvent.RightClickBlock) || player.m_21205_().m_150930_((Item)ItemsRegistry.soulCollector.get()) || player.m_21205_().m_150930_((Item)ItemsRegistry.voidKey.get()) || player.m_21205_().m_150930_(Items.f_41852_) || clickedBlock.m_60713_((Block)com.idark.valoria.registries.BlockRegistry.umbralBlock.get()) || clickedBlock.m_60713_((Block)com.idark.valoria.registries.BlockRegistry.voidPillar.get()) || clickedBlock.m_60713_((Block)com.idark.valoria.registries.BlockRegistry.voidPillarAmethyst.get()) || clickedBlock.m_60713_((Block)com.idark.valoria.registries.BlockRegistry.chargedVoidPillar.get()) || clickedBlock.m_60713_((Block)com.idark.valoria.registries.BlockRegistry.umbralKeypad.get()) || clickedBlock.m_60734_().m_49954_().getString().contains("chest") || clickedBlock.m_60734_().m_49954_().getString().contains("lootr") || clickedBlock.m_60734_().m_49954_().m_240452_(Component.m_130674_((String)"chest")) || clickedBlock.m_60713_((Block)BlockRegistry.soulTrap.get()) || !ForgeEvents.isNearBlockEntity(player, pos))) {
                event.setCanceled(true);
            }
        }
    }

    private static boolean isNearBlockEntity(Player player, BlockPos pos) {
        for (BlockPos checkPos : BlockPos.m_121940_((BlockPos)pos.m_7918_(-20, -20, -20), (BlockPos)pos.m_7918_(20, 20, 20))) {
            BlockEntity blockEntity = player.m_9236_().m_7702_(checkPos);
            if (!(blockEntity instanceof SoulTrapBlockEntity)) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void use(PlayerInteractEvent.RightClickItem event) {
        if (event.getLevel().m_46472_().equals(LevelRegistry.ARCANA)) {
            if (ARCANA_DISABLED_LIST.contains(event.getItemStack().m_41720_())) {
                event.setCanceled(true);
            }
            if (event.getItemStack().m_41720_() instanceof BoatItem) {
                event.setCanceled(true);
            }
        }
        if (event.getLevel().m_46472_().equals(LevelRegistry.EMPTINESS)) {
            if (event.getItemStack().m_150930_(Items.f_42584_)) {
                event.setCanceled(true);
            }
            if (event.getItemStack().m_41720_() instanceof BoatItem) {
                event.setCanceled(true);
            }
            if (event.getItemStack().m_150930_((Item)ItemRegistry.ender_divine_accumulator.get())) {
                event.setCanceled(true);
            }
            if (event.getItemStack().m_150930_((Item)ItemRegistry.divine_scepter.get())) {
                event.setCanceled(true);
            }
            if (event.getItemStack().m_150930_(Items.f_42730_)) {
                event.setCanceled(true);
            }
            if (event.getItemStack().m_150930_(Items.f_42650_)) {
                event.setCanceled(true);
            }
            if (event.getItemStack().m_150930_(Items.f_42617_) || event.getItemStack().m_150930_(Items.f_151063_) || event.getItemStack().m_150930_(Items.f_42487_)) {
                event.setCanceled(true);
            }
        }
        if (event.getEntity().m_21023_((MobEffect)MobEffectRegistry.CHAINED.get()) && NUMBNESS_LIST.contains(event.getItemStack().m_41720_())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void tick(TickEvent.PlayerTickEvent event) {
        if (event.player.m_21023_((MobEffect)MobEffectRegistry.CHAINED.get())) {
            event.player.f_36077_.f_35936_ = false;
        } else if (event.player.m_21023_((MobEffect)MobEffectRegistry.ANGELIC_FLIGHT.get())) {
            event.player.f_36077_.f_35936_ = true;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    @OnlyIn(value=Dist.CLIENT)
    public void onRenderPlayer(RenderPlayerEvent.Post event) {
        Player player = event.getEntity();
        if (!(((ItemStack)player.m_150109_().f_35975_.get(3)).m_150930_((Item)ItemRegistry.arcanium_helmet.get()) && ((ItemStack)player.m_150109_().f_35975_.get(2)).m_150930_((Item)ItemRegistry.arcanium_chestplate.get()) && ((ItemStack)player.m_150109_().f_35975_.get(1)).m_150930_((Item)ItemRegistry.arcanium_leggings.get()) && ((ItemStack)player.m_150109_().f_35975_.get(0)).m_150930_((Item)ItemRegistry.arcanium_boots.get()))) {
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.01, 0.0);
        float time = player.f_19797_ + Ticker.tick;
        float breathingSpeed = 0.25f;
        float breathingAmplitude = 47.5f;
        float breathingOffset = 122.5f;
        Col base = new Col(205, 0, 205);
        Col blue = new Col(85, 0, 255);
        float t = (float)((Math.sin(0.13f * time) + 1.0) / 2.0);
        Col color = base.copy().lerp(blue, t);
        long alpha = Math.round((double)breathingOffset + (double)breathingAmplitude * Math.sin(breathingSpeed * time));
        alpha = Math.min(alpha, 255L);
        Utils.Render.renderAura((RenderBuilder)RenderBuilder.create().setRenderType(TridotRenderTypes.ADDITIVE).enableSided().setFirstColor(color).setSecondColor(Col.white).setFirstAlpha(0.0f).setSecondAlpha((float)alpha), (PoseStack)poseStack, (float)2.7f, (float)0.0f, (int)12, (boolean)true);
        poseStack.m_85849_();
    }

    @SubscribeEvent
    public static void onServerWorldLoad(ServerStartedEvent event) {
        event.getServer().m_129785_().forEach(TrapItem.TrapInstance::loadSavedTraps);
    }

    @SubscribeEvent
    public void onPortalBlockPlacedEvent(BlockEvent.EntityPlaceEvent event) {
        Entity entity = event.getEntity();
        BlockState block = event.getPlacedBlock();
        if (entity instanceof Player && block.m_60734_() instanceof BlockModPortalBase) {
            event.getLevel().m_7731_(event.getPos(), (BlockState)block.m_61124_((Property)BlockStateProperties.f_222997_, (Comparable)Boolean.valueOf(true)), 1);
        }
    }

    @SubscribeEvent
    public static void arcanaAttack(AttackEntityEvent event) {
        Player attacker = event.getEntity();
        Entity targetEnt = event.getTarget();
        if (attacker instanceof Player) {
            Player player = attacker;
            if (targetEnt instanceof Player) {
                Player target = (Player)targetEnt;
                if (attacker.m_21205_().m_41720_() instanceof ItemArcanaPoweredSword) {
                    target.getCapability(ArcanaProvider.ARCANA).ifPresent(arcanaTarget -> player.getCapability(ArcanaProvider.ARCANA).ifPresent(arcana -> {
                        if (arcanaTarget.getArcana() >= (float)ItemArcanaPoweredSword.arcanaConsumed && (float)player.f_20913_ == 0.0f) {
                            arcanaTarget.consume(target, ItemArcanaPoweredSword.arcanaConsumed);
                            arcana.modifyAmount((LivingEntity)player, 10.0f);
                        }
                    }));
                }
            }
        }
    }

    @SubscribeEvent
    public static void placeBlock(PlayerInteractEvent.RightClickBlock event) {
        if (event.getLevel().m_46472_().equals(LevelRegistry.ARCANA) && ARCANA_DISABLED_LIST.contains(event.getItemStack().m_41720_())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onItemPickup(PlayerEvent.ItemPickupEvent event) {
        ItemStack pickedUp = event.getStack();
        Player player = event.getEntity();
        Level level = player.m_9236_();
        if (!level.f_46443_ && pickedUp.m_41720_() instanceof HealingSwordItem && HealingSwordItem.isRageMode(pickedUp) && !pickedUp.m_41720_().equals(ItemRegistry.illusivence.get())) {
            for (ItemStack invStack : player.m_150109_().f_35974_) {
                if (!ItemStack.m_150942_((ItemStack)invStack, (ItemStack)pickedUp)) continue;
                HealingSwordItem.setRageMode(invStack, false);
                level.m_247517_(null, player.m_20183_(), (SoundEvent)SoundsRegistry.RECHARGE.get(), SoundSource.PLAYERS);
                break;
            }
        }
    }

    @SubscribeEvent
    public static void placeChestOnDeath(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        Level world = entity.m_9236_();
        String s = "telekinesis";
        if (world.f_46443_) {
            return;
        }
        if (!(!BOSSES_LIST.contains(entity.m_6095_()) || entity.m_21205_().m_41785_().toString().contains(s) && entity.m_21211_().m_41785_().toString().contains(s) && entity.m_21206_().m_41785_().toString().contains(s) || entity.m_146904_() > 252)) {
            BlockPos pos = new BlockPos(entity.m_146903_(), entity.m_146904_() + 2, entity.m_146907_());
            world.m_7731_(pos, ((Block)BlockRegistry.boneChest.get()).m_49966_(), 3);
            BoneChestBlockEntity chest = (BoneChestBlockEntity)world.m_7702_(pos);
            if (chest != null) {
                AoAScheduler.scheduleAsyncTask(() -> chest.m_59626_(entity.m_6095_().m_20677_(), world.f_46441_.m_188505_()), 10, TimeUnit.MILLISECONDS);
            }
        }
    }

    @SubscribeEvent
    public static void disableDropsFromEntity(LivingDropsEvent event) {
        if (BOSSES_LIST.contains(event.getEntity().m_6095_())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void cooldownsFinish(LivingEntityUseItemEvent.Finish event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        ItemStack item = event.getItem();
        if (GAPPLES.contains(item.m_41720_())) {
            GAPPLES.forEach(g -> player.m_36335_().m_41524_(g, 7200));
        }
    }
}

