/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.events;

import divinerpg.compat.CuriosCompat;
import divinerpg.config.CommonConfig;
import divinerpg.events.ArmorAbilitiesEvent;
import divinerpg.registries.LevelRegistry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;

public class VetheaInventorySwapEvent {
    public static final String OVERWORLD_INVENTORY = "OvWorldInv";
    public static final String VETHEA_INVENTORY = "DreamInv";
    public static final String MODID_SEPERATOR = "divinerpg:";

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onDeath(LivingDeathEvent event) {
        LivingEntity livingEntity;
        if (!event.isCanceled() && (livingEntity = event.getEntity()) instanceof Player) {
            Player player = (Player)livingEntity;
            if (!((Boolean)CommonConfig.saferVetheanInventory.get()).booleanValue()) {
                if (player.m_9236_().m_46469_().m_46207_(GameRules.f_46133_)) {
                    if (player.m_9236_().m_46472_().equals(LevelRegistry.VETHEA)) {
                        this.saveToInv(player, VETHEA_INVENTORY);
                    } else {
                        this.saveToInv(player, OVERWORLD_INVENTORY);
                    }
                } else if (player.m_9236_().m_46472_().equals(LevelRegistry.VETHEA)) {
                    this.clearInv(player, VETHEA_INVENTORY);
                } else {
                    this.clearInv(player, OVERWORLD_INVENTORY);
                }
            }
            ArmorAbilitiesEvent.updateAbilities((LivingEntity)player);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (!event.isCanceled()) {
            Player player = event.getEntity();
            if (!((Boolean)CommonConfig.saferVetheanInventory.get()).booleanValue()) {
                if (player.m_9236_().m_46472_().equals(LevelRegistry.VETHEA)) {
                    this.loadInv(player, VETHEA_INVENTORY);
                } else {
                    this.loadInv(player, OVERWORLD_INVENTORY);
                }
                player.f_36095_.m_38946_();
            }
            ArmorAbilitiesEvent.updateAbilities((LivingEntity)player);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onDimensionChange(EntityTravelToDimensionEvent event) {
        Entity entity;
        if (!event.isCanceled() && (entity = event.getEntity()) instanceof Player) {
            Player player = (Player)entity;
            if (!((Boolean)CommonConfig.saferVetheanInventory.get()).booleanValue()) {
                boolean to;
                boolean from = player.m_9236_().m_46472_().equals(LevelRegistry.VETHEA);
                if (from ^ (to = event.getDimension().equals(LevelRegistry.VETHEA))) {
                    if (from) {
                        this.saveToInv(player, VETHEA_INVENTORY);
                        this.loadInv(player, OVERWORLD_INVENTORY);
                    } else {
                        this.saveToInv(player, OVERWORLD_INVENTORY);
                        this.loadInv(player, VETHEA_INVENTORY);
                    }
                    player.f_36095_.m_38946_();
                    player.m_21219_();
                } else if (from && to) {
                    this.saveToInv(player, VETHEA_INVENTORY);
                } else {
                    this.saveToInv(player, OVERWORLD_INVENTORY);
                }
            }
            ArmorAbilitiesEvent.updateAbilities((LivingEntity)player);
        }
    }

    public void saveToInv(Player player, String inv) {
        CompoundTag persisted = player.getPersistentData().m_128469_("PlayerPersisted");
        persisted.m_128365_(MODID_SEPERATOR + player.m_20149_() + "_" + inv, (Tag)player.f_36093_.m_36026_(new ListTag()));
        if (ModList.get().isLoaded("curios")) {
            CuriosCompat.saveInventory(persisted, player, inv);
        }
        player.getPersistentData().m_128365_("PlayerPersisted", (Tag)persisted);
    }

    public void loadInv(Player player, String inv) {
        ListTag newInventory = player.getPersistentData().m_128469_("PlayerPersisted").m_128437_(MODID_SEPERATOR + player.m_20149_() + "_" + inv, 10);
        if (ModList.get().isLoaded("curios")) {
            CuriosCompat.loadInventory(player, inv);
        }
        player.f_36093_.m_36035_(newInventory);
    }

    public void clearInv(Player player, String inv) {
        CompoundTag persisted = player.getPersistentData().m_128469_("PlayerPersisted");
        persisted.m_128365_(MODID_SEPERATOR + player.m_20149_() + "_" + inv, (Tag)new ListTag());
        if (ModList.get().isLoaded("curios")) {
            persisted.m_128365_(MODID_SEPERATOR + player.m_20149_() + "_Curio" + inv, (Tag)new ListTag());
        }
        player.getPersistentData().m_128365_("PlayerPersisted", (Tag)persisted);
    }
}

