/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.arcana;

import divinerpg.capability.ArcanaProvider;
import divinerpg.items.base.ItemModFood;
import divinerpg.registries.ItemRegistry;
import divinerpg.util.LocalizeUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public class ItemArcanaPotion
extends ItemModFood {
    protected int amountToAdd;

    public ItemArcanaPotion(FoodProperties list, int amountToAdd) {
        super(new Item.Properties().m_41489_(list));
        this.amountToAdd = amountToAdd;
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add(LocalizeUtils.arcanaRegen(this.amountToAdd));
    }

    public ItemStack m_5922_(ItemStack stack, Level worldIn, LivingEntity entityLiving) {
        entityLiving.getCapability(ArcanaProvider.ARCANA).ifPresent(arcana -> {
            if (arcana.getAmount(false) != arcana.getMaxArcana(entityLiving, false) || arcana.getAmount(true) != arcana.getMaxArcana(entityLiving, true)) {
                arcana.modifyAmount(entityLiving, this.amountToAdd);
            }
        });
        if (entityLiving instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entityLiving;
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            player.m_36335_().m_41524_((Item)ItemRegistry.weak_arcana_potion.get(), 188);
            player.m_36335_().m_41524_((Item)ItemRegistry.strong_arcana_potion.get(), 320);
        }
        return stack;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.DRINK;
    }

    @Override
    public int m_8105_(ItemStack par1ItemStack) {
        return 20;
    }

    public boolean m_5812_(ItemStack stack) {
        return true;
    }
}

