/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.arcana;

import divinerpg.capability.ArcanaProvider;
import divinerpg.items.base.ItemMod;
import divinerpg.packet.DivineRPGPacketHandler;
import divinerpg.packet.PacketDivineAccumulator;
import divinerpg.registries.MobEffectRegistry;
import divinerpg.registries.ParticleRegistry;
import divinerpg.registries.SoundRegistry;
import divinerpg.util.LocalizeUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import org.jetbrains.annotations.NotNull;

public class ItemDivineAccumulator
extends ItemMod {
    private final Boolean isUnstable;
    private final Boolean isEnder;
    private final Boolean isEarth;

    public ItemDivineAccumulator(Boolean isUnstable, Boolean isEnder, Boolean isEarth, Rarity rarity) {
        super(new Item.Properties().m_41487_(1).m_41497_(rarity));
        this.isUnstable = isUnstable;
        this.isEnder = isEnder;
        this.isEarth = isEarth;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level world, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (world.f_46443_) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (!(player instanceof ServerPlayer)) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        return player.getCapability(ArcanaProvider.ARCANA).map(arcana -> {
            if (!(this.isUnstable.booleanValue() || this.isEnder.booleanValue() || this.isEarth.booleanValue())) {
                if (arcana.getAmount(false) < 80.0f) {
                    return InteractionResultHolder.m_19100_((Object)stack);
                }
                arcana.modifyAmount((LivingEntity)player, -80.0f);
                player.m_6674_(hand);
                world.m_5594_(null, player.m_20183_(), (SoundEvent)SoundRegistry.DIVINE_ACCUMULATOR.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                player.m_20334_(player.m_20184_().f_82479_, 2.0, player.m_20184_().f_82481_);
                player.f_19789_ = 0.0f;
                player.f_19812_ = true;
                player.f_19864_ = true;
                ItemDivineAccumulator.spawnParticleCircleAroundPlayer(player, world, (ParticleOptions)ParticleRegistry.EDEN_PORTAL.get(), 3);
                player.m_7292_(new MobEffectInstance((MobEffect)MobEffectRegistry.PREVENT_FALL_DAMAGE.get(), 200, 0));
                player.m_36335_().m_41524_((Item)this, 215);
                return InteractionResultHolder.m_19090_((Object)stack);
            }
            if (this.isUnstable.booleanValue()) {
                if (arcana.getAmount(false) < 100.0f) {
                    return InteractionResultHolder.m_19100_((Object)stack);
                }
                arcana.modifyAmount((LivingEntity)player, -100.0f);
                player.m_6674_(hand);
                world.m_5594_(null, player.m_20183_(), (SoundEvent)SoundRegistry.DIVINE_ACCUMULATOR.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                player.m_7292_(new MobEffectInstance((MobEffect)MobEffectRegistry.EXPLOSION_PROTECTION.get(), 40, 0));
                player.m_7292_(new MobEffectInstance((MobEffect)MobEffectRegistry.PREVENT_FALL_DAMAGE.get(), 100, 0));
                world.m_255391_(null, player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_(), 4.0f, false, Level.ExplosionInteraction.NONE);
                ItemDivineAccumulator.spawnParticleCircleAroundPlayer(player, world, (ParticleOptions)ParticleRegistry.MORTUM_PORTAL.get(), 6);
                player.m_36335_().m_41524_((Item)this, 215);
                return InteractionResultHolder.m_19090_((Object)stack);
            }
            if (this.isEnder.booleanValue()) {
                if (arcana.getAmount(false) < 75.0f) {
                    return InteractionResultHolder.m_19100_((Object)stack);
                }
                arcana.modifyAmount((LivingEntity)player, -75.0f);
                player.m_6674_(hand);
                double d0 = player.m_20185_();
                double d1 = player.m_20186_();
                double d2 = player.m_20189_();
                for (int i = 0; i < 16; ++i) {
                    double d3 = player.m_20185_() + (player.m_217043_().m_188500_() - 0.5) * 16.0;
                    double d4 = Mth.m_14008_((double)(player.m_20186_() + (double)(player.m_217043_().m_188503_(16) - 8)), (double)world.m_141937_(), (double)(world.m_141937_() + ((ServerLevel)world).m_143344_() - 1));
                    double d5 = player.m_20189_() + (player.m_217043_().m_188500_() - 0.5) * 16.0;
                    if (player.m_20159_()) {
                        player.m_8127_();
                    }
                    Vec3 vec3 = player.m_20182_();
                    world.m_214171_(GameEvent.f_238175_, vec3, GameEvent.Context.m_223717_((Entity)player));
                    EntityTeleportEvent.ChorusFruit event = ForgeEventFactory.onChorusFruitTeleport((LivingEntity)player, (double)d3, (double)d4, (double)d5);
                    if (!player.m_20984_(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true)) continue;
                    world.m_6263_(null, d0, d1, d2, SoundEvents.f_11757_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    player.m_5496_(SoundEvents.f_11757_, 1.0f, 1.0f);
                    break;
                }
                player.m_36335_().m_41524_((Item)this, 150);
                return InteractionResultHolder.m_19090_((Object)stack);
            }
            if (this.isEarth.booleanValue()) {
                if (arcana.getAmount(false) < 125.0f) {
                    return InteractionResultHolder.m_19100_((Object)stack);
                }
                arcana.modifyAmount((LivingEntity)player, -125.0f);
                player.m_6674_(hand);
                world.m_5594_(null, player.m_20183_(), (SoundEvent)SoundRegistry.DIVINE_ACCUMULATOR.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                List entities = world.m_6249_((Entity)player, player.m_20191_().m_82400_(5.0), entity -> entity instanceof LivingEntity && entity != player && entity.m_6084_());
                for (Entity entity2 : entities) {
                    entity2.m_20334_(entity2.m_20184_().f_82479_, (double)1.8f, entity2.m_20184_().f_82481_);
                    player.f_19789_ = 0.0f;
                    player.f_19812_ = true;
                    player.f_19864_ = true;
                    Vec3 vel = player.m_20252_(0.0f);
                    if (entity2 instanceof ServerPlayer) {
                        ServerPlayer sp = (ServerPlayer)entity2;
                        DivineRPGPacketHandler.sendTo(sp, new PacketDivineAccumulator((float)vel.f_82479_, 0.67f, (float)vel.f_82481_));
                    }
                    ((LivingEntity)entity2).m_7292_(new MobEffectInstance(MobEffects.f_19610_, 35, 0));
                }
                if (!player.m_6047_() || !player.m_6144_()) {
                    player.m_20334_(player.m_20184_().f_82479_, (double)1.8f, player.m_20184_().f_82481_);
                    player.f_19789_ = 0.0f;
                    player.f_19812_ = true;
                    player.f_19864_ = true;
                }
                ItemDivineAccumulator.spawnParticleCircleAroundPlayer(player, world, (ParticleOptions)ParticleRegistry.SKYTHERN_PORTAL.get(), 5);
                player.m_7292_(new MobEffectInstance((MobEffect)MobEffectRegistry.PREVENT_FALL_DAMAGE.get(), 200, 0));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 200, 1));
                player.m_36335_().m_41524_((Item)this, 215);
                return InteractionResultHolder.m_19090_((Object)stack);
            }
            return InteractionResultHolder.m_19100_((Object)stack);
        }).orElse(InteractionResultHolder.m_19100_((Object)stack));
    }

    public static void spawnParticleCircleAroundPlayer(Player player, Level world, ParticleOptions pType, int radius) {
        int numParticles = 125;
        if (!world.m_5776_() && world instanceof ServerLevel) {
            ServerLevel pServer = (ServerLevel)world;
            for (int i = 0; i < numParticles; ++i) {
                double angle = Math.PI * 2 * (double)i / (double)numParticles;
                double x = player.m_20185_() + (double)radius * Math.cos(angle);
                double z = player.m_20189_() + (double)radius * Math.sin(angle);
                double y = player.m_20186_();
                pServer.m_8767_(pType, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> list, TooltipFlag flagIn) {
        if (!(this.isUnstable.booleanValue() || this.isEnder.booleanValue() || this.isEarth.booleanValue())) {
            list.add(LocalizeUtils.i18n("tooltip.divine_accumulator.launch", new Object[0]));
            list.add(LocalizeUtils.i18n("tooltip.divine_accumulator.fall", new Object[0]));
            list.add(LocalizeUtils.arcanaConsumed(80));
        } else if (this.isUnstable.booleanValue()) {
            list.add(LocalizeUtils.i18n("tooltip.divine_accumulator.explosion", new Object[0]));
            list.add(LocalizeUtils.i18n("tooltip.divine_accumulator.explosion_protection", new Object[0]));
            list.add(LocalizeUtils.i18n("tooltip.divine_accumulator.fall", new Object[0]));
            list.add(LocalizeUtils.arcanaConsumed(100));
        } else if (this.isEnder.booleanValue()) {
            list.add(LocalizeUtils.i18n("tooltip.divine_accumulator.chorus", new Object[0]));
            list.add(LocalizeUtils.arcanaConsumed(75));
        } else if (this.isEarth.booleanValue()) {
            list.add(LocalizeUtils.i18n("tooltip.divine_accumulator.earth_launch", new Object[0]));
            list.add(LocalizeUtils.i18n("tooltip.divine_accumulator.shift_earth_launch", new Object[0]));
            list.add(LocalizeUtils.i18n("tooltip.divine_accumulator.blind", new Object[0]));
            list.add(LocalizeUtils.i18n("tooltip.divine_accumulator.effects", new Object[0]));
            list.add(LocalizeUtils.i18n("tooltip.divine_accumulator.fall", new Object[0]));
            list.add(LocalizeUtils.arcanaConsumed(125));
        }
        list.add(LocalizeUtils.infiniteUses());
    }
}

