/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.arcana;

import divinerpg.items.base.ItemScepterBase;
import divinerpg.registries.MobEffectRegistry;
import divinerpg.registries.ParticleRegistry;
import divinerpg.util.LocalizeUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;

public class ItemDivineScepter
extends ItemScepterBase {
    public ItemDivineScepter(Rarity rarity) {
        super(rarity);
    }

    @Override
    protected int getTeleportDistance() {
        return 5;
    }

    @Override
    protected int getCooldown() {
        return 86;
    }

    @Override
    protected SimpleParticleType getParticleType() {
        return (SimpleParticleType)ParticleRegistry.EDEN_PORTAL.get();
    }

    @Override
    protected int getChargeTime() {
        return 30;
    }

    @Override
    protected void applyTeleportEffect(ServerPlayer player, Level level, BlockHitResult hitResult) {
        if (!level.f_46443_) {
            player.m_150110_().f_35935_ = true;
            player.m_6885_();
            player.m_7292_(new MobEffectInstance((MobEffect)MobEffectRegistry.ANGELIC_FLIGHT.get(), 24));
            player.m_7292_(new MobEffectInstance((MobEffect)MobEffectRegistry.PREVENT_FALL_DAMAGE.get(), 75));
        }
    }

    @Override
    protected void addExtraTooltips(List<Component> tooltip) {
        tooltip.add(LocalizeUtils.i18n("tooltip.ender_scepter.divine.flight", new Object[0]));
        tooltip.add(LocalizeUtils.i18n("tooltip.divine_accumulator.fall", new Object[0]));
    }

    @Override
    protected BlockPos getTeleportPosition(BlockHitResult hitResult) {
        return hitResult.m_82425_().m_7494_();
    }
}

