/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.arcana;

import divinerpg.items.arcana.ItemDivineAccumulator;
import divinerpg.items.base.ItemScepterBase;
import divinerpg.registries.ParticleRegistry;
import divinerpg.registries.SoundRegistry;
import divinerpg.util.LocalizeUtils;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;

public class ItemIcicleScepter
extends ItemScepterBase {
    public ItemIcicleScepter(Rarity rarity) {
        super(rarity);
    }

    @Override
    protected int getTeleportDistance() {
        return 80;
    }

    @Override
    protected int getCooldown() {
        return 85;
    }

    @Override
    protected SimpleParticleType getParticleType() {
        return (SimpleParticleType)ParticleRegistry.FROST.get();
    }

    @Override
    protected int getChargeTime() {
        return 31;
    }

    @Override
    protected void applyTeleportEffect(ServerPlayer player, Level level, BlockHitResult hitResult) {
        ItemDivineAccumulator.spawnParticleCircleAroundPlayer((Player)player, level, (ParticleOptions)ParticleRegistry.FROST.get(), 5);
        List entities = level.m_45976_(Entity.class, player.m_20191_().m_82400_(5.0));
        for (Entity entity : entities) {
            if (entity == player || !(entity instanceof LivingEntity) || !entity.m_6084_()) continue;
            ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19597_, 45, 4));
        }
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)SoundRegistry.FROST.get(), player.m_5720_(), 1.0f, 1.5f);
    }

    @Override
    protected void addExtraTooltips(List<Component> tooltip) {
        tooltip.add(LocalizeUtils.i18n("tooltip.ender_scepter.icicle", new Object[0]));
    }
}

