/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.arcana;

import divinerpg.entities.projectile.EntityStar;
import divinerpg.enums.BulletType;
import divinerpg.items.base.ItemModRanged;
import divinerpg.registries.EntityRegistry;
import divinerpg.registries.SoundRegistry;
import divinerpg.util.LocalizeUtils;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class ItemStaffStarlight
extends ItemModRanged {
    private final int count;
    private final Component starsInfo;

    public ItemStaffStarlight(int arcana, int count) {
        super("star", null, (Supplier<SoundEvent>)SoundRegistry.STARLIGHT, SoundSource.MASTER, -1, 0, null, arcana);
        this.count = count;
        this.starsInfo = LocalizeUtils.i18n(count > 1 ? "tooltip.staff_of_starlight" : "tooltip.starlight", new Object[0]);
    }

    @Override
    protected void spawnEntity(Level world, Player player, ItemStack stack, BulletType bulletType, String entityType) {
        int blockReachDistance = 32;
        Vec3 vec3d = player.m_20299_(1.0f);
        Vec3 vec3d1 = player.m_20252_(1.0f);
        Vec3 vec3d2 = vec3d.m_82520_(vec3d1.f_82479_ * (double)blockReachDistance, vec3d1.f_82480_ * (double)blockReachDistance, vec3d1.f_82481_ * (double)blockReachDistance);
        BlockHitResult pos = player.m_9236_().m_45547_(new ClipContext(vec3d, vec3d2, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
        if (!world.f_46443_) {
            for (int i = 0; i < this.count; ++i) {
                EntityStar star = new EntityStar((EntityType<? extends ThrowableProjectile>)((EntityType)EntityRegistry.STARLIGHT.get()), (double)pos.m_82425_().m_123341_() + 0.5, (double)pos.m_82425_().m_123342_() + 25.0, (double)pos.m_82425_().m_123343_() + 0.5, world);
                star.m_6027_(pos.m_82425_().m_123341_(), pos.m_82425_().m_123342_() + 20, pos.m_82425_().m_123343_());
                star.m_5602_((Entity)player);
                world.m_7967_((Entity)star);
            }
        }
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add(LocalizeUtils.rangedDam(20.0));
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        tooltip.add(this.starsInfo);
    }
}

