/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.armor;

import divinerpg.capability.ArcanaProvider;
import divinerpg.enums.ArmorStats;
import divinerpg.items.base.DivineFullSetArmor;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ArcaniumArmor
extends DivineFullSetArmor {
    public ArcaniumArmor(Rarity rarity, ArmorMaterial material, ArmorItem.Type type) {
        super(material, type, new Item.Properties().m_41497_(rarity));
    }

    public void onArmorTick(ItemStack stack, Level level, Player player) {
        super.onArmorTick(stack, level, player);
        if (level.m_5776_()) {
            return;
        }
        if (ArcaniumArmor.hasCorrectArmorOn((ArmorMaterial)ArmorStats.ARCANIUM, (Player)player)) {
            List<Player> players = ArcaniumArmor.getPlayersInRadius(level, player.m_20183_().m_252807_(), 3.0);
            for (Player p : players) {
                if (p == null || p == player) continue;
                player.getCapability(ArcanaProvider.ARCANA).ifPresent(arcana -> arcana.modifyAmount((LivingEntity)player, 0.135f));
            }
        }
    }

    public static List<Player> getPlayersInRadius(Level world, Vec3 center, double radius) {
        double radiusSquared = radius * radius;
        return world.m_6907_().stream().filter(player -> player.m_20275_(center.f_82479_, center.f_82480_, center.f_82481_) <= radiusSquared).collect(Collectors.toList());
    }

    @Override
    protected List<String> getCustomAbilityStrings() {
        return List.of("\u0412\u043e\u0441\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u0435\u0442 \u0430\u0440\u043a\u0430\u043d\u0443 \u0432 \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0441\u0442\u0438 \u043e\u0442 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u0430 \u0438\u0433\u0440\u043e\u043a\u043e\u0432 \u0432\u043e\u043a\u0440\u0443\u0433");
    }
}

