/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.base;

import divinerpg.enums.ArmorStats;
import divinerpg.items.base.IHitEffectArmor;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import pro.komaru.tridot.common.registry.item.armor.SuitArmorItem;
import pro.komaru.tridot.common.registry.item.builders.AbstractArmorBuilder;

public class DivineFullSetArmor
extends SuitArmorItem
implements IHitEffectArmor {
    public ArmorItem.Type type;
    protected final float hitChance;
    protected final List<MobEffectInstance> hitEffects;

    public DivineFullSetArmor(ArmorMaterial material, ArmorItem.Type type, Item.Properties settings) {
        super(material, type, settings);
        this.type = type;
        this.hitChance = 0.0f;
        this.hitEffects = List.of();
    }

    public DivineFullSetArmor(ArmorMaterial material, ArmorItem.Type type, Item.Properties settings, float chance, MobEffectInstance ... effects) {
        super(material, type, settings);
        this.type = type;
        this.hitChance = chance;
        this.hitEffects = List.of(effects);
    }

    public DivineFullSetArmor(Rarity rarity, ArmorMaterial material, ArmorItem.Type type) {
        super(material, type, new Item.Properties().m_41497_(rarity));
        this.type = type;
        this.hitChance = 0.0f;
        this.hitEffects = List.of();
    }

    public DivineFullSetArmor(Rarity rarity, ArmorMaterial material, ArmorItem.Type type, Item.Properties settings) {
        super(material, type, settings.m_41497_(rarity));
        this.type = type;
        this.hitChance = 0.0f;
        this.hitEffects = List.of();
    }

    public DivineFullSetArmor(ArmorStats armorStats, ArmorItem.Type type, float hitChance, List<MobEffectInstance> hitEffects) {
        super((ArmorMaterial)armorStats, type, new Item.Properties());
        this.hitChance = hitChance;
        this.hitEffects = hitEffects;
    }

    public DivineFullSetArmor(ArmorStats armorStats, ArmorItem.Type type) {
        super((ArmorMaterial)armorStats, type, new Item.Properties());
        this.type = type;
        this.hitChance = 0.0f;
        this.hitEffects = List.of();
    }

    @Override
    public float getHitChance() {
        return this.hitChance;
    }

    @Override
    public List<MobEffectInstance> getHitEffects() {
        return this.hitEffects;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        Item item = stack.m_41720_();
        if (!(item instanceof ArmorItem)) {
            return;
        }
        ArmorItem armor = (ArmorItem)item;
        ArmorMaterial material = armor.m_40401_();
        if (material instanceof ArmorStats) {
            ArmorStats stats = (ArmorStats)material;
            tooltip.add((Component)Component.m_237115_((String)"tooltip.fullset").m_130940_(ChatFormatting.GRAY));
            this.appendEffectListTooltip(stack, tooltip, (List)ArmorStats.EFFECTS.get((Object)stats), "tooltip.divinerpg.applies_fullkit", AbstractArmorBuilder.ArmorEffectData::instance, null);
            this.appendEffectListTooltip(stack, tooltip, (List)ArmorStats.HIT_EFFECTS.get((Object)stats), "tooltip.divinerpg.applies_with_chance_target", AbstractArmorBuilder.HitEffectData::instance, AbstractArmorBuilder.HitEffectData::chance);
            List<String> abilityLines = this.getCustomAbilityStrings();
            if (!abilityLines.isEmpty()) {
                abilityLines.forEach(line -> this.appendCustomAbilities(tooltip, (String)line));
            }
        }
        this.appendHitEffectTooltip(stack, tooltip);
    }

    protected List<String> getCustomAbilityStrings() {
        return Collections.emptyList();
    }

    public void appendCustomAbilities(List<Component> tooltip, String newString) {
        MutableComponent line = Component.m_237113_((String)"  ").m_7220_((Component)Component.m_237113_((String)newString)).m_130940_(ChatFormatting.GRAY);
        tooltip.add((Component)line);
    }

    protected <T> void appendEffectListTooltip(ItemStack stack, List<Component> tooltip, List<T> effects, String translationKey, Function<T, Supplier<MobEffectInstance>> instanceExtractor, @Nullable Function<T, Float> chanceExtractor) {
        if (effects == null || effects.isEmpty()) {
            return;
        }
        for (T effectData : effects) {
            MobEffectInstance instance = instanceExtractor.apply(effectData).get();
            float chance = chanceExtractor != null ? chanceExtractor.apply(effectData).floatValue() : 1.0f;
            int percent = Math.round(chance * 100.0f);
            MutableComponent effectName = instance.m_19544_().m_19482_().m_6881_().m_130938_(stack.m_41791_().getStyleModifier());
            MutableComponent details = Component.m_237113_((String)(" " + this.levelToRoman(instance.m_19564_() + 1))).m_130938_(stack.m_41791_().getStyleModifier());
            MutableComponent line = Component.m_237113_((String)"  ").m_7220_((Component)Component.m_237110_((String)translationKey, (Object[])new Object[]{percent + "%"}).m_130940_(ChatFormatting.GRAY)).m_7220_((Component)effectName).m_7220_((Component)details);
            tooltip.add((Component)line);
        }
    }

    private String levelToRoman(int level) {
        return switch (level) {
            case 1 -> "";
            case 2 -> "II";
            case 3 -> "III";
            case 4 -> "IV";
            case 5 -> "V";
            case 6 -> "VI";
            case 7 -> "VII";
            case 8 -> "VIII";
            case 9 -> "IX";
            case 10 -> "X";
            default -> Integer.toString(level);
        };
    }
}

