/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.base;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.idark.valoria.Valoria;
import com.idark.valoria.core.network.PacketHandler;
import com.idark.valoria.core.network.packets.particle.DashParticlePacket;
import com.idark.valoria.registries.AttributeReg;
import com.idark.valoria.registries.item.types.KatanaItem;
import com.idark.valoria.registries.item.types.builders.AbstractKatanaBuilder;
import divinerpg.capability.ArcanaProvider;
import divinerpg.util.LocalizeUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;
import pro.komaru.tridot.api.Utils;
import pro.komaru.tridot.api.interfaces.CooldownNotifyItem;
import pro.komaru.tridot.util.math.ArcRandom;

public class DivineKatana
extends KatanaItem
implements CooldownNotifyItem {
    public DivineKatana(AbstractKatanaBuilder<DivineKatana> builderIn) {
        super(builderIn.tier, builderIn.attackDamageIn, builderIn.attackSpeedIn, builderIn.itemProperties);
        this.builder = builderIn;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", (double)builderIn.attackDamageIn, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", (double)builderIn.attackSpeedIn, AttributeModifier.Operation.ADDITION));
        builder.put((Object)((Attribute)AttributeReg.DASH_DISTANCE.get()), (Object)new AttributeModifier(Valoria.BASE_DASH_DISTANCE_UUID, "Tool modifier", (double)builderIn.dashDist, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    public DivineKatana(Tier tier, int attackDamageIn, float attackSpeedIn, Item.Properties builderIn) {
        this((AbstractKatanaBuilder<DivineKatana>)new Builder(attackDamageIn, attackSpeedIn, builderIn).setTier(tier));
    }

    @Deprecated
    public DivineKatana(Tier tier, int attackDamageIn, float attackSpeedIn, float dashDistance, Item.Properties builderIn, MobEffectInstance ... pEffects) {
        this((AbstractKatanaBuilder<DivineKatana>)new Builder(attackDamageIn, attackSpeedIn, builderIn).setTier(tier).setDashDistance(dashDistance).setEffects(pEffects));
    }

    @Deprecated
    public DivineKatana(Tier tier, int attackDamageIn, float attackSpeedIn, float dashDistance, Item.Properties builderIn, float chance, MobEffectInstance ... pEffects) {
        this((AbstractKatanaBuilder<DivineKatana>)new Builder(attackDamageIn, attackSpeedIn, builderIn).setTier(tier).setDashDistance(dashDistance).setEffects(chance, pEffects));
    }

    public void m_5929_(@NotNull Level worldIn, @NotNull LivingEntity livingEntityIn, @NotNull ItemStack stack, int count) {
        Player player = (Player)livingEntityIn;
        if (player.m_21252_() == this.builder.chargeTime) {
            if (this.builder.chargedSound != null) {
                player.m_6330_(this.builder.chargedSound, SoundSource.PLAYERS, 0.25f, 1.0f);
            }
            RandomSource rand = worldIn.m_213780_();
            Vector3d pos = new Vector3d(player.m_20185_(), player.m_20186_() + (double)player.m_20192_(), player.m_20189_());
            if (!player.m_21255_() && player.m_21252_() >= this.builder.chargeTime) {
                player.getCapability(ArcanaProvider.ARCANA).ifPresent(arcana -> {
                    if (arcana.getAmount(false) >= 45.0f) {
                        arcana.consume(player, 45.0f);
                        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                        this.applyCooldown(player);
                        this.performDash(stack, worldIn, player, pos, rand);
                        worldIn.m_5594_(null, player.m_20097_(), this.builder.dashSound, SoundSource.PLAYERS, 1.0f, 1.0f);
                        player.m_5810_();
                    }
                });
            }
        }
    }

    public static double distance(double distance, Level level, Player player) {
        double pitch = (double)(player.m_20155_().f_82470_ + 90.0f) * Math.PI / 180.0;
        double yaw = (double)(player.m_20155_().f_82471_ + 90.0f) * Math.PI / 180.0;
        double X = Math.sin(pitch) * Math.cos(yaw) * distance;
        double Y = Math.cos(pitch) * distance;
        double Z = Math.sin(pitch) * Math.sin(yaw) * distance;
        Vec3 pos = new Vec3(player.m_20185_(), player.m_20186_() + (double)player.m_20192_(), player.m_20189_());
        Vec3 EndPos = player.m_20252_(0.0f).m_82490_(2.0);
        HitResult hitresult = Utils.Hit.hitResult((Vec3)player.m_146892_(), (Entity)player, e -> true, (Vec3)EndPos, (Level)level);
        if (hitresult != null) {
            switch (hitresult.m_6662_()) {
                case BLOCK: 
                case MISS: {
                    X = hitresult.m_82450_().m_7096_();
                    Y = hitresult.m_82450_().m_7098_();
                    Z = hitresult.m_82450_().m_7094_();
                    break;
                }
                case ENTITY: {
                    Entity entity = ((EntityHitResult)hitresult).m_82443_();
                    X = entity.m_20185_();
                    Y = entity.m_20186_();
                    Z = entity.m_20189_();
                }
            }
        }
        return Math.sqrt((X - pos.f_82479_) * (X - pos.f_82479_) + (Y - pos.f_82480_) * (Y - pos.f_82480_) + (Z - pos.f_82481_) * (Z - pos.f_82481_));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level worldIn, Player playerIn, @NotNull InteractionHand handIn) {
        ItemStack itemstack = playerIn.m_21120_(handIn);
        playerIn.getCapability(ArcanaProvider.ARCANA).ifPresent(arcana -> {
            if (arcana.getAmount(false) >= 45.0f && !playerIn.m_6144_() && handIn != InteractionHand.OFF_HAND) {
                playerIn.m_6672_(handIn);
            }
        });
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }

    public void performDash(@NotNull ItemStack stack, @NotNull Level level, @NotNull Player player, Vector3d pos, RandomSource rand) {
        double pitch = (double)(player.m_20155_().f_82470_ + 90.0f) * Math.PI / 180.0;
        double yaw = (double)(player.m_20155_().f_82471_ + 90.0f) * Math.PI / 180.0;
        double dashDistance = this.getDashDistance(player);
        Vec3 dir = player.m_20252_(0.0f).m_82490_(dashDistance);
        player.m_5997_(dir.f_82479_, dir.f_82480_ * 0.25, dir.f_82481_);
        double ii = 1.0;
        if (level instanceof ServerLevel) {
            ServerLevel srv = (ServerLevel)level;
            if (!this.builder.usePacket) {
                for (int i = 0; i < 10; ++i) {
                    double locDistance = (double)i * 0.5;
                    double X = Math.sin(pitch) * Math.cos(yaw) * locDistance;
                    double Y = Math.cos(pitch) * 2.0;
                    double Z = Math.sin(pitch) * Math.sin(yaw) * locDistance;
                    srv.m_8767_(this.builder.particleOptions, pos.x + X + (rand.m_188500_() - 0.5), pos.y + Y, pos.z + Z + (rand.m_188500_() - 0.5), 1, 0.0, 0.5, 0.0, 0.0);
                    List detectedEntities = level.m_45976_(LivingEntity.class, new AABB(pos.x + X - 0.5, pos.y + Y - 0.5, pos.z + Z - 0.5, pos.x + X + 0.5, pos.y + Y + 0.5, pos.z + Z + 0.5));
                    for (LivingEntity entity : detectedEntities) {
                        if (!entity.equals((Object)player)) {
                            entity.m_6469_(level.m_269111_().m_269075_(player), (float)(player.m_21133_(Attributes.f_22281_) * ii + (double)EnchantmentHelper.m_44821_((LivingEntity)player) + (double)EnchantmentHelper.m_44833_((ItemStack)stack, (MobType)entity.m_6336_())) * 1.35f);
                            this.performEffects(entity, player);
                            Utils.Entities.applyWithChance((LivingEntity)entity, (ImmutableList)this.builder.effects, (float)this.builder.chance, (ArcRandom)this.arcRandom);
                            if (!player.m_7500_()) {
                                stack.m_41622_(this.getHurtAmount(detectedEntities), (LivingEntity)player, plr -> plr.m_21166_(EquipmentSlot.MAINHAND));
                            }
                        }
                        ii -= 1.0 / (double)(detectedEntities.size() * 2);
                    }
                    if (!(locDistance >= DivineKatana.distance(dashDistance, level, player))) {
                        continue;
                    }
                    break;
                }
            } else {
                PacketHandler.sendToTracking((Level)srv, (BlockPos)player.m_20097_(), (Object)new DashParticlePacket(player.m_20148_(), 1, 0.0f, 0.0f, 0.0f, this.builder.dashColor));
            }
        }
    }

    public void m_7373_(@NotNull ItemStack stack, Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flags) {
        Utils.Items.addSkinTooltip((ItemStack)stack, tooltip);
        tooltip.add((Component)Component.m_237115_((String)"tooltip.valoria.katana").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.valoria.rmb").m_130940_(ChatFormatting.GREEN));
        tooltip.add(LocalizeUtils.arcanaConsumed(45));
        Utils.Items.effectTooltip((ImmutableList)this.builder.effects, tooltip, (float)1.0f, (float)this.builder.chance);
    }

    public static class Builder
    extends AbstractKatanaBuilder<DivineKatana> {
        public Builder(int attackDamageIn, float attackSpeedIn, Item.Properties itemProperties) {
            super((float)attackDamageIn, attackSpeedIn, itemProperties);
        }

        public DivineKatana build() {
            return new DivineKatana(this);
        }
    }
}

