/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.base;

import divinerpg.client.renders.item.DivineShieldRenderer;
import divinerpg.util.LocalizeUtils;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class DivineShield
extends ShieldItem {
    public ResourceLocation resource;
    private final Ingredient repairMaterial;
    private final int duration;

    public DivineShield(Rarity rarity, ResourceLocation repairMaterial, int damage, String name, int duration) {
        super(new Item.Properties().m_41503_(damage).m_41497_(rarity));
        this.repairMaterial = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ForgeRegistries.ITEMS.getValue(repairMaterial)});
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)ArmorItem.f_40376_);
        this.duration = duration;
        this.resource = new ResourceLocation("divinerpg", "textures/shield/" + name + ".png");
    }

    public DivineShield(ResourceLocation repairMaterial, int damage, String name, int duration) {
        super(new Item.Properties().m_41503_(damage));
        this.repairMaterial = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ForgeRegistries.ITEMS.getValue(repairMaterial)});
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)ArmorItem.f_40376_);
        this.duration = duration;
        this.resource = new ResourceLocation("divinerpg", "textures/shield/" + name + ".png");
    }

    public DivineShield(Rarity rarity, ResourceLocation repairMaterial, int damage, String name, int duration, int color) {
        super(new Item.Properties().m_41503_(damage).m_41497_(rarity));
        this.repairMaterial = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ForgeRegistries.ITEMS.getValue(repairMaterial)});
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)ArmorItem.f_40376_);
        this.duration = duration;
        this.resource = new ResourceLocation("divinerpg", "textures/shield/" + name + ".png");
    }

    public DivineShield(ResourceLocation repairMaterial, int damage, String name, int duration, int color) {
        super(new Item.Properties().m_41503_(damage));
        this.repairMaterial = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ForgeRegistries.ITEMS.getValue(repairMaterial)});
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)ArmorItem.f_40376_);
        this.duration = duration;
        this.resource = new ResourceLocation("divinerpg", "textures/shield/" + name + ".png");
    }

    public boolean m_6832_(ItemStack shield, ItemStack repairItem) {
        if (this.repairMaterial != null) {
            return this.repairMaterial.test(repairItem) || super.m_6832_(shield, repairItem);
        }
        return false;
    }

    public int m_8105_(ItemStack p_43107_) {
        return this.duration * 20;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(RenderProps.INSTANCE);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        tooltip.add(LocalizeUtils.shieldTimeBlock(this.duration));
        tooltip.add(LocalizeUtils.shieldMaxDamage(this.getMaxDamage(stack) / 5));
    }

    static class RenderProps
    implements IClientItemExtensions {
        public static RenderProps INSTANCE = new RenderProps();

        RenderProps() {
        }

        public BlockEntityWithoutLevelRenderer getCustomRenderer() {
            return new DivineShieldRenderer(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_());
        }
    }
}

