/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.base;

import com.idark.valoria.registries.SoundsRegistry;
import divinerpg.capability.ArcanaProvider;
import divinerpg.registries.ItemRegistry;
import divinerpg.registries.SoundRegistry;
import divinerpg.util.LocalizeUtils;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class HealingSwordItem
extends Item {
    public final Builder builder;

    public HealingSwordItem(Builder builder) {
        super(builder.properties);
        this.builder = builder;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        boolean hasEnoughArcana;
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41784_().m_128451_("stackCooldown") > 0 || hand.equals((Object)InteractionHand.OFF_HAND)) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (player.m_6144_() && this.builder.enableRageMode) {
            this.handleRageMode(level, player, stack);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        if (player.m_21223_() >= player.m_21233_()) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (this.isRageModeEnabled(stack) && !(hasEnoughArcana = player.getCapability(ArcanaProvider.ARCANA).map(arcana -> arcana.getAmount(false) >= (float)this.builder.rageArcanaCost).orElse(false).booleanValue())) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (!player.m_7500_()) {
            stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
        }
        if (this.builder.arcanaHeal > 0) {
            player.getCapability(ArcanaProvider.ARCANA).ifPresent(arcana -> arcana.modifyAmount((LivingEntity)player, this.builder.arcanaHeal));
        }
        if (this.builder.extinguishFire && player.m_6060_()) {
            player.m_20095_();
            level.m_5594_(null, player.m_20183_(), SoundEvents.f_12031_, SoundSource.PLAYERS, 1.0f, 1.0f);
            if (level instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)level;
                server.m_8767_((ParticleOptions)ParticleTypes.f_123759_, player.m_20185_(), player.m_20186_(), player.m_20189_(), 25, 0.2, 0.2, 0.2, 0.01);
            }
        }
        if (this.builder.aoeDamage > 0.0f) {
            List targets = level.m_6249_((Entity)player, player.m_20191_().m_82400_(this.builder.aoeRange), e -> e instanceof LivingEntity && e != player);
            targets.forEach(e -> e.m_6469_(level.m_269111_().m_269075_(player), this.builder.aoeDamage));
        }
        if (this.isRageModeEnabled(stack)) {
            player.getCapability(ArcanaProvider.ARCANA).ifPresent(arcana -> arcana.consume(player, this.builder.rageArcanaCost));
        }
        this.performHeal(player, level);
        this.applySmartCooldown(player, stack);
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    private void handleRageMode(Level level, Player player, ItemStack stack) {
        if (this.isRageModeEnabled(stack) && !this.builder.rageInfinite) {
            return;
        }
        HealingSwordItem.setRageMode(stack, !this.isRageModeEnabled(stack));
        level.m_5594_(null, player.m_20183_(), this.builder.rageSound, SoundSource.PLAYERS, 1.0f, 1.0f);
        if (this.isRageModeEnabled(stack) && !this.builder.rageInfinite && this.builder.rageDuration > 0) {
            stack.m_41784_().m_128405_("rageTicksLeft", this.builder.rageDuration * 20);
        } else {
            stack.m_41784_().m_128473_("rageTicksLeft");
        }
    }

    public void m_6883_(@NotNull ItemStack stack, Level level, @NotNull Entity entity, int slot, boolean isSelected) {
        int scd;
        if (!level.f_46443_ && (scd = stack.m_41784_().m_128451_("stackCooldown")) > 0) {
            stack.m_41784_().m_128405_("stackCooldown", scd - 1);
        }
        if (!level.f_46443_ && this.isRageModeEnabled(stack) && !this.builder.rageInfinite) {
            int ticksLeft = stack.m_41784_().m_128451_("rageTicksLeft");
            if (ticksLeft <= 0) {
                HealingSwordItem.setRageMode(stack, false);
                stack.m_41784_().m_128473_("rageTicksLeft");
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    level.m_5594_(null, player.m_20183_(), (SoundEvent)SoundsRegistry.RECHARGE.get(), SoundSource.PLAYERS, 0.55f, 1.0f);
                }
            } else {
                stack.m_41784_().m_128405_("rageTicksLeft", ticksLeft - 1);
            }
        }
        super.m_6883_(stack, level, entity, slot, isSelected);
    }

    private void performHeal(Player player, Level level) {
        player.m_5634_(this.builder.healAmount);
        level.m_5594_(null, player.m_20183_(), (SoundEvent)SoundRegistry.HEAL.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        if (this.builder.healEffect != null) {
            MobEffectInstance eff = this.builder.healEffect;
            player.m_7292_(new MobEffectInstance(eff.m_19544_(), eff.m_19557_(), eff.m_19564_(), eff.m_19571_(), eff.m_19572_(), eff.m_19575_()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isRageMode(ItemStack stack) {
        Item item = stack.m_41720_();
        if (!(item instanceof HealingSwordItem)) return false;
        HealingSwordItem sword = (HealingSwordItem)item;
        if (!sword.builder.enableRageMode) return false;
        if (!stack.m_41784_().m_128471_("rageMode")) return false;
        return true;
    }

    public static void setRageMode(ItemStack stack, boolean value) {
        stack.m_41784_().m_128379_("rageMode", value);
    }

    public boolean isRageModeEnabled(ItemStack stack) {
        return this.builder.enableRageMode && HealingSwordItem.isRageMode(stack);
    }

    private void applySmartCooldown(Player player, ItemStack usedStack) {
        List<Item> healingSwords = Arrays.asList((Item)ItemRegistry.palavence.get(), (Item)ItemRegistry.massivence.get(), (Item)ItemRegistry.halite_massivence.get(), (Item)ItemRegistry.frossivence.get(), (Item)ItemRegistry.pativence.get(), (Item)ItemRegistry.illusivence.get());
        if (this.isRageModeEnabled(usedStack)) {
            usedStack.m_41784_().m_128405_("stackCooldown", 3);
            for (ItemStack stackInInventory : player.m_150109_().f_35974_) {
                if (stackInInventory.m_41619_() || stackInInventory == usedStack || !healingSwords.contains(stackInInventory.m_41720_())) continue;
                stackInInventory.m_41784_().m_128405_("stackCooldown", this.builder.cooldownTicks);
            }
        } else {
            healingSwords.forEach(item -> player.m_36335_().m_41524_(item, this.builder.cooldownTicks));
        }
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level world, List<Component> tooltip, @NotNull TooltipFlag flag) {
        tooltip.add((Component)Component.m_237110_((String)"tooltip.heals", (Object[])new Object[]{Float.valueOf(this.builder.healAmount / 2.0f)}).m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237110_((String)"tooltip.healing_sword.cooldown", (Object[])new Object[]{Float.valueOf((float)this.builder.cooldownTicks / 20.0f)}).m_130940_(ChatFormatting.GRAY));
        if (this.builder.healEffect != null) {
            MobEffectInstance eff = this.builder.healEffect;
            String name = Component.m_237115_((String)eff.m_19576_()).getString();
            int level = eff.m_19564_() + 1;
            float durationSeconds = (float)eff.m_19557_() / 20.0f;
            tooltip.add((Component)Component.m_237113_((String)"\u041d\u0430\u043a\u043b\u0430\u0434\u044b\u0432\u0430\u0435\u0442 ").m_130946_(name + " " + LocalizeUtils.romanNumerals(level) + " \u043d\u0430 " + durationSeconds + " \u0441\u0435\u043a.").m_130940_(ChatFormatting.GRAY));
        }
        if (this.builder.arcanaHeal > 0) {
            tooltip.add(LocalizeUtils.arcanaRegen(this.builder.arcanaHeal));
        }
        if (this.builder.extinguishFire) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.healing_sword.extinguish").m_130940_(ChatFormatting.GRAY));
        }
        if (this.builder.aoeDamage > 0.0f) {
            tooltip.add((Component)Component.m_237110_((String)"tooltip.healing_sword.aoe", (Object[])new Object[]{Float.valueOf(this.builder.aoeDamage), this.builder.aoeRange / 2.0}).m_130940_(ChatFormatting.GRAY));
        }
        if (this.builder.enableRageMode) {
            tooltip.add((Component)Component.m_237119_());
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ragemode.title").m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ragemode.description").m_130940_(ChatFormatting.GRAY));
            if (this.builder.rageInfinite) {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.ragemode.time.infinite").m_130940_(ChatFormatting.GRAY));
            } else {
                tooltip.add((Component)Component.m_237110_((String)"tooltip.ragemode.time", (Object[])new Object[]{this.builder.rageDuration}).m_130940_(ChatFormatting.GRAY));
            }
            tooltip.add(LocalizeUtils.arcanaConsumed(this.builder.rageArcanaCost));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ragemode.activation").m_130940_(ChatFormatting.GRAY));
            if (this.builder.rageInfinite) {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.ragemode.deactivation").m_130940_(ChatFormatting.GRAY));
            }
        }
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchant) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean m_8120_(@NotNull ItemStack stack) {
        return false;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public Builder getBuilder() {
        return this.builder;
    }

    public static class Builder {
        private final Item.Properties properties;
        private final Tier tier;
        private float healAmount = 4.0f;
        private int arcanaHeal = 0;
        @Nullable
        private MobEffectInstance healEffect = null;
        private boolean extinguishFire = false;
        private boolean enableRageMode = false;
        private int rageDuration = 0;
        private int rageArcanaCost = 0;
        private boolean rageInfinite = false;
        private float aoeDamage = 0.0f;
        private double aoeRange = 0.0;
        private int cooldownTicks = 20;
        private SoundEvent rageSound = (SoundEvent)SoundsRegistry.BLOODHOUND_ABILITY_LEGACY.get();

        public int getCooldownTicks() {
            return this.cooldownTicks;
        }

        public Builder(Tier tier, Item.Properties properties) {
            this.tier = tier;
            this.properties = properties.m_41503_(tier.m_6609_()).m_41486_();
        }

        public Builder heal(float amount) {
            this.healAmount = amount;
            return this;
        }

        public Builder arcana(int amount) {
            this.arcanaHeal = amount;
            return this;
        }

        public Builder healEffect(MobEffectInstance effect) {
            this.healEffect = effect;
            return this;
        }

        public Builder extinguish() {
            this.extinguishFire = true;
            return this;
        }

        public Builder rageMode(int durationSeconds, int arcanaCost, SoundEvent sound) {
            this.enableRageMode = true;
            this.rageDuration = durationSeconds;
            this.rageArcanaCost = arcanaCost;
            this.rageSound = sound;
            return this;
        }

        public Builder rageMode(int durationSeconds, int arcanaCost) {
            return this.rageMode(durationSeconds, arcanaCost, this.rageSound);
        }

        public Builder rageInfinite(int arcanaCost, SoundEvent sound) {
            this.enableRageMode = true;
            this.rageInfinite = true;
            this.rageArcanaCost = arcanaCost;
            this.rageSound = sound;
            return this;
        }

        public Builder rageInfinite(int arcanaCost) {
            return this.rageInfinite(arcanaCost, this.rageSound);
        }

        public Builder aoe(float damage, double range) {
            this.aoeDamage = damage;
            this.aoeRange = range;
            return this;
        }

        public Builder cooldown(int ticks) {
            this.cooldownTicks = ticks;
            return this;
        }

        public Builder rarity(Rarity rarity) {
            this.properties.m_41497_(rarity);
            return this;
        }

        public HealingSwordItem build() {
            return new HealingSwordItem(this);
        }
    }
}

