/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.base;

import divinerpg.items.base.ItemMod;
import divinerpg.registries.EntityRegistry;
import divinerpg.registries.ItemRegistry;
import divinerpg.registries.LevelRegistry;
import divinerpg.registries.SoundRegistry;
import divinerpg.util.LocalizeUtils;
import divinerpg.util.RarityList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.server.command.TextComponentHelper;
import org.jetbrains.annotations.NotNull;

public class ItemBossSpawner
extends ItemMod {
    private final Supplier<EntityType<?>> ent;
    private final String langKey;
    private ResourceKey<Level> dimensionID;

    public ItemBossSpawner(String langKey, ResourceKey<Level> dimensionID, Supplier<EntityType<?>> ent) {
        super(new Item.Properties().m_41487_(1).m_41497_(RarityList.BOSS));
        this.dimensionID = dimensionID;
        this.ent = ent;
        this.langKey = langKey;
    }

    public ItemBossSpawner(String key, ResourceKey<Level> dimension) {
        super(new Item.Properties().m_41487_(1).m_41497_(RarityList.BOSS));
        this.dimensionID = dimension;
        this.langKey = key;
        this.ent = null;
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        Level world = context.m_43725_();
        Direction direction = context.m_43719_();
        BlockPos pos = context.m_8083_();
        BlockState blockstate = world.m_8055_(pos);
        BlockPos pos1 = blockstate.m_60812_((BlockGetter)world, pos).m_83281_() ? pos : pos.m_121945_(direction);
        Player player = context.m_43723_();
        ItemStack stack = context.m_43722_();
        if (stack.m_41720_().equals(ItemRegistry.horde_horn.get()) || world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (this.dimensionID == null) {
            this.dimensionID = LevelRegistry.MORTUM;
        }
        if (world.m_46472_() != this.dimensionID) {
            if (player != null) {
                player.m_5661_((Component)TextComponentHelper.createComponentTranslation((CommandSource)player, (String)this.langKey, (Object[])new Object[0]).m_130940_(ChatFormatting.AQUA), true);
            }
            return InteractionResult.FAIL;
        }
        if (world.m_46791_() == Difficulty.PEACEFUL) {
            if (player != null) {
                player.m_5661_((Component)Component.m_237115_((String)"message.spawner.peaceful"), true);
            }
            return InteractionResult.FAIL;
        }
        EntityType<?> entity = this.ent.get();
        if (!this.canSpawnHere(world, entity, player)) {
            if (player != null) {
                player.m_5661_((Component)TextComponentHelper.createComponentTranslation((CommandSource)player, (String)"\u0411\u043e\u0441\u0441\u0443 \u043d\u0435 \u0445\u0432\u0430\u0442\u0430\u0435\u0442 \u043c\u0435\u0441\u0442\u0430 \u0434\u043b\u044f \u043f\u0440\u0438\u0437\u044b\u0432\u0430!", (Object[])new Object[0]).m_130940_(ChatFormatting.RED), true);
            }
            return InteractionResult.FAIL;
        }
        entity.m_20592_((ServerLevel)world, stack, player, pos1, MobSpawnType.MOB_SUMMONED, true, false);
        AABB boundingBox = new AABB((double)(pos.m_123341_() - 32), (double)(pos.m_123342_() - 32), (double)(pos.m_123343_() - 32), (double)(pos.m_123341_() + 32), (double)(pos.m_123342_() + 32), (double)(pos.m_123343_() + 32));
        List entities = world.m_45976_(ServerPlayer.class, boundingBox);
        ChatFormatting bossColor = null;
        SoundEvent spawnSound = null;
        if (entity == EntityRegistry.ANCIENT_ENTITY.get()) {
            spawnSound = (SoundEvent)SoundRegistry.BOSS_SPAWN_1.get();
            bossColor = ChatFormatting.YELLOW;
        } else if (entity == EntityRegistry.THE_WATCHER.get() || entity == EntityRegistry.TWILIGHT_DEMON.get()) {
            spawnSound = (SoundEvent)SoundRegistry.BOSS_SPAWN_4.get();
            bossColor = ChatFormatting.RED;
        } else if (entity == EntityRegistry.KING_OF_SCORCHERS.get() || entity == EntityRegistry.RAGLOK.get()) {
            spawnSound = (SoundEvent)SoundRegistry.BOSS_SPAWN_6.get();
            bossColor = ChatFormatting.RED;
        } else if (entity == EntityRegistry.LADY_LUNA.get()) {
            spawnSound = (SoundEvent)SoundRegistry.BOSS_SPAWN_9.get();
            bossColor = ChatFormatting.AQUA;
        } else if (entity == EntityRegistry.VAMACHERON.get()) {
            spawnSound = (SoundEvent)SoundRegistry.BOSS_SPAWN_7.get();
            bossColor = ChatFormatting.DARK_GREEN;
        } else if (entity == EntityRegistry.REYVOR.get()) {
            spawnSound = (SoundEvent)SoundRegistry.BOSS_SPAWN_8.get();
            bossColor = ChatFormatting.YELLOW;
        } else if (entity == EntityRegistry.DENSOS.get()) {
            spawnSound = (SoundEvent)SoundRegistry.BOSS_SPAWN_8.get();
            bossColor = ChatFormatting.DARK_PURPLE;
        } else if (entity == EntityRegistry.SOUL_FIEND.get()) {
            spawnSound = (SoundEvent)SoundRegistry.BOSS_SPAWN_9.get();
            bossColor = ChatFormatting.DARK_RED;
        } else if (entity == EntityRegistry.KAROT.get()) {
            spawnSound = (SoundEvent)SoundRegistry.BOSS_SPAWN_2.get();
            bossColor = ChatFormatting.DARK_RED;
        }
        if (spawnSound != null) {
            world.m_5594_(null, pos1, spawnSound, SoundSource.HOSTILE, 2.0f, 1.0f);
        }
        if (bossColor != null) {
            for (ServerPlayer p : entities) {
                p.f_8906_.m_9829_((Packet)new ClientboundSetTitleTextPacket((Component)entity.m_20676_().m_6881_().m_130940_(bossColor)));
            }
        }
        if (!player.m_7500_()) {
            stack.m_41774_(1);
        }
        return InteractionResult.SUCCESS;
    }

    public boolean canSpawnHere(Level world, EntityType<?> entityType, Player player) {
        Entity mob = entityType.m_20615_(world);
        if (mob != null) {
            AABB blockAABB = ItemBossSpawner.getAABB(player, mob);
            for (BlockPos pos : BlockPos.m_121940_((BlockPos)new BlockPos((int)blockAABB.f_82288_, (int)blockAABB.f_82289_, (int)blockAABB.f_82290_), (BlockPos)new BlockPos((int)blockAABB.f_82291_, (int)blockAABB.f_82292_, (int)blockAABB.f_82293_))) {
                BlockState blockState = world.m_8055_(pos);
                if (blockState.m_60812_((BlockGetter)world, pos).m_83281_()) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    private static AABB getAABB(Player player, Entity mob) {
        AABB boundingBox = mob.m_20191_();
        double height = 0.1;
        Vec3 origin = player.m_146892_();
        Vec3 direction = player.m_20156_();
        BlockHitResult hit = player.m_9236_().m_45547_(new ClipContext(origin, origin.m_82549_(direction.m_82490_(5.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.ANY, (Entity)player));
        BlockPos spawnPos = new BlockPos(hit.m_82425_().m_123341_(), hit.m_82425_().m_123342_() + 1, hit.m_82425_().m_123343_());
        double minX = (double)spawnPos.m_123341_() + boundingBox.f_82288_;
        double minY = spawnPos.m_123342_();
        double minZ = (double)spawnPos.m_123343_() + boundingBox.f_82290_;
        double maxX = (double)spawnPos.m_123341_() + boundingBox.f_82291_;
        double maxY = (double)spawnPos.m_123342_() + boundingBox.f_82292_ - height;
        double maxZ = (double)spawnPos.m_123343_() + boundingBox.f_82293_;
        return new AABB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (stack.m_41720_().equals(ItemRegistry.horde_horn.get())) {
            tooltip.add(LocalizeUtils.summonBoss(((EntityType)EntityRegistry.AYERACO.get()).m_204041_()));
        }
        if (this.ent != null) {
            tooltip.add(LocalizeUtils.summonBoss(this.ent));
        }
    }
}

