/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.base;

import divinerpg.capability.Arcana;
import divinerpg.capability.ArcanaProvider;
import divinerpg.entities.projectile.EntityColoredBullet;
import divinerpg.entities.projectile.EntityParticleBullet;
import divinerpg.entities.projectile.EntityShooterBullet;
import divinerpg.enums.BulletType;
import divinerpg.items.base.ItemMod;
import divinerpg.registries.EntityRegistry;
import divinerpg.util.LocalizeUtils;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemModRanged
extends ItemMod {
    protected final String entityType;
    private final Supplier<SoundEvent> sound;
    private final SoundSource soundCategory;
    private final int delay;
    private final ResourceLocation ammoSupplier;
    private int arcanaConsuming;
    protected BulletType bulletType;

    public ItemModRanged(Rarity rarity, String entityType, BulletType bulletType, Supplier<SoundEvent> sound, SoundSource soundCategory, int maxDamage, int delay, ResourceLocation ammoSupplier, int arcanaConsuming) {
        super(new Item.Properties().m_41503_(maxDamage).m_41497_(rarity));
        this.entityType = entityType;
        this.sound = sound;
        this.soundCategory = soundCategory;
        this.delay = delay;
        this.ammoSupplier = ammoSupplier == null ? null : ammoSupplier;
        this.arcanaConsuming = arcanaConsuming;
        this.bulletType = bulletType;
    }

    public ItemModRanged(String entityType, BulletType bulletType, Supplier<SoundEvent> sound, SoundSource soundCategory, int maxDamage, int delay, ResourceLocation ammoSupplier, int arcanaConsuming) {
        super(new Item.Properties().m_41503_(maxDamage));
        this.entityType = entityType;
        this.sound = sound;
        this.soundCategory = soundCategory;
        this.delay = delay;
        this.ammoSupplier = ammoSupplier == null ? null : ammoSupplier;
        this.arcanaConsuming = arcanaConsuming;
        this.bulletType = bulletType;
    }

    public ItemModRanged(BulletType bulletType, Supplier<SoundEvent> shotSound, ResourceLocation ammoSupplier, int maxDamange, int counter) {
        this(null, bulletType, shotSound, SoundSource.MASTER, maxDamange, counter, ammoSupplier, 0);
    }

    public ItemModRanged(BulletType bulletType, Supplier<SoundEvent> shotSound, int uses, int counter) {
        this(bulletType, shotSound, null, uses, counter);
    }

    public ItemModRanged(Rarity rarity, BulletType bulletType, Supplier<SoundEvent> shotSound, ResourceLocation ammoSupplier, int maxDamange, int counter) {
        this(rarity, null, bulletType, shotSound, SoundSource.MASTER, maxDamange, counter, ammoSupplier, 0);
    }

    public ItemModRanged(Rarity rarity, BulletType bulletType, Supplier<SoundEvent> shotSound, int uses, int counter) {
        this(rarity, bulletType, shotSound, null, uses, counter);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (this.bulletType != null) {
            tooltip.add(LocalizeUtils.rangedDam(this.bulletType.getDamage()));
        }
        if (!this.needsAmmo()) {
            tooltip.add(LocalizeUtils.i18n("tooltip.ammo.infinite", new Object[0]));
        } else {
            ItemStack ammo = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(this.ammoSupplier));
            tooltip.add(LocalizeUtils.ammo(this.getAmmo(), ammo != null));
        }
        tooltip.add(stack.m_41776_() == -1 ? LocalizeUtils.infiniteUses() : LocalizeUtils.usesRemaining(stack.m_41776_() - stack.m_41773_()));
        if (this.arcanaConsuming > 0) {
            tooltip.add(LocalizeUtils.arcanaConsumed(this.arcanaConsuming));
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        InteractionResult result = InteractionResult.FAIL;
        if (this.canUseRangedWeapon(player, stack)) {
            InteractionResultHolder<ItemStack> ammo = this.tryFindAmmo(player);
            InteractionResultHolder<Arcana> checkArcana = this.tryCheckArcana(player);
            if (ammo.m_19089_() == InteractionResult.SUCCESS && checkArcana.m_19089_() == InteractionResult.SUCCESS) {
                ItemStack ammoStack;
                Arcana arcana;
                this.doPreUsageEffects(world, player);
                if (!world.f_46443_) {
                    world.m_5594_(null, player.m_20183_(), this.sound.get() != null ? this.sound.get() : SoundEvents.f_11687_, this.soundCategory != null ? this.soundCategory : SoundSource.MASTER, 1.0f, 1.0f);
                    this.spawnEntity(world, player, stack, this.bulletType, this.entityType);
                }
                if ((arcana = (Arcana)checkArcana.m_19095_()) != null) {
                    arcana.consume(player, this.arcanaConsuming);
                }
                if ((ammoStack = (ItemStack)ammo.m_19095_()) != null) {
                    ammoStack.m_41774_(1);
                }
                if (!player.m_7500_()) {
                    stack.m_41622_(1, (LivingEntity)player, p_220009_1_ -> p_220009_1_.m_21190_(player.m_7655_()));
                }
                player.m_36335_().m_41524_(stack.m_41720_(), this.delay * 4 + 1);
                this.doPostUsageEffects(world, player);
            }
        }
        return new InteractionResultHolder(result, (Object)stack);
    }

    private Item getAmmo() {
        if (ForgeRegistries.ITEMS.getValue(this.ammoSupplier) != Items.f_41852_) {
            return (Item)ForgeRegistries.ITEMS.getValue(this.ammoSupplier);
        }
        return null;
    }

    private boolean needsAmmo() {
        return ForgeRegistries.ITEMS.getValue(this.ammoSupplier) != Items.f_41852_;
    }

    private boolean isAmmo(@Nullable ItemStack stack) {
        return stack != null && stack.m_41720_() == this.getAmmo();
    }

    private ItemStack findAmmo(Player player) {
        if (this.isAmmo(player.m_21120_(InteractionHand.OFF_HAND))) {
            return player.m_21120_(InteractionHand.OFF_HAND);
        }
        if (this.isAmmo(player.m_21120_(InteractionHand.MAIN_HAND))) {
            return player.m_21120_(InteractionHand.MAIN_HAND);
        }
        for (int i = 0; i < player.f_36093_.m_6643_(); ++i) {
            ItemStack itemstack = player.f_36093_.m_8020_(i);
            if (!this.isAmmo(itemstack)) continue;
            return itemstack;
        }
        return null;
    }

    protected InteractionResultHolder<ItemStack> tryFindAmmo(Player player) {
        ItemStack stack = null;
        InteractionResult result = InteractionResult.SUCCESS;
        if (!player.m_7500_() && this.needsAmmo() && ((stack = this.findAmmo(player)) == null || stack.m_41613_() < 1)) {
            result = InteractionResult.FAIL;
        }
        return new InteractionResultHolder(result, stack);
    }

    protected InteractionResultHolder<Arcana> tryCheckArcana(Player player) {
        Arcana arcana = null;
        InteractionResult result = InteractionResult.SUCCESS;
        if (!player.m_7500_() && this.arcanaConsuming > 0 && ((arcana = (Arcana)player.getCapability(ArcanaProvider.ARCANA).orElseThrow(RuntimeException::new)) == null || arcana.getAmount(false) < (float)this.arcanaConsuming)) {
            result = InteractionResult.FAIL;
        }
        return new InteractionResultHolder(result, arcana);
    }

    protected boolean canUseRangedWeapon(Player player, ItemStack stack) {
        return player.m_7500_() || stack.m_41776_() <= 0 || stack.m_41773_() < stack.m_41776_();
    }

    protected void spawnEntity(Level world, Player player, ItemStack stack, BulletType bulletType, String entityType) {
        ThrowableProjectile bullet;
        if (entityType != null) {
            try {
                bullet = (ThrowableProjectile)((EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation("divinerpg", entityType))).m_20615_(world);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e.getMessage());
            }
        } else {
            bullet = bulletType.getParticle() != ParticleTypes.f_123795_ ? new EntityParticleBullet((EntityType<? extends ThrowableProjectile>)((EntityType)EntityRegistry.PARTICLE_BULLET.get()), world, (LivingEntity)player, bulletType) : (bulletType.getRed() != 0 && bulletType.getGreen() != 0 && bulletType.getBlue() != 0 ? new EntityColoredBullet((EntityType<? extends ThrowableProjectile>)((EntityType)EntityRegistry.COLORED_BULLET.get()), (LivingEntity)player, world, bulletType) : new EntityShooterBullet((EntityType<? extends ThrowableProjectile>)((EntityType)EntityRegistry.SHOOTER_BULLET.get()), (LivingEntity)player, world, bulletType));
        }
        assert (bullet != null);
        bullet.m_6027_(player.f_19854_, player.m_20188_(), player.f_19856_);
        bullet.m_5602_((Entity)player);
        bullet.m_37251_((Entity)player, player.f_19858_, player.f_19857_, 0.0f, 1.5f, 0.5f);
        world.m_7967_((Entity)bullet);
    }

    protected void doPreUsageEffects(Level world, Player player) {
    }

    protected void doPostUsageEffects(Level world, Player player) {
    }
}

