/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.base;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import divinerpg.util.LocalizeUtils;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemModSword
extends SwordItem {
    public ItemModSword(Rarity rarity, Tier tier) {
        super(tier, 1, 1.0f, new Item.Properties().m_41497_(rarity));
    }

    public ItemModSword(Tier tier) {
        super(tier, 1, 1.0f, new Item.Properties());
    }

    public ItemModSword(Tier tier, Item.Properties properties) {
        super(tier, 1, 1.0f, properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        this.addAdditionalInformation(tooltip);
        if (stack.m_41776_() == -1) {
            tooltip.add(LocalizeUtils.infiniteUses());
        }
    }

    protected void addAdditionalInformation(List<Component> list) {
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        ArrayListMultimap modifiers = ArrayListMultimap.create((Multimap)super.getAttributeModifiers(slot, stack));
        if (slot == EquipmentSlot.MAINHAND) {
            this.replaceModifier((Multimap<Attribute, AttributeModifier>)modifiers, Attributes.f_22283_, f_41375_, this.m_43314_().m_6624_());
        }
        return ImmutableMultimap.copyOf((Multimap)modifiers);
    }

    private void replaceModifier(Multimap<Attribute, AttributeModifier> modifierMultimap, Attribute attribute, UUID id, double multiplier) {
        Collection modifiers = modifierMultimap.get((Object)attribute);
        Optional<AttributeModifier> modifierOptional = modifiers.stream().filter(attributeModifier -> attributeModifier.m_22209_().equals(id)).findFirst();
        modifierOptional.ifPresent(modifier -> {
            modifiers.remove(modifier);
            modifiers.add(new AttributeModifier(modifier.m_22209_(), modifier.m_22214_(), modifier.m_22218_() * multiplier, modifier.m_22217_()));
        });
    }
}

