/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.base;

import divinerpg.items.base.ItemMod;
import divinerpg.registries.MobEffectRegistry;
import divinerpg.util.LocalizeUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public abstract class ItemScepterBase
extends ItemMod {
    private static final List<ItemScepterBase> ALL_SCEPTERS = new ArrayList<ItemScepterBase>();
    private BlockPos prev;

    public ItemScepterBase(Rarity rarity) {
        super(new Item.Properties().m_41487_(1).m_41497_(rarity));
        ALL_SCEPTERS.add(this);
    }

    protected abstract int getTeleportDistance();

    protected abstract int getCooldown();

    protected abstract SimpleParticleType getParticleType();

    protected abstract int getChargeTime();

    protected abstract void applyTeleportEffect(ServerPlayer var1, Level var2, BlockHitResult var3);

    protected BlockPos getTeleportPosition(BlockHitResult hitResult) {
        return hitResult.m_82425_().m_121945_(hitResult.m_82434_());
    }

    protected abstract void addExtraTooltips(List<Component> var1);

    public int m_8105_(@NotNull ItemStack stack) {
        return this.getChargeTime() + 1;
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack stack) {
        return UseAnim.BOW;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level world, Player player, @NotNull InteractionHand hand) {
        this.prev = player.m_20183_();
        player.m_6672_(hand);
        return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
    }

    public void m_5929_(@NotNull Level level, @NotNull LivingEntity entityLiving, @NotNull ItemStack stack, int count) {
        if (!(entityLiving instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entityLiving;
        if (player.m_21023_((MobEffect)MobEffectRegistry.CHAINED.get())) {
            player.m_5810_();
            return;
        }
        int ticksUsed = this.m_8105_(stack) - count;
        if (ticksUsed >= this.getChargeTime()) {
            Vec3 eyePos = player.m_20299_(1.0f);
            Vec3 viewVector = player.m_20252_(1.0f);
            Vec3 targetPos = eyePos.m_82549_(viewVector.m_82490_((double)this.getTeleportDistance()));
            BlockHitResult hitResult = player.m_9236_().m_45547_(new ClipContext(eyePos, targetPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
            BlockPos teleportPos = this.getTeleportPosition(hitResult);
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11757_, player.m_5720_(), 1.0f, 1.25f);
            ItemScepterBase.spawnParticlesLine(level, (Player)player, this.getParticleType(), this.prev, hitResult.m_82450_());
            if (!level.m_5776_()) {
                player.m_6021_((double)teleportPos.m_123341_() + 0.5, (double)teleportPos.m_123342_(), (double)teleportPos.m_123343_() + 0.5);
            }
            player.m_183634_();
            player.m_20153_();
            this.applyTeleportEffect(player, level, hitResult);
            player.m_21011_(InteractionHand.MAIN_HAND, true);
            player.m_21253_();
            for (ItemScepterBase scepter : ALL_SCEPTERS) {
                player.m_36335_().m_41524_((Item)scepter, scepter.getCooldown());
            }
            level.m_6263_(null, (double)teleportPos.m_123341_(), (double)teleportPos.m_123342_(), (double)teleportPos.m_123343_(), SoundEvents.f_11757_, player.m_5720_(), 1.0f, 1.25f);
        }
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add(LocalizeUtils.i18n("tooltip.ender_scepter", new Object[0]));
        this.addExtraTooltips(tooltip);
        tooltip.add(LocalizeUtils.infiniteUses());
    }

    public static void spawnParticlesLine(Level pLevel, Player player, SimpleParticleType pType, BlockPos startPos, Vec3 end) {
        if (pLevel instanceof ServerLevel) {
            ServerLevel pServer = (ServerLevel)pLevel;
            Vec3 start = player.m_146892_();
            double distance = start.m_82554_(end);
            int steps = (int)(distance * 4.0);
            for (int i = 0; i < steps; ++i) {
                double ratio = (double)i / (double)steps;
                double x = start.f_82479_ + (end.f_82479_ - start.f_82479_) * ratio;
                double y = start.f_82480_ + (end.f_82480_ - start.f_82480_) * ratio;
                double z = start.f_82481_ + (end.f_82481_ - start.f_82481_) * ratio;
                pServer.m_8767_((ParticleOptions)pType, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }
}

