/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.base;

import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import divinerpg.util.LocalizeUtils;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;

public class ItemShickaxe
extends DiggerItem {
    protected final Tier tier;
    private static final Set<ToolAction> TOOL_ACTIONS = Stream.of(ToolActions.AXE_DIG, ToolActions.PICKAXE_DIG, ToolActions.SHOVEL_DIG, ToolActions.HOE_DIG).collect(Collectors.toCollection(Sets::newIdentityHashSet));

    public ItemShickaxe(Rarity rarity, Tier tier) {
        super(1.0f, -2.4f, tier, BlockTags.create((ResourceLocation)new ResourceLocation("divinerpg", "shickaxe_effective")), new Item.Properties().m_41503_(tier.m_6609_()).m_41497_(rarity));
        this.tier = tier;
    }

    public ItemShickaxe(Tier tier) {
        super(1.0f, -2.4f, tier, BlockTags.create((ResourceLocation)new ResourceLocation("divinerpg", "shickaxe_effective")), new Item.Properties().m_41503_(tier.m_6609_()));
        this.tier = tier;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add(LocalizeUtils.efficiency(this.f_40980_));
        tooltip.add(LocalizeUtils.harvestLevel(this.m_43314_().m_6604_()));
        if (this.getMaxDamage(stack) == -1) {
            tooltip.add(LocalizeUtils.infiniteUses());
        }
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.m_41622_(1, attacker, context -> context.m_21190_(attacker.m_7655_()));
        return true;
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return TOOL_ACTIONS.contains(toolAction);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Pair pair;
        BlockPos blockpos;
        Level level = context.m_43725_();
        BlockState toolModifiedState = level.m_8055_(blockpos = context.m_8083_()).getToolModifiedState(new UseOnContext(context.m_43725_(), context.m_43723_(), context.m_43724_(), new ItemStack((ItemLike)Items.f_42392_), new BlockHitResult(context.m_43720_(), context.m_43719_(), context.m_8083_(), context.m_43721_())), ToolActions.HOE_TILL, false);
        Pair pair2 = pair = toolModifiedState == null ? null : Pair.of(ctx -> true, (Object)HoeItem.m_150858_((BlockState)toolModifiedState));
        if (pair != null) {
            Predicate predicate = (Predicate)pair.getFirst();
            Consumer consumer = (Consumer)pair.getSecond();
            if (predicate.test(context)) {
                Player player = context.m_43723_();
                level.m_5594_(player, blockpos, SoundEvents.f_11955_, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!level.f_46443_) {
                    consumer.accept(context);
                    if (player != null) {
                        context.m_43722_().m_41622_(1, (LivingEntity)player, p_150845_ -> p_150845_.m_21190_(context.m_43724_()));
                    }
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        if (state.m_204336_(BlockTags.f_144280_)) {
            return this.f_40980_;
        }
        if (state.m_204336_(BlockTags.f_144282_)) {
            return this.f_40980_;
        }
        if (state.m_204336_(BlockTags.f_144283_)) {
            return this.f_40980_;
        }
        if (state.m_204336_(BlockTags.f_144281_)) {
            return this.f_40980_;
        }
        return super.m_8102_(stack, state);
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        if (state.m_204336_(BlockTags.f_144282_)) {
            return TierSortingRegistry.isCorrectTierForDrops((Tier)this.tier, (BlockState)state);
        }
        if (state.m_204336_(BlockTags.f_144280_)) {
            return TierSortingRegistry.isCorrectTierForDrops((Tier)this.tier, (BlockState)state);
        }
        if (state.m_204336_(BlockTags.f_144283_)) {
            return TierSortingRegistry.isCorrectTierForDrops((Tier)this.tier, (BlockState)state);
        }
        if (state.m_204336_(BlockTags.f_144281_)) {
            return TierSortingRegistry.isCorrectTierForDrops((Tier)this.tier, (BlockState)state);
        }
        return false;
    }
}

