/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.base;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KillEffectSwordItem
extends SwordItem {
    private final boolean playerOnly;
    public final ImmutableList<MobEffectInstance> effects;

    public KillEffectSwordItem(Tier pTier, int pAttackDamageIn, float pAttackSpeedIn, Item.Properties pProperties, boolean pPlayerOnly, MobEffectInstance ... pEffects) {
        super(pTier, pAttackDamageIn, pAttackSpeedIn, pProperties);
        this.playerOnly = pPlayerOnly;
        this.effects = ImmutableList.copyOf((Object[])pEffects);
    }

    public KillEffectSwordItem(Tier pTier, int pAttackDamageIn, float pAttackSpeedIn, Item.Properties pProperties, MobEffectInstance ... pEffects) {
        this(pTier, pAttackDamageIn, pAttackSpeedIn, pProperties, false, pEffects);
    }

    public boolean isPlayerOnly() {
        return this.playerOnly;
    }

    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        MutableComponent triggerHeader = this.playerOnly ? Component.m_237113_((String)"\u041f\u0440\u0438 \u0443\u0431\u0438\u0439\u0441\u0442\u0432\u0435 \u0438\u0433\u0440\u043e\u043a\u0430:").m_130940_(ChatFormatting.GRAY) : Component.m_237113_((String)"\u041f\u0440\u0438 \u0443\u0431\u0438\u0439\u0441\u0442\u0432\u0435 \u043c\u043e\u0431\u0430:").m_130940_(ChatFormatting.GRAY);
        pTooltipComponents.add((Component)triggerHeader);
        for (MobEffectInstance effectInstance : this.effects) {
            MutableComponent mutablecomponent = Component.m_237115_((String)effectInstance.m_19576_());
            if (effectInstance.m_19564_() > 0) {
                mutablecomponent = Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{mutablecomponent, Component.m_237115_((String)("potion.potency." + effectInstance.m_19564_()))});
            }
            mutablecomponent = Component.m_237110_((String)"potion.withDuration", (Object[])new Object[]{mutablecomponent, MobEffectUtil.m_267641_((MobEffectInstance)effectInstance, (float)1.0f)});
            pTooltipComponents.add((Component)Component.m_237113_((String)"  \u2022 ").m_130940_(ChatFormatting.BLUE).m_7220_((Component)mutablecomponent.m_130940_(effectInstance.m_19544_().m_19483_().m_19497_())));
        }
    }
}

