/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.base.trap;

import divinerpg.DivineRPG;
import divinerpg.items.base.trap.TrapSavedData;
import divinerpg.registries.ItemRegistry;
import divinerpg.registries.MobEffectRegistry;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import pro.komaru.tridot.util.Tmp;
import pro.komaru.tridot.util.math.ArcRandom;

public class TrapItem
extends Item {
    private final BlockState blockState;
    private final int radius;
    private final int height;
    private final int durationTicks;
    private static final Map<ServerLevel, List<TrapInstance>> ACTIVE_TRAPS = new HashMap<ServerLevel, List<TrapInstance>>();
    private static final Map<ServerLevel, Map<BlockPos, Deque<TrapInstance.SavedBlock>>> GLOBAL_REPLACED = new HashMap<ServerLevel, Map<BlockPos, Deque<TrapInstance.SavedBlock>>>();

    public TrapItem(Item.Properties props, BlockState blockState, int radius, int height, int durationSeconds) {
        super(props);
        this.blockState = blockState;
        this.radius = radius;
        this.height = height;
        this.durationTicks = durationSeconds * 20;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!player.m_7500_()) {
            stack.m_41774_(1);
        }
        if (!(level instanceof ServerLevel)) {
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        ServerLevel serverLevel = (ServerLevel)level;
        player.m_36335_().m_41524_((Item)ItemRegistry.small_trap.get(), 560);
        player.m_36335_().m_41524_((Item)ItemRegistry.large_trap.get(), 560);
        BlockPos center = player.m_20183_().m_6625_(1);
        TrapInstance trap = new TrapInstance(player.m_20148_(), this.blockState, center, serverLevel.m_46467_() + (long)this.durationTicks, this.radius, this.height);
        trap.build(serverLevel);
        ACTIVE_TRAPS.computeIfAbsent(serverLevel, l -> new ArrayList()).add(trap);
        TrapSavedData data = TrapSavedData.get(serverLevel);
        data.getTraps().add(trap.toData());
        data.markDirtyAndSave();
        AABB box = new AABB(center).m_82400_(5.0);
        for (Player other : serverLevel.m_45976_(Player.class, box)) {
            if (other.m_20148_().equals(player.m_20148_())) continue;
            other.m_7292_(new MobEffectInstance((MobEffect)MobEffectRegistry.CHAINED.get(), 100, 0));
            other.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 10, 1));
        }
        serverLevel.m_5594_(null, center, SoundEvents.f_12312_, SoundSource.BLOCKS, 1.0f, 0.8f);
        return InteractionResultHolder.m_19096_((Object)player.m_21120_(hand));
    }

    public void m_7373_(@NotNull ItemStack stack, Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        tooltip.add((Component)Component.m_237113_((String)"\u041f\u0440\u0438 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0438 \u0441\u043e\u0437\u0434\u0430\u0451\u0442 \u043a\u043e\u0440\u043e\u0431\u043a\u0443 \u0438\u0437 \u043d\u0435\u043b\u043e\u043c\u0430\u0435\u043c\u044b\u0445 \u0431\u043b\u043e\u043a\u043e\u0432 \u0432\u043e\u043a\u0440\u0443\u0433 \u0432\u0430\u0441, \u0438\u0437 \u043a\u043e\u0442\u043e\u0440\u043e\u0439 \u0442\u044f\u0436\u0435\u043b\u043e \u0432\u044b\u0431\u0440\u0430\u0442\u044c\u0441\u044f").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237119_());
        tooltip.add((Component)Component.m_237113_((String)("\u00bb \u0420\u0430\u0437\u043c\u0435\u0440: " + (this.radius * 2 + 1 - 2) + "x" + (this.height - 2) + "x" + (this.radius * 2 + 1 - 2))).m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237113_((String)("\u00bb \u0414\u043b\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c: " + this.durationTicks / 20 + " \u0441\u0435\u043a\u0443\u043d\u0434")).m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237113_((String)"\u00bb \u0414\u0430\u0451\u0442 \u043e\u0446\u0435\u043f\u0435\u043d\u0435\u043d\u0438\u0435 \u0438 \u0441\u043b\u0435\u043f\u043e\u0442\u0443 \u0432\u0441\u0435\u043c \u0432\u043d\u0443\u0442\u0440\u0438").m_130940_(ChatFormatting.GRAY));
    }

    public static void tick(@NotNull ServerLevel level) {
        long time = level.m_46467_();
        List<TrapInstance> traps = ACTIVE_TRAPS.get(level);
        if (traps == null) {
            return;
        }
        TrapSavedData data = TrapSavedData.get(level);
        Iterator<TrapInstance> it = traps.iterator();
        while (it.hasNext()) {
            TrapInstance trap = it.next();
            if (!trap.isExpired(time)) continue;
            trap.restore(level);
            data.getTraps().removeIf(d -> d.owner.equals(trap.owner) && d.center.equals((Object)trap.center) && d.expireTick == trap.expireTick);
            it.remove();
        }
        data.markDirtyAndSave();
        if (traps.isEmpty()) {
            ACTIVE_TRAPS.remove(level);
        }
    }

    public static class TrapInstance {
        UUID owner;
        BlockState blockState;
        BlockPos center;
        long expireTick;
        int radius;
        int height;
        Map<BlockPos, SavedBlock> replacedBlocks = new HashMap<BlockPos, SavedBlock>();

        public TrapInstance(UUID owner, BlockState blockState, BlockPos center, long expireTick, int radius, int height) {
            this.owner = owner;
            this.blockState = blockState;
            this.center = center;
            this.expireTick = expireTick;
            this.radius = radius;
            this.height = height;
        }

        void build(ServerLevel level) {
            Map map = GLOBAL_REPLACED.computeIfAbsent(level, l -> new HashMap());
            int minY = level.m_141937_();
            int maxY = level.m_151558_();
            for (int dx = -this.radius; dx <= this.radius; ++dx) {
                for (int dy = 0; dy < this.height; ++dy) {
                    for (int dz = -this.radius; dz <= this.radius; ++dz) {
                        int y;
                        boolean isWall;
                        BlockPos pos = this.center.m_7918_(dx, dy, dz);
                        boolean bl = isWall = Math.abs(dx) == this.radius || Math.abs(dz) == this.radius || dy == 0 || dy == this.height - 1;
                        if (!isWall || (y = pos.m_123342_()) < minY || y >= maxY) continue;
                        BlockState currentState = level.m_8055_(pos);
                        Deque stack = map.computeIfAbsent(pos, p -> new ArrayDeque());
                        if (stack.isEmpty()) {
                            CompoundTag beNbt = null;
                            BlockEntity be = level.m_7702_(pos);
                            if (be != null) {
                                try {
                                    beNbt = be.m_187480_();
                                }
                                catch (Exception e) {
                                    DivineRPG.LOGGER.error("Error saving BlockEntity NBT at " + pos, (Throwable)e);
                                }
                                level.m_46747_(pos);
                            }
                            SavedBlock original = new SavedBlock(currentState, beNbt, true);
                            stack.push(original);
                            this.replacedBlocks.put(pos, original);
                        }
                        stack.push(new SavedBlock(this.blockState, null, false));
                        if (currentState == this.blockState) continue;
                        level.m_7731_(pos, this.blockState, 3);
                    }
                }
            }
        }

        boolean isExpired(long currentTick) {
            return currentTick >= this.expireTick;
        }

        void restore(ServerLevel level) {
            Map<BlockPos, Deque<SavedBlock>> map = GLOBAL_REPLACED.get(level);
            if (map == null) {
                return;
            }
            for (int dx = -this.radius; dx <= this.radius; ++dx) {
                for (int dy = 0; dy < this.height; ++dy) {
                    for (int dz = -this.radius; dz <= this.radius; ++dz) {
                        BlockPos pos = this.center.m_7918_(dx, dy, dz);
                        Deque<SavedBlock> stack = map.get(pos);
                        if (stack == null || stack.isEmpty()) continue;
                        SavedBlock removed = stack.pop();
                        if (removed.original()) {
                            DivineRPG.LOGGER.warn("Trap restore: top was original at {}", (Object)pos);
                        }
                        if (stack.size() == 1) {
                            BlockEntity be;
                            SavedBlock original = stack.pop();
                            level.m_7731_(pos, original.state(), 3);
                            if (original.nbt() != null && (be = level.m_7702_(pos)) != null) {
                                try {
                                    be.m_142466_(original.nbt());
                                    be.m_6596_();
                                }
                                catch (Exception e) {
                                    DivineRPG.LOGGER.error("Error restoring BlockEntity at " + pos, (Throwable)e);
                                }
                            }
                            map.remove(pos);
                            continue;
                        }
                        level.m_7731_(pos, this.blockState, 3);
                    }
                }
            }
            level.m_5594_(null, this.center, SoundEvents.f_12601_, SoundSource.BLOCKS, 1.0f, 1.0f);
            ArcRandom rand = Tmp.rnd;
            for (int i = 0; i < 24; ++i) {
                double x = (double)this.center.m_123341_() + 0.5 + (rand.nextDouble() - 0.5) * (double)this.radius * 2.0;
                double y = (double)this.center.m_123342_() + 0.5 + rand.nextDouble() * (double)this.height;
                double z = (double)this.center.m_123343_() + 0.5 + (rand.nextDouble() - 0.5) * (double)this.radius * 2.0;
                level.m_8767_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 1, 0.0, 0.0, 0.0, 0.01);
                level.m_8767_((ParticleOptions)ParticleTypes.f_123755_, x, y, z, 1, 0.0, 0.0, 0.0, 0.01);
                level.m_8767_((ParticleOptions)ParticleTypes.f_123777_, x, y, z, 1, 0.0, 0.0, 0.0, 0.01);
            }
            if (map.isEmpty()) {
                GLOBAL_REPLACED.remove(level);
            }
        }

        public TrapInstanceData toData() {
            TrapInstanceData data = new TrapInstanceData();
            data.owner = this.owner;
            data.center = this.center;
            data.radius = this.radius;
            data.height = this.height;
            data.expireTick = this.expireTick;
            data.blockState = this.blockState;
            data.replacedBlocks = new HashMap<BlockPos, SavedBlock>(this.replacedBlocks);
            return data;
        }

        public static void loadSavedTraps(ServerLevel level) {
            TrapSavedData data = TrapSavedData.get(level);
            ArrayList<TrapInstanceData> toRemove = new ArrayList<TrapInstanceData>();
            for (TrapInstanceData t : data.getTraps()) {
                TrapInstance trap = new TrapInstance(t.owner, t.blockState, t.center, t.expireTick, t.radius, t.height);
                trap.replacedBlocks.putAll(t.replacedBlocks);
                long now = level.m_46467_();
                if (trap.isExpired(now)) {
                    trap.restore(level);
                    toRemove.add(t);
                    continue;
                }
                Map map = GLOBAL_REPLACED.computeIfAbsent(level, l -> new HashMap());
                for (Map.Entry<BlockPos, SavedBlock> e : trap.replacedBlocks.entrySet()) {
                    Deque stack = map.computeIfAbsent(e.getKey(), k -> new ArrayDeque());
                    if (stack.isEmpty()) {
                        stack.push(e.getValue());
                    }
                    stack.push(new SavedBlock(trap.blockState, null, false));
                }
                ACTIVE_TRAPS.computeIfAbsent(level, l -> new ArrayList()).add(trap);
            }
            data.getTraps().removeAll(toRemove);
            if (!toRemove.isEmpty()) {
                data.markDirtyAndSave();
            }
        }

        private record SavedBlock(BlockState state, CompoundTag nbt, boolean original) {
        }
    }

    public static class TrapInstanceData {
        public UUID owner;
        public BlockPos center;
        public int radius;
        public int height;
        public long expireTick;
        public BlockState blockState;
        public Map<BlockPos, TrapInstance.SavedBlock> replacedBlocks = new HashMap<BlockPos, TrapInstance.SavedBlock>();

        public CompoundTag toTag() {
            CompoundTag tag = new CompoundTag();
            tag.m_128362_("owner", this.owner);
            tag.m_128356_("expireTick", this.expireTick);
            tag.m_128405_("radius", this.radius);
            tag.m_128405_("height", this.height);
            tag.m_128405_("x", this.center.m_123341_());
            tag.m_128405_("y", this.center.m_123342_());
            tag.m_128405_("z", this.center.m_123343_());
            tag.m_128365_("blockState", (Tag)NbtUtils.m_129202_((BlockState)this.blockState));
            CompoundTag blocksTag = new CompoundTag();
            for (Map.Entry<BlockPos, TrapInstance.SavedBlock> e : this.replacedBlocks.entrySet()) {
                CompoundTag saved = new CompoundTag();
                saved.m_128365_("blockState", (Tag)NbtUtils.m_129202_((BlockState)e.getValue().state()));
                if (e.getValue().nbt() != null) {
                    saved.m_128365_("nbt", (Tag)e.getValue().nbt());
                }
                saved.m_128379_("original", e.getValue().original());
                blocksTag.m_128365_(Long.toString(e.getKey().m_121878_()), (Tag)saved);
            }
            tag.m_128365_("replacedBlocks", (Tag)blocksTag);
            return tag;
        }

        public static TrapInstanceData fromTag(CompoundTag tag, ServerLevel level) {
            TrapInstanceData data = new TrapInstanceData();
            data.owner = tag.m_128342_("owner");
            data.expireTick = tag.m_128454_("expireTick");
            data.radius = tag.m_128451_("radius");
            data.height = tag.m_128451_("height");
            data.center = new BlockPos(tag.m_128451_("x"), tag.m_128451_("y"), tag.m_128451_("z"));
            data.blockState = NbtUtils.m_247651_((HolderGetter)level.m_9598_().m_255025_(Registries.f_256747_), (CompoundTag)tag.m_128469_("blockState"));
            data.replacedBlocks = new HashMap<BlockPos, TrapInstance.SavedBlock>();
            CompoundTag blocksTag = tag.m_128469_("replacedBlocks");
            for (String key : blocksTag.m_128431_()) {
                CompoundTag saved = blocksTag.m_128469_(key);
                BlockState state = NbtUtils.m_247651_((HolderGetter)level.m_9598_().m_255025_(Registries.f_256747_), (CompoundTag)saved.m_128469_("blockState"));
                CompoundTag nbt = saved.m_128441_("nbt") ? saved.m_128469_("nbt") : null;
                boolean original = !saved.m_128441_("original") || saved.m_128471_("original");
                data.replacedBlocks.put(BlockPos.m_122022_((long)Long.parseLong(key)), new TrapInstance.SavedBlock(state, nbt, original));
            }
            return data;
        }
    }
}

