/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.skins;

import com.idark.valoria.util.Pal;
import divinerpg.registries.ItemRegistry;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.RegistryObject;
import pro.komaru.tridot.client.model.item.ItemSkinModels;
import pro.komaru.tridot.common.registry.item.skins.ISkinProvider;
import pro.komaru.tridot.common.registry.item.skins.ItemSkin;
import pro.komaru.tridot.common.registry.item.skins.SkinBuilder;
import pro.komaru.tridot.common.registry.item.skins.SkinRegistryManager;
import pro.komaru.tridot.common.registry.item.skins.entries.ItemSupplierSkinEntry;
import pro.komaru.tridot.util.Col;

public class SkinsRegistry
implements ISkinProvider {
    public static final ItemSkin FIRE = SkinsRegistry.createSkin("fire", Pal.amber, SkinsRegistry.entry(ItemRegistry.celestium_sword, "fire_celestium_sword"), SkinsRegistry.entry(ItemRegistry.divine_soul, "fire_divine_soul"));
    public static final ItemSkin FOREST = SkinsRegistry.createSkin("forest", Pal.vividGreen, SkinsRegistry.entry(ItemRegistry.halite_blade, "forest_halite_blade"), SkinsRegistry.entry(ItemRegistry.echo_halite_blade, "forest_echo_halite_blade"));
    public static final ItemSkin LEGACY = SkinsRegistry.createSkin("legacy", Pal.softBlue, SkinsRegistry.entry(ItemRegistry.heavenly_blade, "legacy_heavenly_blade"), SkinsRegistry.entry(ItemRegistry.raglok_soul, "legacy_raglok_soul"), SkinsRegistry.entry(ItemRegistry.divine_soul, "legacy_divine_soul"), SkinsRegistry.entry(ItemRegistry.halite_blade, "legacy_halite_blade"), SkinsRegistry.entry(ItemRegistry.celestium_sword, "legacy_celestium_sword"), SkinsRegistry.entry(ItemRegistry.ender_scepter, "legacy_ender_scepter"), SkinsRegistry.entry(ItemRegistry.everbright, "legacy_everbright"), SkinsRegistry.entry(ItemRegistry.everlight, "legacy_everlight"), SkinsRegistry.entry(ItemRegistry.prime, "legacy_prime"), SkinsRegistry.entry(ItemRegistry.sandslash, "legacy_sandslash"), SkinsRegistry.entry(ItemRegistry.shadow_saber, "legacy_shadow_saber"));

    public void registerModels() {
        SkinRegistryManager.getSkins().forEach(skin -> {
            if (skin.id().m_135827_().equals("divinerpg")) {
                skin.skinEntries().forEach(entry -> {
                    if (entry instanceof ItemSupplierSkinEntry) {
                        ItemSupplierSkinEntry skinEntry = (ItemSupplierSkinEntry)entry;
                        ItemSkinModels.add((ResourceLocation)new ResourceLocation(skinEntry.skin));
                    }
                });
            }
        });
    }

    public void initializeSkins() {
    }

    private static SkinEntry entry(RegistryObject<Item> item, String modelName) {
        return new SkinEntry((Supplier<Item>)item, modelName);
    }

    private static ItemSkin createSkin(String name, Col color, SkinEntry ... entries) {
        SkinBuilder builder = new SkinBuilder("divinerpg", name).color(color);
        for (SkinEntry entry : entries) {
            ResourceLocation modelLocation = new ResourceLocation("divinerpg", entry.modelName());
            builder.add((pro.komaru.tridot.common.registry.item.skins.SkinEntry)new ItemSupplierSkinEntry(entry.item(), modelLocation));
        }
        builder.build();
        return SkinRegistryManager.get((String)new ResourceLocation("divinerpg", name).toString());
    }

    private record SkinEntry(Supplier<Item> item, String modelName) {
    }

    @Mod.EventBusSubscriber(modid="divinerpg", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void modelBakeSkins(ModelEvent.ModifyBakingResult event) {
            Map map = event.getModels();
            for (RegistryObject ro : ItemRegistry.ITEMS.getEntries()) {
                ItemStack stack = new ItemStack((ItemLike)ro.get());
                if (SkinRegistryManager.getApplicableSkins((ItemStack)stack).isEmpty()) continue;
                SkinRegistryManager.addSkinModel((Map)map, (ResourceLocation)ro.getId());
            }
        }
    }
}

