/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.vanilla;

import com.idark.valoria.core.config.ClientConfig;
import com.idark.valoria.registries.RarityRegistry;
import divinerpg.capability.ArcanaProvider;
import divinerpg.items.base.ItemModSword;
import divinerpg.packet.DivineRPGPacketHandler;
import divinerpg.packet.PacketRaglokSoulHearts;
import divinerpg.packet.PacketRaglokSoulSouls;
import divinerpg.util.RandomUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import pro.komaru.tridot.api.interfaces.OverlayRenderItem;
import pro.komaru.tridot.util.Tmp;

public class ItemRaglokSoul
extends ItemModSword
implements OverlayRenderItem {
    private int maxHits;
    private static final float CHANCE = 0.55f;

    public ItemRaglokSoul(Tier tier, int maxHits) {
        super(tier, new Item.Properties().m_41486_().m_41497_(RarityRegistry.INFERNAL));
        this.maxHits = maxHits;
    }

    public ItemRaglokSoul(Tier tier, Rarity rarity, int maxHits) {
        super(tier, new Item.Properties().m_41486_().m_41497_(rarity));
        this.maxHits = maxHits;
    }

    public boolean m_7579_(@NotNull ItemStack stack, @NotNull LivingEntity entity, @NotNull LivingEntity pPlayer) {
        Player player = (Player)pPlayer;
        if ((float)player.f_20913_ == 0.0f) {
            if (RandomUtil.percentChance(0.55f)) {
                DivineRPGPacketHandler.sendToTracking(player.m_9236_(), player.m_20097_().m_7494_(), new PacketRaglokSoulSouls(entity.m_20185_(), entity.m_20186_(), entity.m_20189_()));
                this.addHit(stack, player);
            }
            if (this.getHits(stack) >= this.maxHits) {
                player.getCapability(ArcanaProvider.ARCANA).ifPresent(arcana -> {
                    DivineRPGPacketHandler.sendToTracking(player.m_9236_(), player.m_20097_().m_7494_(), new PacketRaglokSoulHearts(player.m_20185_(), player.m_20186_(), player.m_20189_()));
                    player.m_9236_().m_5594_(null, player.m_20097_(), SoundEvents.f_12563_, SoundSource.PLAYERS, 1.0f, 1.7f + ItemRaglokSoul.determinateFloats());
                    arcana.modifyAmount((LivingEntity)player, arcana.getMaxArcana((LivingEntity)player, false) - arcana.getAmount(false));
                    player.m_5634_(player.m_21233_() - player.m_21223_());
                    this.clearHits(stack);
                });
            }
        }
        return super.m_7579_(stack, entity, (LivingEntity)player);
    }

    private static float determinateFloats() {
        return Tmp.rnd.nextFloat(-0.125f, 0.15f);
    }

    public void addHit(ItemStack pStack, Player player) {
        pStack.m_41784_().m_128405_("Hits", this.getHits(pStack) + 1);
        player.m_9236_().m_5594_(null, player.m_20097_(), SoundEvents.f_12554_, SoundSource.PLAYERS, 1.0f, 2.0f + ItemRaglokSoul.determinateFloats());
        player.m_9236_().m_5594_(null, player.m_20097_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 1.0f, 2.0f + ItemRaglokSoul.determinateFloats());
    }

    public void addHits(int count, ItemStack pStack, Player player) {
        pStack.m_41784_().m_128405_("Hits", this.getHits(pStack) + count);
        player.m_9236_().m_5594_(null, player.m_20097_(), SoundEvents.f_12554_, SoundSource.PLAYERS, 1.0f, 2.0f + ItemRaglokSoul.determinateFloats());
        player.m_9236_().m_5594_(null, player.m_20097_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 1.0f, 2.0f + ItemRaglokSoul.determinateFloats());
    }

    public void clearHits(ItemStack pStack) {
        pStack.m_41784_().m_128405_("Hits", 0);
    }

    public int getHits(ItemStack stack) {
        return stack.m_41784_().m_128451_("Hits");
    }

    private void removeHit(ItemStack stack) {
        int hits = this.getHits(stack);
        if (hits > 0) {
            stack.m_41784_().m_128405_("Hits", hits - 1);
        }
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)Component.m_237113_((String)"\u0412\u043e\u0441\u043f\u043e\u043b\u043d\u044f\u0435\u0442 100% \u0425\u041f \u0438 \u0410\u0440\u043a\u0430\u043d\u044b \u043f\u043e\u0441\u043b\u0435 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u0428\u043a\u0430\u043b\u044b \u043a\u0440\u043e\u0432\u0438").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237113_((String)String.format("\u0428\u043a\u0430\u043b\u0430 \u0437\u0430\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f \u0441 \u0448\u0430\u043d\u0441\u043e\u043c %s%% \u043f\u0440\u0438 \u043f\u043e\u043b\u043d\u044b\u0445 \u0443\u0434\u0430\u0440\u0430\u0445", Float.valueOf(55.0f))).m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237119_());
        tooltip.add((Component)Component.m_237113_((String)("\u0425\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435: " + this.getHits(stack) + "/" + this.maxHits)).m_130940_(ChatFormatting.GRAY).m_130946_(" \u00a74\u00a7l\ud83d\udca7"));
    }

    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getTexture() {
        return new ResourceLocation("divinerpg", "textures/gui/overlay/raglok_soul.png");
    }

    public void m_6883_(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slotId, boolean isSelected) {
        super.m_6883_(stack, level, entity, slotId, isSelected);
        if (level.f_46443_) {
            return;
        }
        if (!(entity instanceof Player)) {
            return;
        }
        if (level.m_46467_() % 20L == 0L && this.getHits(stack) > 0 && RandomUtil.percentChance(0.1f)) {
            this.removeHit(stack);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(CompoundTag tag, GuiGraphics gui, int offsetX, int offsetY) {
        int xCord = (Integer)ClientConfig.MISC_UI_X.get() + offsetX;
        int yCord = (Integer)ClientConfig.MISC_UI_Y.get() + offsetY;
        int hits = tag.m_128451_("Hits");
        int progress = (int)Math.round(22.0 * Math.min(1.0, (double)hits / (double)Math.max(1, this.maxHits)));
        gui.m_280163_(this.getTexture(), xCord, yCord, 0.0f, 0.0f, 24, 48, 48, 48);
        gui.m_280163_(this.getTexture(), xCord + 6, yCord + 39 - (int)((double)progress * 1.5), 36.0f, (float)(33 - (int)((double)progress * 1.5)), 12, (int)((double)progress * 1.5), 48, 48);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }
}

