/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.mixin;

import com.idark.valoria.registries.entity.living.boss.WickedCrystal;
import com.idark.valoria.registries.entity.projectile.CrystalShard;
import divinerpg.DivineRPG;
import java.lang.reflect.Field;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WickedCrystal.CrystalStorm.class})
public class CrystalStormMixin {
    @Unique
    private static Field divineRPG$ownerField;

    @Unique
    private WickedCrystal divineRPG$getOwner() {
        try {
            Object value;
            if (divineRPG$ownerField == null) {
                divineRPG$ownerField = this.getClass().getDeclaredField("this$0");
                divineRPG$ownerField.setAccessible(true);
            }
            if ((value = divineRPG$ownerField.get(this)) instanceof WickedCrystal) {
                WickedCrystal crystal = (WickedCrystal)value;
                return crystal;
            }
            DivineRPG.LOGGER.error("CrystalStorm enclosing instance is not a WickedCrystal: {}", value);
        }
        catch (Exception e) {
            DivineRPG.LOGGER.error("Failed to get owner from CrystalStorm: {}", (Object)e.getMessage(), (Object)e);
        }
        return null;
    }

    @Inject(method={"summonStormCrystal"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void injectSummonStormCrystal(ServerLevel serverLevel, BlockPos spawnPos, float angle, double speed, CallbackInfo ci) {
        WickedCrystal owner = this.divineRPG$getOwner();
        if (owner == null) {
            return;
        }
        CrystalShard crystalShard = new CrystalShard((Level)serverLevel, (LivingEntity)owner, 85.0);
        crystalShard.m_7678_((double)spawnPos.m_123341_() + 0.5, (double)(spawnPos.m_123342_() + 2), (double)spawnPos.m_123343_() + 0.5, 0.0f, 0.0f);
        double vx = Math.cos(angle) * speed * 2.25;
        double vz = Math.sin(angle) * speed * 2.25;
        crystalShard.m_20334_(vx, 0.4, vz);
        serverLevel.m_7967_((Entity)crystalShard);
        ci.cancel();
    }
}

