/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.mixin;

import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.item.enchantment.ProtectionEnchantment;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={ProtectionEnchantment.class})
public abstract class ProtectionEnchantmentMixin {
    @Overwrite
    public int m_7205_(int pLevel, DamageSource pSource) {
        int baseMultiplier;
        ProtectionEnchantment self = (ProtectionEnchantment)this;
        if (pSource.m_269533_(DamageTypeTags.f_268738_)) {
            return 0;
        }
        if (self.f_45124_ != ProtectionEnchantment.Type.ALL && !this.divineRPG$isMatchingType(self.f_45124_, pSource)) {
            return 0;
        }
        switch (self.f_45124_) {
            case FIRE: 
            case EXPLOSION: 
            case PROJECTILE: {
                int n = 2;
                break;
            }
            case FALL: {
                int n = 3;
                break;
            }
            default: {
                int n = baseMultiplier = 1;
            }
        }
        if (pLevel <= 4) {
            return pLevel * baseMultiplier;
        }
        return (int)((double)(4 * baseMultiplier) + (double)baseMultiplier * 1.5 * (1.0 - Math.pow(0.6, pLevel - 4)));
    }

    @Unique
    private boolean divineRPG$isMatchingType(ProtectionEnchantment.Type type, DamageSource source) {
        return switch (type) {
            case ProtectionEnchantment.Type.FIRE -> source.m_269533_(DamageTypeTags.f_268745_);
            case ProtectionEnchantment.Type.FALL -> source.m_269533_(DamageTypeTags.f_268549_);
            case ProtectionEnchantment.Type.EXPLOSION -> source.m_269533_(DamageTypeTags.f_268415_);
            case ProtectionEnchantment.Type.PROJECTILE -> source.m_269533_(DamageTypeTags.f_268524_);
            default -> true;
        };
    }
}

