/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.mixin;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class ResistanceModifierMixin {
    @Inject(method={"getDamageAfterMagicAbsorb"}, at={@At(value="HEAD")}, cancellable=true)
    private void modifyResistanceAndProtection(DamageSource source, float amount, CallbackInfoReturnable<Float> cir) {
        LivingEntity self = (LivingEntity)this;
        if (source.m_269533_(DamageTypeTags.f_268437_)) {
            cir.setReturnValue((Object)Float.valueOf(amount));
            return;
        }
        if (self.m_21023_(MobEffects.f_19606_) && !source.m_269533_(DamageTypeTags.f_268630_)) {
            MobEffectInstance effect = self.m_21124_(MobEffects.f_19606_);
            int level = effect != null ? effect.m_19564_() + 1 : 0;
            float reduction = 0.077f * (float)level;
            float reduced = amount * (1.0f - (reduction = Math.min(reduction, 0.52f)));
            float resisted = amount - reduced;
            if (resisted > 0.0f && resisted < Float.MAX_VALUE) {
                if (self instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)self;
                    player.m_6278_(Stats.f_12988_.m_12902_((Object)Stats.f_12934_), Math.round(resisted * 10.0f));
                } else {
                    Entity entity = source.m_7639_();
                    if (entity instanceof ServerPlayer) {
                        ServerPlayer attacker = (ServerPlayer)entity;
                        attacker.m_6278_(Stats.f_12988_.m_12902_((Object)Stats.f_12930_), Math.round(resisted * 10.0f));
                    }
                }
            }
            amount = reduced;
        }
        if (!source.m_269533_(DamageTypeTags.f_268413_)) {
            float protectionPoints = 0.0f;
            for (ItemStack stack : self.m_6168_()) {
                int level = stack.getEnchantmentLevel(Enchantments.f_44965_);
                if (level <= 0) continue;
                float effectiveLevel = switch (level) {
                    case 5 -> 4.52f;
                    default -> level;
                };
                protectionPoints += effectiveLevel;
            }
            if ((protectionPoints = Math.min(protectionPoints, 18.0f)) > 0.0f) {
                amount = CombatRules.m_19269_((float)amount, (float)protectionPoints);
            }
        }
        cir.setReturnValue((Object)Float.valueOf(amount));
    }
}

