/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.packet;

import com.mojang.datafixers.util.Pair;
import divinerpg.packet.PacketArcanaBar;
import divinerpg.packet.PacketDivineAccumulator;
import divinerpg.packet.PacketRaglokSoulHearts;
import divinerpg.packet.PacketRaglokSoulSouls;
import divinerpg.util.Utils;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class DivineRPGPacketHandler {
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("divinerpg", "main"), () -> "1", "1"::equals, "1"::equals);
    private static final PacketDistributor<Pair<Level, BlockPos>> TRACKING_CHUNK_AND_NEAR = new PacketDistributor((_d, pairSupplier) -> {
        Pair pair = (Pair)pairSupplier.get();
        Level level = (Level)pair.getFirst();
        BlockPos blockpos = (BlockPos)pair.getSecond();
        return packet -> ((ServerChunkCache)level.m_7726_()).f_8325_.m_183262_(new ChunkPos(blockpos), false).stream().filter(p -> p.m_20275_((double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_()) < 4096.0).forEach(p -> p.f_8906_.m_9829_(packet));
    }, NetworkDirection.PLAY_TO_CLIENT);

    public static void init() {
        int index = 0;
        INSTANCE.registerMessage(index++, Byte.class, (l, buf) -> buf.writeByte((int)l.byteValue()), FriendlyByteBuf::readByte, DivineRPGPacketHandler::handle);
        INSTANCE.registerMessage(index++, PacketArcanaBar.class, PacketArcanaBar::toBytes, PacketArcanaBar::new, PacketArcanaBar::handle);
        INSTANCE.registerMessage(index++, PacketDivineAccumulator.class, PacketDivineAccumulator::toBytes, PacketDivineAccumulator::new, PacketDivineAccumulator::handle);
        INSTANCE.registerMessage(index++, PacketRaglokSoulHearts.class, PacketRaglokSoulHearts::encode, PacketRaglokSoulHearts::decode, PacketRaglokSoulHearts::handle);
        INSTANCE.registerMessage(index++, PacketRaglokSoulSouls.class, PacketRaglokSoulSouls::encode, PacketRaglokSoulSouls::decode, PacketRaglokSoulSouls::handle);
    }

    public static void handle(Byte i, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Utils.ICEIKA_WEATHER = i;
        });
        ctx.get().setPacketHandled(true);
    }

    public static byte newWeather() {
        byte b = (byte)(Math.random() * 4.0);
        INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)b);
        return b;
    }

    public static void sendTo(ServerPlayer playerMP, Object toSend) {
        INSTANCE.sendTo(toSend, playerMP.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    public static void sendToTracking(Level world, BlockPos pos, Object msg) {
        INSTANCE.send(TRACKING_CHUNK_AND_NEAR.with(() -> Pair.of((Object)world, (Object)pos)), msg);
    }
}

