/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.packet;

import divinerpg.capability.Arcana;
import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;

public class PacketArcanaBar {
    private float max;
    private float arcana;

    public PacketArcanaBar(ByteBuf buf) {
        this.max = buf.readFloat();
        this.arcana = buf.readFloat();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeFloat(this.max);
        buf.writeFloat(this.arcana);
    }

    public PacketArcanaBar(Arcana arcana, @Nullable LivingEntity entity) {
        this.max = arcana.getMaxArcana(entity, false);
        this.arcana = arcana.getAmount(false);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Arcana.clientMax = this.max;
            Arcana.clientAmount = this.arcana;
        });
        ctx.get().setPacketHandled(true);
    }
}

