/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.scheduling;

import com.google.common.collect.HashMultimap;
import divinerpg.DivineRPG;
import divinerpg.events.Ticker;
import java.util.Iterator;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.Nullable;

public class AoAScheduler {
    private static ScheduledExecutorService scheduler = null;
    private static final HashMultimap<Integer, Runnable> scheduledSyncTasks = HashMultimap.create();
    private static boolean running = true;

    public static void scheduleSynchronizedTask(Runnable run, int ticks) {
        scheduledSyncTasks.put((Object)(Ticker.tick + ticks), (Object)run);
    }

    public static void scheduleAsyncTask(Runnable run, int time, TimeUnit unit) {
        if (scheduler == null || !running) {
            AoAScheduler.serverStartupTasks();
        }
        scheduler.schedule(run, (long)time, unit);
    }

    public static void serverStartupTasks() {
        if (scheduler != null) {
            scheduler.shutdownNow();
        }
        scheduler = Executors.newScheduledThreadPool(1);
        AoAScheduler.handleSyncScheduledTasks(null);
    }

    public static void serverShutdownTasks() {
        AoAScheduler.handleSyncScheduledTasks(null);
        scheduler.shutdownNow();
        scheduler = null;
        running = false;
    }

    public static void handleSyncScheduledTasks(@Nullable Integer tick) {
        if (scheduledSyncTasks.containsKey((Object)tick)) {
            Iterator tasks;
            Iterator iterator = tasks = tick == null ? scheduledSyncTasks.values().iterator() : scheduledSyncTasks.get((Object)tick).iterator();
            while (tasks.hasNext()) {
                try {
                    ((Runnable)tasks.next()).run();
                }
                catch (Exception ex) {
                    DivineRPG.LOGGER.error(ex.toString());
                }
                tasks.remove();
            }
        }
    }
}

