/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.util;

import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraftforge.server.command.TextComponentHelper;
import pro.komaru.tridot.util.Col;

public class LocalizeUtils {
    private static final MutableComponent InfiniteUses = MutableComponent.m_237204_((ComponentContents)new TranslatableContents("tooltip.uses.infinite", null, null));
    private static final MutableComponent MaulShields = MutableComponent.m_237204_((ComponentContents)new TranslatableContents("tooltip.maul.shields", null, null));
    private static final MutableComponent NoProtection = MutableComponent.m_237204_((ComponentContents)new TranslatableContents("tooltip.noprotection", null, null));
    private static final MutableComponent HomingShoots = MutableComponent.m_237204_((ComponentContents)new TranslatableContents("tooltip.shots.homing", null, null));
    private static final MutableComponent SingleUse = MutableComponent.m_237204_((ComponentContents)new TranslatableContents("tooltip.uses.single", null, null));
    private static final MutableComponent InstantConsumption = MutableComponent.m_237204_((ComponentContents)new TranslatableContents("tooltip.instant_consumption", null, null));
    private static final MutableComponent WeakenedWithoutArcana = MutableComponent.m_237204_((ComponentContents)new TranslatableContents("tooltip.weakened_without_arcana", null, null));
    private static final String RemainingUses = "tooltip.uses";
    private static final String DamageReductionStringFormat = "tooltip.damage.reduction";
    private static final String Ammo = "tooltip.ammo";
    private static final String ArcanaConsuming = "tooltip.arcana";
    private static final String ArcanaDamageSource = "tooltip.damage.arcana";
    private static final String ArcanaRegen = "tooltip.arcana.regen";
    private static final String MeleeDamage = "tooltip.damage.melee";
    private static final String BowDamage = "tooltip.damage.ranged";
    private static final String SummonBoss = "tooltip.summon.boss";
    private static final String Efficency = "tooltip.efficiency";
    private static final String HarvestLevel = "tooltip.harvest_level";
    private static final String Poison = "tooltip.effect.poisons";
    private static final String BurnMobs = "tooltip.effect.burns";
    private static final String Bleeding = "tooltip.effect.bleeding";
    private static final String Chained = "tooltip.effect.chained";
    private static final String SlowMobs = "tooltip.effect.slows";
    private static final String EchoChance = "tooltip.effect.echo";

    public static TranslatableContents getArmorAbility(String keyPart, Object ... params) {
        String id = String.format("tooltip.armor_info.%s", keyPart);
        return params == null || params.length < 1 ? new TranslatableContents(id, null, null) : new TranslatableContents(id, null, params);
    }

    public static String romanNumerals(int number) {
        String[] numerals = new String[]{"I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX", "X"};
        if (number >= 1 && number <= numerals.length) {
            return numerals[number - 1];
        }
        return Integer.toString(number);
    }

    public static Component usesRemaining(int uses) {
        return LocalizeUtils.i18n(RemainingUses, uses);
    }

    public static Component infiniteAmmo() {
        return LocalizeUtils.i18n("tooltip.ammo.infinite", new Object[0]);
    }

    public static Component ammo(Item ammo) {
        return LocalizeUtils.ammo(ammo, ChatFormatting.GRAY);
    }

    public static Component ammo(Item ammo, boolean isPresent) {
        return LocalizeUtils.ammo(ammo, isPresent ? ChatFormatting.GREEN : ChatFormatting.RED);
    }

    public static Component ammo(Item ammo, ChatFormatting formatting) {
        MutableComponent ammoName = MutableComponent.m_237204_((ComponentContents)new TranslatableContents(ammo.m_5524_(), null, null));
        ammoName.m_7383_().m_131157_(formatting);
        return LocalizeUtils.i18n(Ammo, ammoName);
    }

    public static Component arcanaConsumed(Object ar) {
        return LocalizeUtils.i18n(ArcanaConsuming, ar);
    }

    public static Component arcanaDam(double dam) {
        return LocalizeUtils.i18n(ArcanaDamageSource, dam);
    }

    public static Component arcanaRegen(int ar) {
        return LocalizeUtils.i18n(ArcanaRegen, ar);
    }

    public static Component bowDam(String dam) {
        return LocalizeUtils.i18n(BowDamage, dam);
    }

    public static Component chained(int seconds) {
        return LocalizeUtils.i18n(Chained, seconds);
    }

    public static Component burn(int seconds) {
        return LocalizeUtils.i18n(BurnMobs, seconds);
    }

    public static Component bleeding(int seconds) {
        return LocalizeUtils.i18n(Bleeding, seconds);
    }

    public static Component infiniteUses() {
        return InfiniteUses.m_130940_(ChatFormatting.BLUE);
    }

    public static Component maulShields() {
        return MaulShields.m_130940_(ChatFormatting.GRAY);
    }

    public static Component instantConsumption() {
        return InstantConsumption.m_130940_(ChatFormatting.AQUA);
    }

    public static Component shieldTimeBlock(int time) {
        return LocalizeUtils.i18n("tooltip.shield_time", time);
    }

    public static Component shieldMaxDamage(int max) {
        return LocalizeUtils.i18n("tooltip.shield_use", max);
    }

    public static Component weakenedWithoutArcana() {
        return WeakenedWithoutArcana.m_130940_(ChatFormatting.RED);
    }

    public static Component damageReduction(double reduct, double fullReduct) {
        return LocalizeUtils.i18n(DamageReductionStringFormat, reduct, fullReduct);
    }

    public static Component efficiency(double eff) {
        return LocalizeUtils.i18n(Efficency, eff);
    }

    public static Component harvestLevel(int lvl) {
        return LocalizeUtils.i18n(HarvestLevel, lvl);
    }

    public static Component explosiveShots() {
        return LocalizeUtils.i18n("tooltip.shots.explosive", new Object[0]);
    }

    public static Component homingShots() {
        return HomingShoots;
    }

    public static Component singleUse() {
        return SingleUse;
    }

    public static Component meleeDam(double dam) {
        return LocalizeUtils.i18n(MeleeDamage, dam);
    }

    public static Component poison(float seconds) {
        return LocalizeUtils.i18n(Poison, Float.valueOf(seconds));
    }

    public static Component rangedDam(double dam) {
        return LocalizeUtils.i18n(BowDamage, dam);
    }

    public static Component summonBoss(Supplier<EntityType<?>> ent) {
        return LocalizeUtils.i18n(SummonBoss, ent.get().m_20676_());
    }

    public static Component slow(double seconds) {
        return LocalizeUtils.i18n(SlowMobs, seconds);
    }

    public static Component echo(double chance) {
        return LocalizeUtils.i18n(EchoChance, chance);
    }

    public static Component noProtection() {
        return NoProtection;
    }

    public static ComponentContents normal(String message) {
        return LocalizeUtils.normal(message, ChatFormatting.WHITE);
    }

    public static ComponentContents normal(String message, ChatFormatting format) {
        MutableComponent text = MutableComponent.m_237204_((ComponentContents)new TranslatableContents(message, null, null));
        text.m_130940_(format);
        return text.m_214077_();
    }

    public static ComponentContents version(String vers) {
        MutableComponent text = MutableComponent.m_237204_((ComponentContents)new TranslatableContents("message.version", vers, null));
        text.m_130940_(ChatFormatting.DARK_RED);
        return text.m_214077_();
    }

    public static Component getClientSideTranslation(CommandSource sender, String str, Object ... args) {
        return TextComponentHelper.createComponentTranslation((CommandSource)sender, (String)str, (Object[])args);
    }

    public static Component i18n(String text, Object ... args) {
        MutableComponent result = MutableComponent.m_237204_((ComponentContents)new TranslatableContents(text, null, args));
        return result.m_130940_(ChatFormatting.GRAY);
    }

    public static Component i18n(ChatFormatting color, String text, Object ... args) {
        MutableComponent result = MutableComponent.m_237204_((ComponentContents)new TranslatableContents(text, null, args));
        return result.m_130940_(color);
    }

    public static Component defDivider(Col left, Col right) {
        return LocalizeUtils.gradientDivider("\u221e", 27, left, right);
    }

    public static Component gradientDivider(String pattern, int length, Col edge, Col center) {
        MutableComponent result = Component.m_237119_();
        for (int i = 0; i < length; ++i) {
            float dist = Math.abs(((float)i - (float)length / 2.0f) / ((float)length / 2.0f));
            float t = 1.0f - Math.min(1.0f, dist);
            Col col = new Col(edge).lerp(center, t);
            int rgb = col.toARGB();
            result.m_7220_((Component)Component.m_237113_((String)pattern).m_6270_(Style.f_131099_.m_178520_(rgb).m_178522_(Boolean.valueOf(true))));
        }
        return result;
    }

    public static int lerpColor(int c1, int c2, float t) {
        int r1 = c1 >> 16 & 0xFF;
        int g1 = c1 >> 8 & 0xFF;
        int b1 = c1 & 0xFF;
        int r2 = c2 >> 16 & 0xFF;
        int g2 = c2 >> 8 & 0xFF;
        int b2 = c2 & 0xFF;
        int r = (int)((float)r1 + (float)(r2 - r1) * t);
        int g = (int)((float)g1 + (float)(g2 - g1) * t);
        int b = (int)((float)b1 + (float)(b2 - b1) * t);
        return r << 16 | g << 8 | b;
    }
}

