/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.util;

import com.idark.valoria.registries.level.LevelGen;
import dev.ftb.mods.ftbquests.api.FTBQuestsAPI;
import dev.ftb.mods.ftbquests.quest.BaseQuestFile;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.TeamData;
import divinerpg.DivineRPG;
import divinerpg.registries.BlockRegistry;
import divinerpg.registries.LevelRegistry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class PortalAccessManager {
    public static final Map<ResourceKey<Level>, List<String>> DIMENSION_QUEST_REQUIREMENTS = new HashMap<ResourceKey<Level>, List<String>>();
    private static final Map<Block, ResourceKey<Level>> BLOCK_TO_DIM;

    public static boolean canAccess(ResourceKey<Level> target, UUID playerUUID) {
        List<String> requiredQuests = DIMENSION_QUEST_REQUIREMENTS.get(target);
        if (requiredQuests == null || requiredQuests.isEmpty()) {
            return true;
        }
        BaseQuestFile file = FTBQuestsAPI.api().getQuestFile(false);
        TeamData data = file.getNullableTeamData(playerUUID);
        if (data == null) {
            return false;
        }
        for (String hexId : requiredQuests) {
            try {
                long questId = Long.parseUnsignedLong(hexId, 16);
                Quest questObject = file.getQuest(questId);
                if (questObject == null) {
                    return false;
                }
                if (data.isCompleted((QuestObject)questObject)) continue;
                return false;
            }
            catch (NumberFormatException e) {
                DivineRPG.LOGGER.error(e.getMessage(), (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public static ResourceKey<Level> getDimensionForBlock(Block block) {
        return BLOCK_TO_DIM.getOrDefault(block, null);
    }

    static {
        DIMENSION_QUEST_REQUIREMENTS.put(LevelRegistry.ICEIKA, List.of("35B7F410E24B20B9"));
        DIMENSION_QUEST_REQUIREMENTS.put(LevelRegistry.EDEN, List.of("2204CB6D42655DEB"));
        DIMENSION_QUEST_REQUIREMENTS.put(LevelRegistry.WILDWOOD, List.of("6AE5C149D8C40608", "3041631ABEAAD62E"));
        DIMENSION_QUEST_REQUIREMENTS.put(LevelRegistry.APALACHIA, List.of("577A7E23552A27B2", "1FF535683ECAB9D7", "3041631ABEAAD62E", "71D138B443809244", "2CE60C52DA494E57"));
        DIMENSION_QUEST_REQUIREMENTS.put(LevelRegistry.SKYTHERN, List.of("5959A3EA27D0ADFC", "577A7E23552A27B2", "1FF535683ECAB9D7", "3041631ABEAAD62E", "71D138B443809244", "2CE60C52DA494E57", "2B8AC22854BFE90D"));
        DIMENSION_QUEST_REQUIREMENTS.put(LevelRegistry.MORTUM, List.of("5959A3EA27D0ADFC", "577A7E23552A27B2", "1FF535683ECAB9D7", "26C3A4782232E5FA", "3041631ABEAAD62E", "71D138B443809244", "2CE60C52DA494E57", "2B8AC22854BFE90D", "5498ABDA5AF89AE7"));
        DIMENSION_QUEST_REQUIREMENTS.put(LevelRegistry.ARCANA, List.of("646B788809209B79", "408A6A5FD53EBAB2"));
        DIMENSION_QUEST_REQUIREMENTS.put((ResourceKey<Level>)LevelGen.VALORIA_KEY, List.of("2E20CFB8182D2446", "5959A3EA27D0ADFC", "577A7E23552A27B2", "1FF535683ECAB9D7", "26C3A4782232E5FA", "3041631ABEAAD62E", "71D138B443809244", "2CE60C52DA494E57", "2B8AC22854BFE90D", "5498ABDA5AF89AE7", "239C04738174A70A", "098E9AA4AED0EA5C", "729261F42B956F1E"));
        BLOCK_TO_DIM = Map.ofEntries(Map.entry(Blocks.f_50127_, LevelRegistry.ICEIKA), Map.entry((Block)BlockRegistry.iceikaPortal.get(), LevelRegistry.ICEIKA), Map.entry((Block)BlockRegistry.divineRock.get(), LevelRegistry.EDEN), Map.entry((Block)BlockRegistry.edenPortal.get(), LevelRegistry.EDEN), Map.entry((Block)BlockRegistry.edenBlock.get(), LevelRegistry.WILDWOOD), Map.entry((Block)BlockRegistry.wildwoodPortal.get(), LevelRegistry.WILDWOOD), Map.entry((Block)BlockRegistry.wildwoodBlock.get(), LevelRegistry.APALACHIA), Map.entry((Block)BlockRegistry.apalachiaPortal.get(), LevelRegistry.APALACHIA), Map.entry((Block)BlockRegistry.apalachiaBlock.get(), LevelRegistry.SKYTHERN), Map.entry((Block)BlockRegistry.skythernPortal.get(), LevelRegistry.SKYTHERN), Map.entry((Block)BlockRegistry.skythernBlock.get(), LevelRegistry.MORTUM), Map.entry((Block)BlockRegistry.mortumPortal.get(), LevelRegistry.MORTUM), Map.entry((Block)BlockRegistry.arcanaPortal.get(), LevelRegistry.ARCANA), Map.entry((Block)BlockRegistry.arcanaPortalFrame.get(), LevelRegistry.ARCANA), Map.entry((Block)BlockRegistry.arcanaHardPortalFrame.get(), LevelRegistry.ARCANA), Map.entry((Block)com.idark.valoria.registries.BlockRegistry.valoriaPortalFrame.get(), LevelGen.VALORIA_KEY), Map.entry((Block)com.idark.valoria.registries.BlockRegistry.valoriaPortal.get(), LevelGen.VALORIA_KEY));
    }
}

