/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.util;

import divinerpg.registries.SoundRegistry;
import divinerpg.util.LocalizeUtils;
import divinerpg.world.placement.Surface;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import pro.komaru.tridot.api.render.text.DotStyleEffects;
import pro.komaru.tridot.client.gfx.text.DotStyle;
import pro.komaru.tridot.util.Col;

public class Utils {
    public static byte ICEIKA_WEATHER = (byte)(Math.random() * 4.0);

    public static void sendPortalMessage(ServerPlayer player) {
        player.m_5661_((Component)Component.m_237115_((String)"message.portal.access_denied").m_130948_((Style)DotStyle.of().color(Col.fromHex((String)"3f0000")).effect((DotStyle.StyleEffect)DotStyleEffects.ShakeFX.of((float)0.3f)).effect((DotStyle.StyleEffect)DotStyleEffects.OutlineFX.of((Col)Col.red, (boolean)true))), true);
        player.m_9236_().m_46473_().m_7238_();
    }

    public static void broadcastThunderbladeMessages(Level level) {
        level.m_7654_().m_6846_().m_11314_().forEach(Utils::sendThunderbladeMessage);
    }

    public static void sendThunderbladeMessage(ServerPlayer player) {
        ArrayList<Object> out = new ArrayList<Object>();
        out.add(Component.m_237113_((String)""));
        out.add(LocalizeUtils.defDivider(Col.fromHex((String)"#faff70"), Col.fromHex((String)"#6cfec2")));
        out.add(Component.m_237113_((String)""));
        out.add(Component.m_237113_((String)"   \u2694 \u041d\u0415\u0411\u0415\u0421\u041d\u042b\u0419 \u0421\u0422\u0420\u0410\u0416 \u041f\u0420\u0418\u0411\u042b\u041b \u2694").m_6270_(Style.f_131099_.m_178520_(16449392).m_131136_(Boolean.valueOf(true))));
        out.add(Component.m_237113_((String)""));
        out.add(Component.m_237113_((String)"  \u00a7 \u041f\u0440\u0438\u043c\u0435\u0440\u043d\u043e\u0435 \u043c\u0435\u0441\u0442\u043e\u043f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u0435:").m_6270_(Style.f_131099_.m_178520_(0xFFFFFF).m_131136_(Boolean.valueOf(true))));
        out.add(Component.m_237113_((String)"    \u00a7l\u041d\u0435\u0431\u0435\u0441\u043d\u044b\u0439 \u041a\u0440\u0430\u0439\u00a7r\u00a77, x=0 y=90 z=0").m_6270_(Style.f_131099_.m_178520_(0xAAAAAA)));
        out.add(Component.m_237113_((String)""));
        out.add(LocalizeUtils.defDivider(Col.fromHex((String)"#faff70"), Col.fromHex((String)"#6cfec2")));
        out.add(Component.m_237113_((String)""));
        out.forEach(arg_0 -> ((ServerPlayer)player).m_213846_(arg_0));
        player.m_6330_((SoundEvent)SoundRegistry.EVIL_LAUGH.get(), SoundSource.HOSTILE, 2.0f, 0.875f);
        player.m_5661_((Component)Component.m_237113_((String)"\u2620 \u041d\u0435\u0431\u0435\u0441\u043d\u044b\u0439 \u0441\u0442\u0440\u0430\u0436 \u043f\u0440\u0438\u0431\u044b\u043b \u2620").m_130948_((Style)DotStyle.of().color(Col.fromHex((String)"3f0000")).effect((DotStyle.StyleEffect)DotStyleEffects.ShakeFX.of((float)0.3f)).effect((DotStyle.StyleEffect)DotStyleEffects.OutlineFX.of((Col)Col.red, (boolean)true))), true);
    }

    public static boolean bordersTar(BlockGetter world, int x, int y, int z) {
        for (int i = x - 4; i <= x + 4; ++i) {
            for (int j = y; j <= y + 1; ++j) {
                for (int k = z - 4; k <= z + 4; ++k) {
                    if (world.m_8055_(new BlockPos(i, j, k)).m_60734_() != ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "smoldering_tar"))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static void drop(Level level, Vec3 pos, @Nullable ItemStack item) {
        if (item != null) {
            level.m_7967_((Entity)new ItemEntity(level, pos.f_82479_, pos.f_82480_, pos.f_82481_, item));
        }
    }

    public static Block getBlock(String registryName) {
        return (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", registryName));
    }

    public static BlockState getBlockState(String registryName) {
        return ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", registryName))).m_49966_();
    }

    public static CompoundTag getPlayerData(Player player) {
        CompoundTag entityData;
        CompoundTag persistentData = player.getPersistentData();
        if (persistentData.m_128441_("PlayerPersisted")) {
            entityData = persistentData.m_128469_("PlayerPersisted");
        } else {
            entityData = new CompoundTag();
            persistentData.m_128365_("PlayerPersisted", (Tag)entityData);
        }
        return entityData;
    }

    public static Tag setPlayerData(Player player, CompoundTag data) {
        return player.getPersistentData().m_128365_("PlayerPersisted", (Tag)data);
    }

    public static boolean isPotion(ItemStack stack, Potion potion) {
        return (stack.m_150930_(Items.f_42589_) || stack.m_150930_(Items.f_42736_) || stack.m_150930_(Items.f_42739_)) && PotionUtils.m_43579_((ItemStack)stack) == potion;
    }

    public static BlockPos getNearbySpawnPos(ServerLevel level, RandomSource random, BlockPos position) {
        BlockState state;
        int x = position.m_123341_() + random.m_188503_(16) - 8;
        int z = position.m_123343_() + random.m_188503_(16) - 8;
        int y = Surface.getSurface(Surface.Surface_Type.HIGHEST_GROUND, Surface.Mode.FULL, 64, 250, 1, (WorldGenLevel)level, random, x, z);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(x, y, z);
        while ((state = level.m_8055_((BlockPos)pos)).m_204336_(BlockTags.f_13035_) || state.m_204336_(BlockTags.f_144279_)) {
            pos.m_122173_(Direction.DOWN);
        }
        pos.m_122173_(Direction.UP);
        while (level.m_8055_((BlockPos)pos).m_204336_(BlockTags.f_144279_)) {
            pos.m_122173_(Direction.UP);
        }
        return pos;
    }

    public static BlockPos adjustHeight(ServerLevel level, BlockPos.MutableBlockPos pos) {
        while (!level.m_8055_((BlockPos)pos).m_60795_()) {
            pos.m_122173_(Direction.UP);
        }
        while (level.m_8055_((BlockPos)pos).m_60795_()) {
            pos.m_122173_(Direction.DOWN);
        }
        return pos.m_122173_(Direction.UP);
    }

    public static float rotlerp(float rot, float g, float bound) {
        float f1;
        float f = Mth.m_14177_((float)(g - rot));
        if (f > bound) {
            f = bound;
        }
        if (f < -bound) {
            f = -bound;
        }
        if ((f1 = rot + f) < 0.0f) {
            f1 += 360.0f;
        } else if (f1 > 360.0f) {
            f1 -= 360.0f;
        }
        return f1;
    }
}

