/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.util.teleport;

import divinerpg.blocks.base.BlockModPortal;
import divinerpg.registries.LevelRegistry;
import divinerpg.registries.SoundRegistry;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class VetheaTeleporter
implements ITeleporter {
    private boolean isPortalTravel;

    public VetheaTeleporter(boolean isPortalTravel) {
        this.isPortalTravel = isPortalTravel;
    }

    public boolean isVanilla() {
        return false;
    }

    public boolean playTeleportSound(ServerPlayer player, ServerLevel sourceWorld, ServerLevel destWorld) {
        player.m_5496_((SoundEvent)SoundRegistry.VETHEA_TELEPORT.get(), 1.0f, 1.0f);
        return false;
    }

    @Nullable
    public PortalInfo getPortalInfo(Entity entity, ServerLevel destWorld, Function<ServerLevel, PortalInfo> defaultPortalInfo) {
        if (entity instanceof ServerPlayer && !((ServerPlayer)entity).m_20092_()) {
            ServerPlayer player = (ServerPlayer)entity;
            player.m_20091_();
            if (destWorld.m_46472_() == LevelRegistry.VETHEA && !this.isPortalTravel) {
                BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos(entity.m_20183_().m_123341_(), destWorld.m_141937_() + 1, entity.m_20183_().m_123343_());
                while (!destWorld.m_8055_((BlockPos)mut).m_60795_() && mut.m_123342_() < 35) {
                    mut.m_122173_(Direction.UP);
                }
                while (!destWorld.m_8055_(mut.m_7494_()).m_60795_() || !destWorld.m_8055_((BlockPos)mut).m_60795_() || destWorld.m_8055_(mut.m_7495_()).m_60795_()) {
                    mut.m_122173_(Direction.NORTH);
                }
                return new PortalInfo(new Vec3((double)mut.m_123341_() + entity.m_20185_() % 1.0, (double)mut.m_123342_() + 0.5, (double)mut.m_123343_() + entity.m_20189_() % 1.0), entity.m_20184_(), entity.m_146908_(), entity.m_146909_());
            }
            ChunkPos chunkPos = new ChunkPos(entity.m_20183_());
            int chunkX = chunkPos.f_45578_;
            int chunkZ = chunkPos.f_45579_;
            for (int currentChunkX = chunkX - 4; currentChunkX < chunkX + 4; ++currentChunkX) {
                for (int currentChunkZ = chunkZ - 4; currentChunkZ < chunkZ + 4; ++currentChunkZ) {
                    BlockPos.MutableBlockPos searchPos = new BlockPos.MutableBlockPos();
                    int baseX = chunkX * 16;
                    int baseZ = chunkZ * 16;
                    for (int y = 0; y < 256; ++y) {
                        for (int x = 0; x < 16; ++x) {
                            for (int z = 0; z < 16; ++z) {
                                searchPos.m_122178_(baseX + x, y, baseZ + z);
                                BlockState searchState = destWorld.m_8055_((BlockPos)searchPos).m_60734_().m_49966_();
                                if (searchState != ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "vethea_portal"))).m_49966_() && searchState != ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "nightmare_bed"))).m_49966_()) continue;
                                return new PortalInfo(new Vec3((double)searchPos.m_123341_() + entity.m_20185_() % 1.0, (double)(searchPos.m_123342_() - (this.isBlockPortal(destWorld, searchPos.m_123341_(), searchPos.m_123342_() - 1, searchPos.m_123343_()) ? 1 : 0)), (double)searchPos.m_123343_() + entity.m_20189_() % 1.0), Vec3.f_82478_, entity.m_146908_(), entity.m_146909_());
                            }
                        }
                    }
                }
            }
            if (player.m_8961_() != null && player.m_8963_() == destWorld.m_46472_()) {
                return new PortalInfo(new Vec3((double)player.m_8961_().m_123341_(), (double)player.m_8961_().m_123342_(), (double)player.m_8961_().m_123343_()), Vec3.f_82478_, player.m_8962_(), player.m_8962_());
            }
            BlockPos.MutableBlockPos pos = entity.m_20183_().m_122032_();
            while (!destWorld.m_8055_((BlockPos)pos).m_60795_()) {
                pos.m_122173_(Direction.UP);
            }
            int x = pos.m_123341_();
            int y = pos.m_123342_();
            int z = pos.m_123343_();
            for (int i = 0; i < 5; ++i) {
                for (int j = 0; j < 5; ++j) {
                    for (int k = 0; k < 6; ++k) {
                        destWorld.m_7731_(new BlockPos(x + i - 3, y + j + 1, z + k - 4), Blocks.f_50016_.m_49966_(), 0);
                    }
                }
            }
            destWorld.m_7731_(new BlockPos(x + 1, y, z), ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "mortum_block"))).m_49966_(), 0);
            destWorld.m_7731_(new BlockPos(x, y, z), ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "mortum_block"))).m_49966_(), 0);
            destWorld.m_7731_(new BlockPos(x + 2, y, z), ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "mortum_block"))).m_49966_(), 0);
            destWorld.m_7731_(new BlockPos(x + 1, y + 1, z - 1), ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "mortum_block"))).m_49966_(), 0);
            destWorld.m_7731_(new BlockPos(x + 1, y + 1, z + 1), ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "mortum_block"))).m_49966_(), 0);
            destWorld.m_7731_(new BlockPos(x + 1, y + 2, z - 2), ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "mortum_block"))).m_49966_(), 0);
            destWorld.m_7731_(new BlockPos(x + 1, y + 2, z + 2), ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "mortum_block"))).m_49966_(), 0);
            destWorld.m_7731_(new BlockPos(x + 1, y + 3, z + 1), ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "mortum_block"))).m_49966_(), 0);
            destWorld.m_7731_(new BlockPos(x + 1, y + 3, z - 1), ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "mortum_block"))).m_49966_(), 0);
            destWorld.m_7731_(new BlockPos(x + 1, y + 4, z), ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "mortum_block"))).m_49966_(), 0);
            destWorld.m_7731_(new BlockPos(x + 1, y + 1, z), (BlockState)((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "vethea_portal"))).m_49966_().m_61124_(BlockModPortal.AXIS, (Comparable)Direction.Axis.Z), 0);
            destWorld.m_7731_(new BlockPos(x + 1, y + 2, z + 1), (BlockState)((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "vethea_portal"))).m_49966_().m_61124_(BlockModPortal.AXIS, (Comparable)Direction.Axis.Z), 0);
            destWorld.m_7731_(new BlockPos(x + 1, y + 2, z), (BlockState)((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "vethea_portal"))).m_49966_().m_61124_(BlockModPortal.AXIS, (Comparable)Direction.Axis.Z), 0);
            destWorld.m_7731_(new BlockPos(x + 1, y + 2, z - 1), (BlockState)((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "vethea_portal"))).m_49966_().m_61124_(BlockModPortal.AXIS, (Comparable)Direction.Axis.Z), 0);
            destWorld.m_7731_(new BlockPos(x + 1, y + 3, z), (BlockState)((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "vethea_portal"))).m_49966_().m_61124_(BlockModPortal.AXIS, (Comparable)Direction.Axis.Z), 0);
            return new PortalInfo(new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), Vec3.f_82478_, entity.m_146908_(), entity.m_146909_());
        }
        return null;
    }

    public boolean isBlockPortal(ServerLevel var1, int var2, int var3, int var4) {
        return var1.m_8055_(new BlockPos(var2, var3, var4)).m_60734_().m_49966_() == ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "vethea_portal"))).m_49966_();
    }
}

