/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world;

import com.google.common.collect.ImmutableList;
import divinerpg.registries.BlockRegistry;
import divinerpg.registries.FeatureRegistry;
import divinerpg.registries.TagsRegistry;
import divinerpg.util.Utils;
import divinerpg.world.feature.config.RuleTestConfig;
import divinerpg.world.feature.config.ruins.RuinsFeatureConfig;
import divinerpg.world.feature.config.tree.TreeConfig;
import divinerpg.world.feature.config.tree_grower.JTreeConfig;
import divinerpg.world.feature.config.tree_grower.foliageplacer.SphericalFoliagePlacer;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.LakeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SpringConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.NoiseProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.ForkingTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="divinerpg", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class ConfiguredFeatureKeys {
    public static final RuleTest EUCA_GRASS = new TagMatchTest(TagsRegistry.EUCA_GRASS);
    public static final ResourceKey<ConfiguredFeature<?, ?>> DIVINE_TREE = ConfiguredFeatureKeys.registerKey("divine_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TAR_LAKE = ConfiguredFeatureKeys.registerKey("tar_lake");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TWILIGHT_TAR_LAKE = ConfiguredFeatureKeys.registerKey("twilight_tar_lake");
    public static final ResourceKey<ConfiguredFeature<?, ?>> EDEN_TREE = ConfiguredFeatureKeys.registerKey("eden_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> EDEN_BUSH = ConfiguredFeatureKeys.registerKey("eden_bush");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WILDWOOD_TREE = ConfiguredFeatureKeys.registerKey("wildwood_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> APALACHIA_TREE = ConfiguredFeatureKeys.registerKey("apalachia_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SKYTHERN_TREE = ConfiguredFeatureKeys.registerKey("skythern_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SKYTHERN_BUSH = ConfiguredFeatureKeys.registerKey("skythern_bush");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MORTUM_TREE = ConfiguredFeatureKeys.registerKey("mortum_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MORTUM_BUSH = ConfiguredFeatureKeys.registerKey("mortum_bush");
    public static final ResourceKey<ConfiguredFeature<?, ?>> EUCA_GOLD_TREE = ConfiguredFeatureKeys.registerKey("euca_gold_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> EUCA_GREEN_TREE = ConfiguredFeatureKeys.registerKey("euca_green_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> EUCA_BOULDER = ConfiguredFeatureKeys.registerKey("euca_boulder");
    public static final ResourceKey<ConfiguredFeature<?, ?>> EUCA_GOLDITE_RUINS = ConfiguredFeatureKeys.registerKey("euca_goldite_ruins");
    public static final ResourceKey<ConfiguredFeature<?, ?>> EUCA_RUINS = ConfiguredFeatureKeys.registerKey("euca_ruins");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MEKYUM_ORE = ConfiguredFeatureKeys.registerKey("mekyum_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CELESTIUM_ORE = ConfiguredFeatureKeys.registerKey("celestium_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> KORITE_ORE = ConfiguredFeatureKeys.registerKey("korite_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> GOLDITE_VEG = ConfiguredFeatureKeys.registerKey("goldite_veg");
    public static final ResourceKey<ConfiguredFeature<?, ?>> GOLD_VEG = ConfiguredFeatureKeys.registerKey("gold_veg");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SINGLE_EUCA_GRASS = ConfiguredFeatureKeys.registerKey("gold_grass");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SINGLE_GOLDITE_STALKS = ConfiguredFeatureKeys.registerKey("goldite_stalks");
    public static final ResourceKey<ConfiguredFeature<?, ?>> EUCA_WATER = ConfiguredFeatureKeys.registerKey("euca_water");
    public static final ResourceKey<ConfiguredFeature<?, ?>> GOLD_BOT_SPAWNER = ConfiguredFeatureKeys.registerKey("gold_bot_spawner");
    public static final ResourceKey<ConfiguredFeature<?, ?>> EUCA_PUMPKIN = ConfiguredFeatureKeys.registerKey("euca_pumpkin");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SHIVERSPINE_TREE = ConfiguredFeatureKeys.registerKey("shiverspine_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DEAD_SHIVERSPINE = ConfiguredFeatureKeys.registerKey("dead_shiverspine");
    public static final ResourceKey<ConfiguredFeature<?, ?>> AURORAOAK_TREE = ConfiguredFeatureKeys.registerKey("auroraoak_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> COZYBARK_TREE = ConfiguredFeatureKeys.registerKey("cozybark_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> COZYBARK_STUMP = ConfiguredFeatureKeys.registerKey("cozybark_stump");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FRACTAL_TREE = ConfiguredFeatureKeys.registerKey("fractal_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> STREAMLEAF_TREE = ConfiguredFeatureKeys.registerKey("streamleaf_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> GLOWSPROUT = ConfiguredFeatureKeys.registerKey("glowsprout");
    public static final ResourceKey<ConfiguredFeature<?, ?>> LOWSPROUT = ConfiguredFeatureKeys.registerKey("lowsprout");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SLOWSPROUT = ConfiguredFeatureKeys.registerKey("slowsprout");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SHIVERSPINE_BUSH = ConfiguredFeatureKeys.registerKey("shiverspine_bush");
    public static final ResourceKey<ConfiguredFeature<?, ?>> COZYBARK_BUSH = ConfiguredFeatureKeys.registerKey("cozybark_bush");
    public static final ResourceKey<ConfiguredFeature<?, ?>> GEOTHERMAL_POND = ConfiguredFeatureKeys.registerKey("geothermal_pond");
    public static final ResourceKey<ConfiguredFeature<?, ?>> GLACIAL_POND = ConfiguredFeatureKeys.registerKey("glacial_pond");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MINERAL_POND = ConfiguredFeatureKeys.registerKey("mineral_pond");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BRITTLE_POND = ConfiguredFeatureKeys.registerKey("brittle_pond");
    public static final ResourceKey<ConfiguredFeature<?, ?>> THERMAL_VENT = ConfiguredFeatureKeys.registerKey("thermal_vent");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FROZEN_LIGHT = ConfiguredFeatureKeys.registerKey("frozen_light");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BRITTLE_PLANTS = ConfiguredFeatureKeys.registerKey("brittle_plants");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BRITTLE_CAVES_VEGETATION = ConfiguredFeatureKeys.registerKey("brittle_caves_vegetation");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WHALE_SKELETON = ConfiguredFeatureKeys.registerKey("whale_skeleton");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SNOW_COVERAGE = ConfiguredFeatureKeys.registerKey("snow_coverage");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SNOW_SPREADER = ConfiguredFeatureKeys.registerKey("snow_spreader");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ARCANA_DUNGEON = ConfiguredFeatureKeys.registerKey("arcana_dungeon");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ARCANA_TAR_LAKE = ConfiguredFeatureKeys.registerKey("arcana_tar_lake");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ARCANITE_VINES = ConfiguredFeatureKeys.registerKey("arcanite_vines");

    private ConfiguredFeatureKeys() {
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)new ResourceLocation("divinerpg", name));
    }

    public static void bootstrap(BootstapContext<ConfiguredFeature<?, ?>> context) {
        ConfiguredFeatureKeys.register(context, DIVINE_TREE, (Feature)FeatureRegistry.DIVINE_TREE.get(), new TreeConfig(Utils.getBlockState("divine_log"), (BlockState)Utils.getBlockState("divine_leaves").m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), (List<RuleTest>)ImmutableList.of()));
        ConfiguredFeatureKeys.register(context, TAR_LAKE, Feature.f_65783_, new LakeFeature.Configuration((BlockStateProvider)BlockStateProvider.m_191382_((Block)Utils.getBlock("smoldering_tar")), (BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50069_)));
        ConfiguredFeatureKeys.register(context, TWILIGHT_TAR_LAKE, Feature.f_65783_, new LakeFeature.Configuration((BlockStateProvider)BlockStateProvider.m_191382_((Block)Utils.getBlock("smoldering_tar")), (BlockStateProvider)BlockStateProvider.m_191382_((Block)Utils.getBlock("twilight_stone"))));
        ConfiguredFeatureKeys.register(context, EDEN_TREE, (Feature)FeatureRegistry.EDEN_TREE.get(), new TreeConfig(Utils.getBlockState("eden_log"), (BlockState)Utils.getBlockState("eden_leaves").m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), (List<RuleTest>)ImmutableList.of()));
        ConfiguredFeatureKeys.register(context, EDEN_BUSH, (Feature)FeatureRegistry.BUSH.get(), new TreeConfig(Utils.getBlockState("eden_log"), (BlockState)Utils.getBlockState("eden_leaves").m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), (List<RuleTest>)ImmutableList.of()));
        ConfiguredFeatureKeys.register(context, WILDWOOD_TREE, (Feature)FeatureRegistry.WILDWOOD_TREE.get(), new TreeConfig(Utils.getBlockState("wildwood_log"), (BlockState)Utils.getBlockState("wildwood_leaves").m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), (List<RuleTest>)ImmutableList.of()));
        ConfiguredFeatureKeys.register(context, APALACHIA_TREE, (Feature)FeatureRegistry.APALACHIA_TREE.get(), new TreeConfig(Utils.getBlockState("apalachia_log"), (BlockState)Utils.getBlockState("apalachia_leaves").m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), (List<RuleTest>)ImmutableList.of()));
        ConfiguredFeatureKeys.register(context, SKYTHERN_TREE, (Feature)FeatureRegistry.SKYTHERN_TREE.get(), new TreeConfig(Utils.getBlockState("skythern_log"), (BlockState)Utils.getBlockState("skythern_leaves").m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), (List<RuleTest>)ImmutableList.of()));
        ConfiguredFeatureKeys.register(context, SKYTHERN_BUSH, (Feature)FeatureRegistry.BUSH.get(), new TreeConfig(Utils.getBlockState("skythern_log"), (BlockState)Utils.getBlockState("skythern_leaves").m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), (List<RuleTest>)ImmutableList.of()));
        ConfiguredFeatureKeys.register(context, MORTUM_TREE, (Feature)FeatureRegistry.MORTUM_TREE.get(), new TreeConfig(Utils.getBlockState("mortum_log"), (BlockState)Utils.getBlockState("mortum_leaves").m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), (List<RuleTest>)ImmutableList.of()));
        ConfiguredFeatureKeys.register(context, MORTUM_BUSH, (Feature)FeatureRegistry.BUSH.get(), new TreeConfig(Utils.getBlockState("mortum_log"), (BlockState)Utils.getBlockState("mortum_leaves").m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), (List<RuleTest>)ImmutableList.of()));
        ConfiguredFeatureKeys.register(context, EUCA_GOLD_TREE, (Feature)FeatureRegistry.JTREE.get(), new JTreeConfig.JTreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)BlockRegistry.euca_gold_log.get())), (TrunkPlacer)new ForkingTrunkPlacer(4, 1, 6), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)BlockRegistry.euca_gold_leaves.get())), (FoliagePlacer)new SphericalFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)3), (IntProvider)ConstantInt.m_146483_((int)1), 1), (FeatureSize)new TwoLayersFeatureSize(1, 1, 2)).ignoreVines().dirt((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)BlockRegistry.goldite_dirt.get()))).build());
        ConfiguredFeatureKeys.register(context, EUCA_GREEN_TREE, (Feature)FeatureRegistry.JTREE.get(), new JTreeConfig.JTreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)BlockRegistry.euca_brown_log.get())), (TrunkPlacer)new ForkingTrunkPlacer(4, 1, 6), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)BlockRegistry.euca_green_leaves.get())), (FoliagePlacer)new SphericalFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)3), (IntProvider)ConstantInt.m_146483_((int)1), 1), (FeatureSize)new TwoLayersFeatureSize(1, 1, 2)).ignoreVines().dirt((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)BlockRegistry.goldite_dirt.get()))).build());
        ConfiguredFeatureKeys.register(context, EUCA_BOULDER, Feature.f_65780_, new BlockStateConfiguration(((Block)BlockRegistry.goldite_cobblestone.get()).m_49966_()));
        ConfiguredFeatureKeys.register(context, EUCA_GOLDITE_RUINS, (Feature)FeatureRegistry.RUINS.get(), new RuinsFeatureConfig(EUCA_GRASS, (BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50087_), new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)((Block)BlockRegistry.euca_square_bricks.get()).m_49966_(), 3).m_146271_((Object)((Block)BlockRegistry.euca_square_runic_bricks.get()).m_49966_(), 1).m_146271_((Object)((Block)BlockRegistry.euca_runic_bricks.get()).m_49966_(), 2)), 8, 6, 9, BuiltInLootTables.f_78743_));
        ConfiguredFeatureKeys.register(context, EUCA_RUINS, (Feature)FeatureRegistry.RUINS.get(), new RuinsFeatureConfig(EUCA_GRASS, (BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50087_), new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)((Block)BlockRegistry.euca_square_bricks.get()).m_49966_(), 3).m_146271_((Object)((Block)BlockRegistry.euca_square_runic_bricks.get()).m_49966_(), 1).m_146271_((Object)((Block)BlockRegistry.euca_runic_bricks.get()).m_49966_(), 2)), 7, 6, 9, BuiltInLootTables.f_78743_));
        ConfiguredFeatureKeys.register(context, MEKYUM_ORE, Feature.f_65731_, new OreConfiguration((RuleTest)new TagMatchTest(BlockTags.f_144266_), ((Block)BlockRegistry.mekyum_ore.get()).m_49966_(), 8));
        ConfiguredFeatureKeys.register(context, CELESTIUM_ORE, Feature.f_65731_, new OreConfiguration((RuleTest)new TagMatchTest(BlockTags.f_144266_), ((Block)BlockRegistry.celestium_ore.get()).m_49966_(), 8));
        ConfiguredFeatureKeys.register(context, KORITE_ORE, Feature.f_65731_, new OreConfiguration((RuleTest)new TagMatchTest(BlockTags.f_144266_), ((Block)BlockRegistry.korite_ore.get()).m_49966_(), 8));
        ConfiguredFeatureKeys.register(context, GOLDITE_VEG, Feature.f_65761_, new RandomPatchConfiguration(40, 6, 2, PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new NoiseProvider(2345L, new NormalNoise.NoiseParameters(0, 1.0, new double[0]), 0.020833334f, List.of(((Block)BlockRegistry.goldite_tall_grass.get()).m_49966_(), ((Block)BlockRegistry.goldite_stalks.get()).m_49966_(), ((Block)BlockRegistry.goldite_flower.get()).m_49966_(), ((Block)BlockRegistry.goldite_bulb.get()).m_49966_()))))));
        ConfiguredFeatureKeys.register(context, GOLD_VEG, Feature.f_65761_, new RandomPatchConfiguration(96, 6, 2, PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new NoiseProvider(2345L, new NormalNoise.NoiseParameters(0, 1.0, new double[0]), 0.020833334f, List.of(((Block)BlockRegistry.euca_tall_flowers.get()).m_49966_(), ((Block)BlockRegistry.euca_tall_grass.get()).m_49966_(), ((Block)BlockRegistry.euca_blue_flower.get()).m_49966_()))))));
        ConfiguredFeatureKeys.register(context, SINGLE_GOLDITE_STALKS, Feature.f_65741_, new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((Block)BlockRegistry.goldite_stalks.get()).m_49966_())));
        ConfiguredFeatureKeys.register(context, SINGLE_EUCA_GRASS, Feature.f_65741_, new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((Block)BlockRegistry.euca_tall_grass.get()).m_49966_())));
        ConfiguredFeatureKeys.register(context, EUCA_WATER, (Feature)FeatureRegistry.EUCA_WATER_GEN.get(), new SpringConfiguration(Fluids.f_76193_.m_76145_(), false, 4, 1, (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{(Holder)BlockRegistry.goldite_stone.getHolder().get(), (Holder)BlockRegistry.goldite_dirt.getHolder().get()})));
        ConfiguredFeatureKeys.register(context, GOLD_BOT_SPAWNER, (Feature)FeatureRegistry.GOLD_BOT_SPAWNER.get(), NoneFeatureConfiguration.f_67816_);
        ConfiguredFeatureKeys.register(context, EUCA_PUMPKIN, Feature.f_65763_, FeatureUtils.m_206476_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)BlockRegistry.euca_pumpkin.get()))), List.of((Block)BlockRegistry.euca_gold_grass.get())));
        ConfiguredFeatureKeys.register(context, SHIVERSPINE_TREE, (Feature)FeatureRegistry.SHIVERSPINE_TREE.get(), new TreeConfig(Utils.getBlockState("shiverspine_log"), (BlockState)Utils.getBlockState("brittle_leaves").m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), (List<RuleTest>)ImmutableList.of()));
        ConfiguredFeatureKeys.register(context, DEAD_SHIVERSPINE, (Feature)FeatureRegistry.DEAD_SHIVERSPINE.get(), new TreeConfig(Utils.getBlockState("shiverspine_log"), Blocks.f_50493_.m_49966_(), (List<RuleTest>)ImmutableList.of()));
        ConfiguredFeatureKeys.register(context, AURORAOAK_TREE, (Feature)FeatureRegistry.AURORAOAK_TREE.get(), new TreeConfig(Utils.getBlockState("auroraoak_log"), (BlockState)Utils.getBlockState("auroraoak_leaves").m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), (List<RuleTest>)ImmutableList.of()));
        ConfiguredFeatureKeys.register(context, COZYBARK_TREE, (Feature)FeatureRegistry.COZYBARK_TREE.get(), new TreeConfig(Utils.getBlockState("cozybark_log"), (BlockState)Utils.getBlockState("cozybark_leaves").m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), (List<RuleTest>)ImmutableList.of()));
        ConfiguredFeatureKeys.register(context, COZYBARK_STUMP, (Feature)FeatureRegistry.STUMP.get(), new TreeConfig(Utils.getBlockState("cozybark_log"), Utils.getBlockState("roofbell"), (List<RuleTest>)ImmutableList.of()));
        ConfiguredFeatureKeys.register(context, GLOWSPROUT, (Feature)FeatureRegistry.GLOWSPROUT.get(), new TreeConfig(Utils.getBlockState("glowsprout_stem"), Utils.getBlockState("glowsprout_bulb"), (List<RuleTest>)ImmutableList.of()));
        ConfiguredFeatureKeys.register(context, LOWSPROUT, (Feature)FeatureRegistry.LOWSPROUT.get(), new TreeConfig(Utils.getBlockState("lowsprout_stem"), Utils.getBlockState("lowsprout_bulb"), (List<RuleTest>)ImmutableList.of()));
        ConfiguredFeatureKeys.register(context, SLOWSPROUT, (Feature)FeatureRegistry.SLOWSPROUT.get(), new TreeConfig(Utils.getBlockState("slowsprout_stem"), Utils.getBlockState("slowsprout_bulb"), (List<RuleTest>)ImmutableList.of()));
        ConfiguredFeatureKeys.register(context, SHIVERSPINE_BUSH, (Feature)FeatureRegistry.BUSH.get(), new TreeConfig(Utils.getBlockState("shiverspine_log"), (BlockState)Utils.getBlockState("brittle_leaves").m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), (List<RuleTest>)ImmutableList.of()));
        ConfiguredFeatureKeys.register(context, COZYBARK_BUSH, (Feature)FeatureRegistry.BUSH.get(), new TreeConfig(Utils.getBlockState("cozybark_log"), (BlockState)Utils.getBlockState("cozybark_leaves").m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), (List<RuleTest>)ImmutableList.of()));
        ConfiguredFeatureKeys.register(context, STREAMLEAF_TREE, (Feature)FeatureRegistry.STREAMLEAF_TREE.get(), new TreeConfig(Utils.getBlockState("streamleaf_log"), (BlockState)Utils.getBlockState("streamleaf_leaves").m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), (List<RuleTest>)ImmutableList.of()));
        ConfiguredFeatureKeys.register(context, GEOTHERMAL_POND, (Feature)FeatureRegistry.GEOTHERMAL_POND.get(), new RuleTestConfig((List<RuleTest>)ImmutableList.of()));
        ConfiguredFeatureKeys.register(context, GLACIAL_POND, (Feature)FeatureRegistry.GLACIAL_POND.get(), new RuleTestConfig((List<RuleTest>)ImmutableList.of()));
        ConfiguredFeatureKeys.register(context, MINERAL_POND, (Feature)FeatureRegistry.MINERAL_POND.get(), new RuleTestConfig((List<RuleTest>)ImmutableList.of()));
        ConfiguredFeatureKeys.register(context, BRITTLE_POND, (Feature)FeatureRegistry.BRITTLE_POND.get(), new RuleTestConfig((List<RuleTest>)ImmutableList.of()));
        ConfiguredFeatureKeys.register(context, THERMAL_VENT, (Feature)FeatureRegistry.THERMAL_VENT.get(), NoneFeatureConfiguration.f_67816_);
        ConfiguredFeatureKeys.register(context, BRITTLE_PLANTS, (Feature)FeatureRegistry.BRITTLE_PLANTS.get(), NoneFeatureConfiguration.f_67816_);
        ConfiguredFeatureKeys.register(context, BRITTLE_CAVES_VEGETATION, (Feature)FeatureRegistry.BRITTLE_CAVES_VEGETATION.get(), NoneFeatureConfiguration.f_67816_);
        ConfiguredFeatureKeys.register(context, WHALE_SKELETON, (Feature)FeatureRegistry.WHALE_SKELETON.get(), NoneFeatureConfiguration.f_67816_);
        ConfiguredFeatureKeys.register(context, SNOW_COVERAGE, (Feature)FeatureRegistry.SNOW_COVERAGE.get(), NoneFeatureConfiguration.f_67816_);
        ConfiguredFeatureKeys.register(context, SNOW_SPREADER, (Feature)FeatureRegistry.SNOW_SPREADER.get(), NoneFeatureConfiguration.f_67816_);
        ConfiguredFeatureKeys.register(context, FRACTAL_TREE, (Feature)FeatureRegistry.FRACTAL_TREE.get(), new TreeConfig(Blocks.f_50354_.m_49966_(), Blocks.f_50126_.m_49966_(), (List<RuleTest>)ImmutableList.of()));
        ConfiguredFeatureKeys.register(context, ARCANA_DUNGEON, (Feature)FeatureRegistry.ARCANA_DUNGEON.get(), NoneFeatureConfiguration.f_67816_);
        ConfiguredFeatureKeys.register(context, ARCANA_TAR_LAKE, Feature.f_65783_, new LakeFeature.Configuration((BlockStateProvider)BlockStateProvider.m_191382_((Block)Utils.getBlock("smoldering_tar")), (BlockStateProvider)BlockStateProvider.m_191382_((Block)Utils.getBlock("soul_sludge_breakable"))));
        ConfiguredFeatureKeys.register(context, ARCANITE_VINES, (Feature)FeatureRegistry.ARCANITE_VINES.get(), NoneFeatureConfiguration.f_67816_);
    }

    public static void register(BootstapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, Feature<NoneFeatureConfiguration> feature) {
        ConfiguredFeatureKeys.register(context, key, feature, FeatureConfiguration.f_67737_);
    }

    public static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC configuration) {
        context.m_255272_(key, (Object)new ConfiguredFeature(feature, configuration));
    }

    public static Holder.Reference<ConfiguredFeature<?, ?>> getConfiguredFeature(WorldGenLevel level, ResourceKey<ConfiguredFeature<?, ?>> key) {
        return (Holder.Reference)Objects.requireNonNull(level.m_7654_()).m_206579_().m_175515_(Registries.f_256911_).m_203636_(key).get();
    }
}

