/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.feature.config.ruins;

import com.mojang.serialization.Codec;
import divinerpg.world.feature.config.ruins.RuinsFeatureConfig;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class RuinsFeature
extends Feature<RuinsFeatureConfig> {
    public RuinsFeature(Codec<RuinsFeatureConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<RuinsFeatureConfig> context) {
        BlockPos pos = context.m_159777_();
        WorldGenLevel reader = context.m_159774_();
        RandomSource rand = context.m_225041_();
        RuinsFeatureConfig config = (RuinsFeatureConfig)context.m_159778_();
        if (!config.spawnBlock.m_213865_(reader.m_8055_(pos.m_7495_()), rand)) {
            return false;
        }
        BlockPos.MutableBlockPos placePos = pos.m_122032_();
        int columns = rand.m_188503_(config.maxColumns) + 5;
        for (int j1 = 0; j1 < columns; ++j1) {
            int xPos = pos.m_123341_() + rand.m_188503_(config.maxSpreading);
            int zPos = pos.m_123343_() + rand.m_188503_(config.maxSpreading);
            int yPos = reader.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, xPos, zPos);
            int height = 1 + rand.m_188503_(config.maxHeight);
            placePos.m_122178_(xPos, yPos, zPos);
            if (config.spawnBlock.m_213865_(reader.m_8055_(placePos.m_7495_()), rand)) {
                for (int i = 0; i < height; ++i) {
                    reader.m_7731_((BlockPos)placePos, config.ruinedBlocksProvider.m_213972_(rand, (BlockPos)placePos), 2);
                    placePos.m_122173_(Direction.UP);
                }
            }
            if (rand.m_188503_(4) != 0) continue;
            BlockPos chestPos = new BlockPos(pos.m_123341_(), yPos - 2, pos.m_123343_());
            BlockPos spawnPos = new BlockPos(pos.m_123341_(), yPos, pos.m_123343_());
            if (!config.spawnBlock.m_213865_(reader.m_8055_(spawnPos.m_7495_()), rand)) continue;
            BlockState chestState = (BlockState)config.chest.m_213972_(rand, chestPos).m_61124_((Property)ChestBlock.f_51478_, (Comparable)Direction.Plane.HORIZONTAL.m_235690_(rand));
            reader.m_7731_(chestPos, chestState, 2);
            if (!(reader.m_7702_(chestPos) instanceof ChestBlockEntity)) continue;
            ((ChestBlockEntity)Objects.requireNonNull(reader.m_7702_(chestPos))).m_59626_(config.resourceLocation, rand.m_188505_());
        }
        return true;
    }
}

